/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtabm.business.spva;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaExpService;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeDto;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeParam;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;

public class SpecialVaExpServiceDemo
implements SpecialVaExpService {
    private static final String ID = "id";
    private static final Long CUSTOM_A_ID = 1108099398L;
    private static Set<Long> PRESET_SPVAMETHODS = Sets.newHashSet((Object[])new Long[]{CUSTOM_A_ID});

    @Override
    public boolean isAutoCreateSubEntry(DynamicObject spvaTypeDyn) {
        String number = spvaTypeDyn.getString("number");
        return spvaTypeDyn != null && PRESET_SPVAMETHODS.contains(spvaTypeDyn.getLong(ID)) || StringUtils.contains((CharSequence)number, (CharSequence)"LAC_TEST_");
    }

    @Override
    public List<SpecialVaTimeDto> createSubEntry(SpecialVaTimeParam req) {
        DynamicObject specialVaTypeDyn = req.getSpecialVaTypeDyn();
        LocalDate shiftDate = req.getShiftDate();
        if (specialVaTypeDyn == null) {
            return new ArrayList<SpecialVaTimeDto>(10);
        }
        ShiftDto shiftDto = req.getShiftDto();
        LocalDateTime startTime = shiftDate.atTime(9, 0, 0, 0);
        LocalDateTime endTime = shiftDate.atTime(11, 0, 0, 0);
        if (CUSTOM_A_ID.equals(specialVaTypeDyn.getLong(ID)) && this.isFri(shiftDate)) {
            endTime = shiftDate.atTime(11, 30, 0, 0);
        }
        return Lists.newArrayList((Object[])new SpecialVaTimeDto[]{new SpecialVaTimeDto(startTime, endTime)});
    }

    private boolean isFri(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return dayOfWeek == DayOfWeek.FRIDAY;
    }
}

