/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtabm.business.spva;

import java.time.LocalDateTime;
import java.util.Objects;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SpecialVaTimeDto {
    private final LocalDateTime startDateTime;
    private final LocalDateTime endDateTime;

    public SpecialVaTimeDto(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        Objects.requireNonNull(startDateTime, "startDateTime could not be null");
        Objects.requireNonNull(endDateTime, "endDateTime could not be null");
        if (endDateTime.isBefore(startDateTime)) {
            throw new IllegalArgumentException("endDateTime could not before startDateTime");
        }
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public String toString() {
        return "SpecialVaTimeDto{startDateTime=" + this.startDateTime + ", endDateTime=" + this.endDateTime + '}';
    }
}

