/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtabm.business.va;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.sdk.wtc.wtabm.business.spva.SpecialVaTimeDto;
import kd.sdk.wtc.wtabm.business.va.OnCalVaApplyTimeEvent;
import kd.sdk.wtc.wtabm.business.va.VaApplyTimeCalExtPlugin;
import kd.sdk.wtc.wtabm.business.va.VaTimeResult;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftMiddleRuleDto;
import org.apache.commons.lang3.StringUtils;

public class VaApplyTimeCalExtPluginDemo
implements VaApplyTimeCalExtPlugin {
    private static final Log LOG = LogFactory.getLog(VaApplyTimeCalExtPluginDemo.class);
    private static final BigDecimal ONE_HOUR_SECONDS = BigDecimal.valueOf(3600L);

    @Override
    public void onCalVaApplyTimes(OnCalVaApplyTimeEvent onCalVaApplyTimeEvent) {
        long attFileBoId = onCalVaApplyTimeEvent.getAttFileBoId();
        DynamicObject billEntryDyn = onCalVaApplyTimeEvent.getBillEntryDyn();
        String startDateProp = "entrystartdate";
        String endDateProp = "entryenddate";
        String ownDateProp = "owndate";
        String startMethodProp = "entrystartmethod";
        String endMethodProp = "entryendmethod";
        String specialVaTypeProp = "specialvatype";
        String vaTypeProp = "entryvacationtype";
        String dynTypeName = billEntryDyn.getDynamicObjectType().getName();
        if ("wtabm_vainfo".equals(dynTypeName)) {
            startDateProp = "startdate";
            endDateProp = "enddate";
            startMethodProp = "startmethod";
            endMethodProp = "endmethod";
            specialVaTypeProp = "spvacationtype";
            vaTypeProp = "vacationtype";
        }
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billEntryDyn.getString(specialVaTypeProp))) {
            this.calVaLactationItemTime(onCalVaApplyTimeEvent);
            return;
        }
        Date startDate = billEntryDyn.getDate(startDateProp);
        Date endDate = billEntryDyn.getDate(endDateProp);
        Date ownDate = billEntryDyn.getDate(ownDateProp);
        long vaTypeId = billEntryDyn.getLong(vaTypeProp + ".id");
        if (1427604815994683392L == vaTypeId) {
            VaTimeResult vaTimeResult = new VaTimeResult(BigDecimal.ZERO, BigDecimal.ZERO);
            onCalVaApplyTimeEvent.setVaTimeResult(vaTimeResult);
            return;
        }
        LocalDate startLocalDate = startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        Map<Date, ShiftDto> rosterShiftDtoMap = onCalVaApplyTimeEvent.getRosterShiftDtoMap();
        String startMethod = billEntryDyn.getString(startMethodProp);
        String endMethod = billEntryDyn.getString(endMethodProp);
        BigDecimal days = BigDecimal.ZERO;
        BigDecimal hours = BigDecimal.ZERO;
        switch (startMethod) {
            case "0": 
            case "1": {
                LOG.info("startMethod = {}", (Object)startMethod);
                onCalVaApplyTimeEvent.setCancel(true);
                break;
            }
            case "2": {
                double betweenDays = ChronoUnit.DAYS.between(startLocalDate, endLocalDate);
                days = BigDecimal.valueOf(betweenDays += 1.0);
                hours = BigDecimal.valueOf(betweenDays * 10.0);
                break;
            }
            case "3": {
                long times = endDate.getTime() - startDate.getTime();
                long seconds = times / 1000L;
                hours = BigDecimal.valueOf(seconds).divide(ONE_HOUR_SECONDS, 6, RoundingMode.HALF_UP);
                ShiftDto shiftDto = rosterShiftDtoMap.get(ownDate);
                if (shiftDto == null) {
                    LOG.info("\u672a\u83b7\u53d6\u5230\u6392\u73ed\uff0c\u53d6\u6d88\u91cd\u8ba1\u7b97\u65f6\u957f");
                    onCalVaApplyTimeEvent.setCancel(true);
                    return;
                }
                ShiftMiddleRuleDto shiftMiddleRuleDto = shiftDto.getShiftMiddleRuleDto();
                BigDecimal allDayHour = shiftMiddleRuleDto.getAlldayhour();
                days = hours.divide(allDayHour, 6, RoundingMode.HALF_UP);
                break;
            }
        }
        VaTimeResult vaTimeResult = new VaTimeResult(hours, days);
        onCalVaApplyTimeEvent.setVaTimeResult(vaTimeResult);
    }

    private void calVaLactationItemTime(OnCalVaApplyTimeEvent onCalVaApplyTimeEvent) {
        onCalVaApplyTimeEvent.setCancel(false);
        SpecialVaTimeDto specialVaTimeDto = onCalVaApplyTimeEvent.getSpecialVaTimeDto();
        long seconds = Duration.between(specialVaTimeDto.getStartDateTime(), specialVaTimeDto.getEndDateTime()).getSeconds();
        if (seconds < 3600L) {
            seconds = 3600L;
        }
        BigDecimal hours = BigDecimal.valueOf(seconds).divide(ONE_HOUR_SECONDS, 6, RoundingMode.HALF_UP);
        BigDecimal days = hours.divide(BigDecimal.valueOf(8L), 6, RoundingMode.HALF_UP);
        VaTimeResult vaTimeResult = new VaTimeResult(hours, days);
        onCalVaApplyTimeEvent.setVaTimeResult(vaTimeResult);
    }
}

