/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtam.business.applytime.demo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtam.business.applytime.TpApplyTimeCalculateEvent;
import kd.sdk.wtc.wtam.business.applytime.TpApplyTimeCalculateExtPlugin;
import kd.sdk.wtc.wtam.business.applytime.bean.TpApplyTimeCalculateResult;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;

public class TpApplyTimeCalculateDemo
implements TpApplyTimeCalculateExtPlugin {
    @Override
    public void onCalculateApplyTime(TpApplyTimeCalculateEvent event) {
        String startMethod;
        DynamicObject entryDy = event.getEntryDy();
        Map<LocalDate, ShiftDto> shiftMap = event.getShiftMap();
        if (entryDy != null && HRStringUtils.equals((String)(startMethod = entryDy.getString("startmethod")), (String)"3")) {
            BigDecimal allHour = BigDecimal.ZERO;
            BigDecimal allDay = BigDecimal.ZERO;
            Date startDate = entryDy.getDate("startdate");
            LocalDateTime localStartDate = startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
            Date endDate = entryDy.getDate("enddate");
            LocalDateTime localEndDate = endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
            LocalDateTime localDateTime = localStartDate.plusDays(-1L);
            while (localDateTime.compareTo(localEndDate) <= 0) {
                LocalDateTime shiftStart = this.getshiftStartDateTime(localDateTime.toLocalDate(), shiftMap);
                LocalDateTime shiftStartNext = this.getshiftStartDateTime(localDateTime.toLocalDate().plusDays(1L), shiftMap);
                LocalDateTime start = localStartDate.compareTo(shiftStart) > 0 ? localStartDate : shiftStart;
                LocalDateTime end = localEndDate.compareTo(shiftStartNext) < 0 ? localEndDate : shiftStartNext;
                ShiftDto shiftDto = shiftMap.get(localStartDate.toLocalDate());
                if (shiftDto != null) {
                    BigDecimal hour = shiftDto.getShiftMiddleRuleDto().getAlldayhour();
                    if (start.compareTo(end) < 0) {
                        LocalDateTime shiftEnd = this.getshiftEndDateTime(LocalDate.from(localStartDate), shiftMap);
                        if (!localStartDate.isAfter(shiftStart) && !localEndDate.isBefore(shiftEnd)) {
                            BigDecimal day = shiftDto.getShiftMiddleRuleDto().getAllday();
                            allHour = allHour.add(hour);
                            allDay = allDay.add(day);
                        } else {
                            BigDecimal multiply = new BigDecimal(this.toDate(end).getTime()).subtract(new BigDecimal(this.toDate(start).getTime()));
                            BigDecimal valHour = multiply.divide(new BigDecimal(3600000), 6, RoundingMode.HALF_UP);
                            BigDecimal valDay = valHour.divide(hour, 6, RoundingMode.HALF_UP);
                            allHour = allHour.add(valHour);
                            allDay = allDay.add(valDay);
                        }
                    }
                }
                localDateTime = localDateTime.plusDays(1L);
            }
            TpApplyTimeCalculateResult result = event.getResult();
            result.setValHour(allHour);
            result.setValDay(allDay);
        }
    }

    private LocalDateTime getshiftStartDateTime(LocalDate localDate, Map<LocalDate, ShiftDto> shiftMap) {
        ShiftDto shiftDto = shiftMap.get(localDate);
        if (shiftDto.getOffNonPlan()) {
            return this.getshiftStartDateTimeNoPlan(localDate, shiftMap);
        }
        return this.getshiftStartDateTimeHasPlan(localDate, shiftMap);
    }

    private LocalDateTime getshiftStartDateTimeNoPlan(LocalDate localDate, Map<LocalDate, ShiftDto> shiftMap) {
        ShiftDto shiftDto = shiftMap.get(localDate);
        LocalDateTime shiftStart = localDate.atStartOfDay();
        if (shiftDto.getOffNonPlan() && !(shiftDto = shiftMap.get(localDate.plusDays(-1L))).getOffNonPlan()) {
            LocalDateTime preShiftEndDateTime = this.getshiftEndDateTime(localDate.plusDays(-1L), shiftMap);
            shiftStart = shiftStart.compareTo(preShiftEndDateTime) > 0 ? shiftStart : preShiftEndDateTime;
        }
        return shiftStart;
    }

    private LocalDateTime getshiftStartDateTimeHasPlan(LocalDate localDate, Map<LocalDate, ShiftDto> shiftMap) {
        ShiftDto shiftDto = shiftMap.get(localDate);
        LocalDateTime shiftStart = localDate.atStartOfDay();
        if (shiftDto.getOffNonPlan()) {
            return shiftStart;
        }
        if (RefDateType.TODAY.code.equals(shiftDto.getLastRefStartDay())) {
            shiftStart = LocalDateTime.of(localDate, LocalTime.ofSecondOfDay(shiftDto.getLastShiftStartDate()));
        } else if (RefDateType.NEXTDAY.code.equals(shiftDto.getLastRefStartDay())) {
            shiftStart = LocalDateTime.of(localDate.plusDays(1L), LocalTime.ofSecondOfDay(shiftDto.getLastShiftStartDate()));
        } else if (RefDateType.LASTDAY.code.equals(shiftDto.getLastRefStartDay())) {
            shiftStart = LocalDateTime.of(localDate.plusDays(-1L), LocalTime.ofSecondOfDay(shiftDto.getLastShiftStartDate()));
        }
        return shiftStart;
    }

    private LocalDateTime getshiftEndDateTime(LocalDate localDate, Map<LocalDate, ShiftDto> shiftMap) {
        ShiftDto shiftDto = shiftMap.get(localDate);
        LocalDateTime shiftEnd = localDate.plusDays(1L).atStartOfDay();
        if (shiftDto.getOffNonPlan()) {
            return shiftEnd;
        }
        if (RefDateType.TODAY.code.equals(shiftDto.getLastRefEndDay())) {
            shiftEnd = LocalDateTime.of(localDate, LocalTime.ofSecondOfDay(shiftDto.getLastShiftEndDate()));
        } else if (RefDateType.NEXTDAY.code.equals(shiftDto.getLastRefEndDay())) {
            shiftEnd = LocalDateTime.of(localDate.plusDays(1L), LocalTime.ofSecondOfDay(shiftDto.getLastShiftEndDate()));
        } else if (RefDateType.LASTDAY.code.equals(shiftDto.getLastRefEndDay())) {
            shiftEnd = LocalDateTime.of(localDate.plusDays(-1L), LocalTime.ofSecondOfDay(shiftDto.getLastShiftEndDate()));
        }
        return shiftEnd;
    }

    public Date toDate(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return Date.from(localDateTime.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    static enum RefDateType {
        TODAY("D"),
        NEXTDAY("C"),
        LASTDAY("Q");

        public final String code;

        private RefDateType(String code) {
            this.code = code;
        }
    }
}

