/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtbs.common.dto.shift;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.dto.shift.BaseDataDto;

public class ShiftDetailDto
implements Serializable {
    private static final long serialVersionUID = 4772545911728840471L;
    private static final Log LOG = LogFactory.getLog(ShiftDetailDto.class);
    private String outWorkType;
    private String refStartDay;
    private int shiftStartDate;
    private String shiftStartDateStr;
    private String shiftEndDateStr;
    private boolean isWorkTimeStart;
    private Date checkDate;
    private String refEndDay;
    private int shiftEndDate;
    private boolean isWorkTimeEnd;
    private BigDecimal workTime;
    private BaseDataDto shiftPeriod;
    private long startPunchCardPointEntryId;
    private long endPunchCardPointEntryId;

    public boolean isWorkTime() {
        return this.outWorkType.endsWith("W");
    }

    public Date getAbsoluteShiftStartDate() {
        return this.getAbsoluteTime(this.checkDate, this.refStartDay, this.shiftStartDate).getTime();
    }

    public Date getAbsoluteShiftEndDate() {
        return this.getAbsoluteTime(this.checkDate, this.refEndDay, this.shiftEndDate).getTime();
    }

    private Calendar getAbsoluteTime(Date rankDate, String refstart, int startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        if (rankDate == null) {
            return calendar;
        }
        String dateFormat = simpleDateFormat.format(rankDate);
        try {
            calendar.setTime(simpleDateFormat.parse(dateFormat));
            if ("C".equals(refstart)) {
                calendar.add(5, 1);
            } else if ("Q".equals(refstart)) {
                calendar.add(5, -1);
            }
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
        }
        calendar.add(13, startDate);
        return calendar;
    }

    public String getOutWorkType() {
        return this.outWorkType;
    }

    public void setOutWorkType(String outWorkType) {
        this.outWorkType = outWorkType;
    }

    public String getRefStartDay() {
        return this.refStartDay;
    }

    public void setRefStartDay(String refStartDay) {
        this.refStartDay = refStartDay;
    }

    public int getShiftStartDate() {
        return this.shiftStartDate;
    }

    public void setShiftStartDate(int shiftStartDate) {
        this.shiftStartDate = shiftStartDate;
    }

    public boolean isWorkTimeStart() {
        return this.isWorkTimeStart;
    }

    public void setWorkTimeStart(boolean workTimeStart) {
        this.isWorkTimeStart = workTimeStart;
    }

    public Date getCheckDate() {
        return this.checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public String getRefEndDay() {
        return this.refEndDay;
    }

    public void setRefEndDay(String refEndDay) {
        this.refEndDay = refEndDay;
    }

    public int getShiftEndDate() {
        return this.shiftEndDate;
    }

    public void setShiftEndDate(int shiftEndDate) {
        this.shiftEndDate = shiftEndDate;
    }

    public boolean isWorkTimeEnd() {
        return this.isWorkTimeEnd;
    }

    public void setWorkTimeEnd(boolean workTimeEnd) {
        this.isWorkTimeEnd = workTimeEnd;
    }

    public String getShiftStartDateStr() {
        return this.shiftStartDateStr;
    }

    public void setShiftStartDateStr(String shiftStartDateStr) {
        this.shiftStartDateStr = shiftStartDateStr;
    }

    public String getShiftEndDateStr() {
        return this.shiftEndDateStr;
    }

    public void setShiftEndDateStr(String shiftEndDateStr) {
        this.shiftEndDateStr = shiftEndDateStr;
    }

    public BigDecimal getWorkTime() {
        return this.workTime;
    }

    public void setWorkTime(BigDecimal workTime) {
        this.workTime = workTime;
    }

    public long getShiftPeriodId() {
        return this.shiftPeriod == null ? 0L : this.shiftPeriod.getId();
    }

    public BaseDataDto getShiftPeriod() {
        return this.shiftPeriod;
    }

    public void setShiftPeriod(BaseDataDto shiftPeriod) {
        this.shiftPeriod = shiftPeriod;
    }

    public long getStartPunchCardPointEntryId() {
        return this.startPunchCardPointEntryId;
    }

    public void setStartPunchCardPointEntryId(long startPunchCardPointEntryId) {
        this.startPunchCardPointEntryId = startPunchCardPointEntryId;
    }

    public long getEndPunchCardPointEntryId() {
        return this.endPunchCardPointEntryId;
    }

    public void setEndPunchCardPointEntryId(long endPunchCardPointEntryId) {
        this.endPunchCardPointEntryId = endPunchCardPointEntryId;
    }
}

