/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.qte.init;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.wtc.wtes.business.qte.init.BeforeQteCycSetInitEvent;
import kd.sdk.wtc.wtes.business.qte.init.QteCycSetInitExtPlugin;
import kd.sdk.wtc.wtes.business.qte.init.model.CircleConfig;
import kd.sdk.wtc.wtes.business.qte.init.model.CircleRest;
import kd.sdk.wtc.wtes.business.qte.init.model.CircleUnitEnum;

public class QteCycSetInitExtPluginDemo
implements QteCycSetInitExtPlugin {
    @Override
    public void beforeCycsetInit(BeforeQteCycSetInitEvent event) {
        int index = 1;
        Integer interValue = 0;
        Integer cirValue = 0;
        CircleConfig config = event.getConfig();
        Long cycId = config.getId();
        int size = config.getCirValue().size();
        Date endDate = config.getEndDate();
        Integer count = config.getCount();
        Calendar seqBegin = Calendar.getInstance();
        Calendar seqEnd = Calendar.getInstance();
        Calendar sqlDate = Calendar.getInstance();
        seqBegin.setTime(config.getBeginDate());
        seqEnd.setTime(config.getBeginDate());
        boolean isStopGenCir = false;
        while (this.maxCondition(count, index, endDate, seqEnd)) {
            sqlDate.setTime(seqBegin.getTime());
            if (null != endDate && sqlDate.getTimeInMillis() > endDate.getTime()) {
                return;
            }
            cirValue = index > size ? config.getCirValue().get(0) : config.getCirValue().get(index - 1);
            cirValue = index <= 3 ? Integer.valueOf(1) : (index >= 4 && index <= 10 ? Integer.valueOf(5) : Integer.valueOf(6));
            this.getCirDay(config, cirValue, sqlDate);
            seqEnd.setTime(sqlDate.getTime());
            List<Integer> intervals = config.getInterval();
            interValue = !CollectionUtils.isEmpty(intervals) ? (index > intervals.size() ? intervals.get(0) : intervals.get(index - 1)) : Integer.valueOf(0);
            interValue = 0;
            if (null != endDate && seqEnd.getTimeInMillis() > endDate.getTime()) {
                seqEnd.setTime(endDate);
            }
            event.addCircleRestValue(this.buildRest(seqBegin, seqEnd, config, index, cirValue, interValue));
            if (config.isQtCalCall() && null != config.getQtCalEndDate()) {
                if (isStopGenCir) {
                    return;
                }
                if (config.getQtCalEndDate().getTime() < seqEnd.getTime().getTime()) {
                    isStopGenCir = true;
                }
            }
            this.intervalCal(interValue, seqBegin, sqlDate, seqEnd, config);
            ++index;
            this.setBeginDate(seqBegin, sqlDate);
        }
    }

    private CircleRest buildRest(Calendar seqBegin, Calendar seqEnd, CircleConfig config, int index, Integer cirValue, Integer interValue) {
        CircleRest dto = new CircleRest();
        dto.setIndex(index);
        dto.setStartDate(seqBegin.getTime());
        dto.setEndDate(seqEnd.getTime());
        dto.setInterval(interValue);
        dto.setCirValue(cirValue);
        return dto;
    }

    private boolean maxCondition(Integer count, int index, Date endDate, Calendar seqEnd) {
        if (index > count) {
            return false;
        }
        if (null == endDate) {
            return true;
        }
        return true;
    }

    private void setBeginDate(Calendar seqBegin, Calendar sqlDate) {
        seqBegin.setTime(sqlDate.getTime());
    }

    private void intervalCal(Integer cirValue, Calendar seqBegin, Calendar sqlDate, Calendar seqEnd, CircleConfig config) {
        sqlDate.setTime(seqEnd.getTime());
        sqlDate.add(CircleUnitEnum.CIRCLE_UNIT_DAY.getCircle(), 1);
        if (cirValue == 0) {
            return;
        }
        List<Integer> interval = config.getInterval();
        sqlDate.add(config.getIntervalUnit().getCircle(), cirValue);
        seqBegin.setTime(sqlDate.getTime());
    }

    private void getCirDay(CircleConfig config, Integer cirValue, Calendar seqDate) {
        CircleUnitEnum unitEnum = config.getCircleUnitEnum();
        Integer cirDays = 0;
        if (CircleUnitEnum.CIRCLE_UNIT_MONTH == unitEnum) {
            Calendar cirDate = Calendar.getInstance();
            cirDate.setTime(seqDate.getTime());
            for (int i = 1; i <= cirValue; ++i) {
                int monthDay = cirDate.getActualMaximum(5);
                cirDays = cirDays + monthDay;
                cirDate.add(5, monthDay);
            }
            seqDate.add(5, cirDays - 1);
        } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == unitEnum) {
            Date beginDate = config.getBeginDate();
            Calendar beginDateCalendar = Calendar.getInstance();
            beginDateCalendar.setTime(beginDate);
            int month = beginDateCalendar.get(2);
            Date lastDay = this.getEndDayOfMonth(beginDate);
            lastDay = this.getZeroDate(lastDay);
            seqDate.add(1, cirValue);
            if (month == 1 && lastDay.compareTo(beginDate) == 0) {
                Date monthLastDay = this.getEndDayOfMonth(seqDate.getTime());
                seqDate.setTime(monthLastDay);
            }
            seqDate.add(5, -1);
        } else if (CircleUnitEnum.CIRCLE_UNIT_WEEK == unitEnum) {
            for (int i = 1; i <= cirValue; ++i) {
                cirDays = cirDays + 7;
            }
            seqDate.add(5, cirDays - 1);
        } else if (CircleUnitEnum.CIRCLE_UNIT_DAY == unitEnum) {
            seqDate.add(5, cirValue - 1);
        }
    }

    private Date getZeroDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int nowYear = HRDateTimeUtils.getYear((Date)date);
        int nowMonth = this.getNowMonth(date);
        calendar.set(nowYear, nowMonth - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(nowYear, nowMonth - 1, day);
        return this.getDayEndTime(calendar.getTime());
    }

    private Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    private int getNowMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    private Date getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }
}

