/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.qte.init.model;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.wtc.wtes.business.qte.init.model.DataPoint;
import org.apache.commons.collections.CollectionUtils;

@SdkPublic
public class QuotaGenConditionExt {
    public static final String GEN_CONDITION_INIT_KEY = "gen_condition_init";
    private Map<Long, Map<String, List<DataPoint>>> recordDatas;

    public QuotaGenConditionExt(Map<Long, Map<String, List<DataPoint>>> recordDatas) {
        this.recordDatas = recordDatas;
    }

    public Map<String, Object> getConditionValue(Long boid, Date calculateDate) {
        if (boid == null || calculateDate == null || this.recordDatas == null || this.recordDatas.get(boid) == null) {
            return Collections.emptyMap();
        }
        Map<String, List<DataPoint>> conditionDatas = this.recordDatas.get(boid);
        HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)conditionDatas.size());
        for (Map.Entry<String, List<DataPoint>> entry : conditionDatas.entrySet()) {
            String param = entry.getKey();
            List<DataPoint> dataPoints = entry.getValue();
            if (CollectionUtils.isEmpty(dataPoints)) continue;
            for (int index = 0; index < dataPoints.size(); ++index) {
                DataPoint nextDataPoint;
                DataPoint dataPoint = dataPoints.get(index);
                if (dataPoint.getDate() == null) continue;
                DataPoint dataPoint2 = nextDataPoint = index + 1 < dataPoints.size() ? dataPoints.get(index + 1) : null;
                if (nextDataPoint != null && nextDataPoint.getDate() == null) continue;
                if (dataPoint.getDate().before(calculateDate) && (nextDataPoint == null || nextDataPoint.getDate().after(calculateDate))) {
                    conditionMap.put(param, dataPoint.getAfterValue());
                    continue;
                }
                if (index != 0 || !dataPoint.getDate().after(calculateDate)) continue;
                conditionMap.put(param, dataPoint.getBeforeValue());
            }
        }
        return conditionMap;
    }
}

