/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.qte.varcondition;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.wtc.wtbs.common.lang.Nullable;

@SdkPublic
public class AfterQteResolveVarConditionEvent {
    private final long attPersonId;
    private final long attFileBoId;
    private final long attFileVid;
    private final LocalDate baseDate;
    private final Set<Long> baseDataIds;
    private final Date startDay;
    private final Date endDay;
    private Map<Long, BigDecimal> varValue;
    private final Object initDataExt;
    private final Map<String, Object> initData;

    public AfterQteResolveVarConditionEvent(long attPersonId, long attFileBoId, long attFileVid, LocalDate baseDate, Set<Long> baseDataIds, Map<Long, BigDecimal> varValue, Date startDay, Date endDay, Object initDataExt, Map<String, Object> initData) {
        this.attPersonId = attPersonId;
        this.attFileBoId = attFileBoId;
        this.attFileVid = attFileVid;
        this.baseDate = baseDate;
        this.baseDataIds = baseDataIds;
        this.varValue = varValue;
        this.initDataExt = initDataExt;
        this.initData = initData;
        this.startDay = startDay;
        this.endDay = endDay;
    }

    public long getAttPersonId() {
        return this.attPersonId;
    }

    public long getAttFileBoId() {
        return this.attFileBoId;
    }

    public long getAttFileVid() {
        return this.attFileVid;
    }

    public LocalDate getBaseDate() {
        return this.baseDate;
    }

    public Set<Long> getBaseDataIds() {
        return Collections.unmodifiableSet(this.baseDataIds);
    }

    public Date getStartDay() {
        return this.startDay;
    }

    public Date getEndDay() {
        return this.endDay;
    }

    @Nullable
    public BigDecimal getVarValue(Long baseDataId) {
        return this.varValue.get(baseDataId);
    }

    public void setVarValue(Long baseDataId, BigDecimal value) {
        if (this.varValue.containsKey(baseDataId)) {
            this.varValue.put(baseDataId, value);
        }
    }

    public Object getInitDataExt() {
        return this.initDataExt;
    }

    public Map<String, Object> getInitData() {
        return Collections.unmodifiableMap(this.initData);
    }

    public String toString() {
        return "AfterQteResolveVarConditionEvent{attPersonId=" + this.attPersonId + ", attFileBoId=" + this.attFileBoId + ", attFileVid=" + this.attFileVid + ", baseDate=" + this.baseDate + ", baseDataIds=" + this.baseDataIds + ", startDay=" + this.startDay + ", endDay=" + this.endDay + ", varValue=" + this.varValue + ", initDataExt=" + this.initDataExt + ", initData=" + this.initData + '}';
    }
}

