/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.tie.exexutor.att;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContextExt;
import kd.sdk.wtc.wtes.business.tie.exexutor.att.AttEvaluatorExpServiceDefault;
import kd.sdk.wtc.wtes.business.tie.exexutor.att.OnEvaluateAttendanceEndEvent;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.TimeBucketExt;

public class AttEvaluatorExpServiceDemo
extends AttEvaluatorExpServiceDefault {
    private static final Log LOG = LogFactory.getLog(AttEvaluatorExpServiceDemo.class);
    private static final BigDecimal ONE_HOUR_SECOND_DECIMAL = new BigDecimal(3600);

    @Override
    public void onEvaluateAttendanceEnd(OnEvaluateAttendanceEndEvent endEvent) {
        ArrayList itemInstanceExtList = Lists.newArrayList();
        endEvent.setAttItemSpecExtList(itemInstanceExtList);
        List<AttItemInstanceExt> attItemInstanceExts = this.holidaySplit(endEvent);
        itemInstanceExtList.addAll(attItemInstanceExts);
        List<AttItemInstanceExt> flexAttItemInstanceExts = this.flexibleShift(endEvent);
        itemInstanceExtList.addAll(flexAttItemInstanceExts);
    }

    private List<AttItemInstanceExt> flexibleShift(OnEvaluateAttendanceEndEvent endEvent) {
        BigDecimal secondDecimal;
        ArrayList itemInstanceExtList = Lists.newArrayListWithExpectedSize((int)10);
        LOG.info("[\u51fa\u52e4\u6b65\u9aa4\u4e8c\u5f00][\u5f53\u524d\u6838\u7b97\u94fe\u7684\u8003\u52e4\u9879\u76ee]\uff1a{}", endEvent.getCurrentChainAttItemInstanceExtMap());
        LOG.info("[\u51fa\u52e4\u6b65\u9aa4\u4e8c\u5f00][\u5f53\u524d\u9636\u6bb5\u7684\u8003\u52e4\u9879\u76ee]\uff1a{}", endEvent.getCurrentStageAttItemInstanceExtMap());
        LOG.info("[\u51fa\u52e4\u6b65\u9aa4\u4e8c\u5f00][\u5f53\u524d\u9636\u6bb5\u7684\u8003\u52e4\u9879\u76ee]\uff1a{}", (Object)endEvent.getTiePhaseResult());
        TieContextExt tieContextExt = endEvent.getTieContextExt();
        LocalDate calculateDate = tieContextExt.getCalculateDate();
        RosterExt rosterExt = tieContextExt.getRosterExt(calculateDate);
        ShiftSpecExt shiftSpec = rosterExt.getShiftSpec();
        LOG.info("[\u51fa\u52e4\u6b65\u9aa4\u4e8c\u5f00][\u5f53\u524d\u65e5\u671f\u7684\u6392\u73ed]\uff0crosterDate:{},shiftSpec:{}", (Object)calculateDate, (Object)JSON.toJSONString((Object)shiftSpec));
        long lateBid = 1438446745385174016L;
        AttItemSpecExt lateAttItemSpecExt = tieContextExt.getAttItemSpecExt(lateBid, calculateDate);
        AttItemInstanceExt lateInstance = endEvent.getCurrentChainAttItemInstanceExtMap().get(lateBid);
        if (lateInstance != null && (secondDecimal = lateInstance.getSecondDecimal()).compareTo(ONE_HOUR_SECOND_DECIMAL) < 0) {
            String tiePhaseResult = endEvent.getTiePhaseResult();
            BigDecimal dayDecimal = shiftSpec.secondsToDays(secondDecimal);
            if (StringUtils.equals((CharSequence)tiePhaseResult, (CharSequence)"1")) {
                dayDecimal = BigDecimal.ZERO;
                secondDecimal = BigDecimal.ZERO;
            }
            AttItemInstanceExt instanceExt = new AttItemInstanceExt(lateAttItemSpecExt, secondDecimal.negate(), dayDecimal.negate(), secondDecimal.negate());
            itemInstanceExtList.add(instanceExt);
        }
        long leaveEarlyDuriationBid = 1438447452276392960L;
        AttItemSpecExt earlyLeaveDurationAttItemSpecExt = tieContextExt.getAttItemSpecExt(leaveEarlyDuriationBid, calculateDate);
        BigDecimal dayDecimal = shiftSpec.secondsToDays(ONE_HOUR_SECOND_DECIMAL);
        AttItemInstanceExt instanceExt = new AttItemInstanceExt(earlyLeaveDurationAttItemSpecExt, ONE_HOUR_SECOND_DECIMAL, dayDecimal, ONE_HOUR_SECOND_DECIMAL);
        itemInstanceExtList.add(instanceExt);
        long leaveEarlyTimesBid = 1576191270076809216L;
        AttItemSpecExt earlyLeaveTimesAttItemSpecExt = tieContextExt.getAttItemSpecExt(leaveEarlyTimesBid, calculateDate);
        instanceExt = new AttItemInstanceExt(earlyLeaveTimesAttItemSpecExt, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        itemInstanceExtList.add(instanceExt);
        return itemInstanceExtList;
    }

    private List<AttItemInstanceExt> holidaySplit(OnEvaluateAttendanceEndEvent endEvent) {
        TieContextExt tieContextExt = endEvent.getTieContextExt();
        LocalDate calculateDate = tieContextExt.getCalculateDate();
        Long bid = 1667665341460901888L;
        AttItemSpecExt attItemSpecExt = tieContextExt.getAttItemSpecExt(bid, calculateDate);
        RosterExt rosterExt = tieContextExt.getRosterExt(calculateDate);
        ShiftSpecExt shiftSpec = rosterExt.getShiftSpec();
        RosterExt nextDayrosterExt = tieContextExt.getRosterExt(calculateDate.plusDays(1L));
        Long attrId = rosterExt.getDateAttributeId();
        Long nextDayAttrId = nextDayrosterExt.getDateAttributeId();
        if (!this.isHolday(nextDayAttrId) && !this.isHolday(attrId)) {
            Collections.emptyList();
        }
        List<TimeBucketExt> timeBucketExtList = endEvent.getTimeBucketExtList();
        ArrayList itemInstanceExtList = Lists.newArrayListWithExpectedSize((int)timeBucketExtList.size());
        for (TimeBucketExt timeBucketExt : timeBucketExtList) {
            LocalDateTime localDate;
            LOG.info("timeBucketExt:{}, {}, {}", new Object[]{timeBucketExt.getStartTime(), timeBucketExt.getEndTime(), timeBucketExt.getDateAttribute()});
            LocalDateTime startTime = timeBucketExt.getStartTime();
            LocalDateTime endTime = timeBucketExt.getEndTime();
            if (!this.isHolday(nextDayAttrId)) {
                localDate = calculateDate.plusDays(1L).atStartOfDay();
                endTime = this.min(endTime, localDate);
            }
            if (!this.isHolday(attrId)) {
                localDate = calculateDate.plusDays(1L).atStartOfDay();
                startTime = this.max(startTime, localDate);
            }
            if (!startTime.isBefore(endTime)) continue;
            long millis = Duration.between(startTime, endTime).toMillis();
            BigDecimal secondDecimal = BigDecimal.valueOf((double)millis / 1000.0).setScale(6, RoundingMode.HALF_UP);
            BigDecimal dayDecimal = shiftSpec.secondsToDays(secondDecimal);
            AttItemInstanceExt instanceExt = new AttItemInstanceExt(attItemSpecExt, secondDecimal, dayDecimal, secondDecimal);
            itemInstanceExtList.add(instanceExt);
        }
        return itemInstanceExtList;
    }

    private LocalDateTime max(LocalDateTime ... dateTimes) {
        LocalDateTime max = Arrays.stream(dateTimes).max((d1, d2) -> d1.isAfter((ChronoLocalDateTime<?>)d2) ? 1 : -1).get();
        return max;
    }

    private LocalDateTime min(LocalDateTime ... dateTimes) {
        LocalDateTime min = Arrays.stream(dateTimes).min((d1, d2) -> d1.isAfter((ChronoLocalDateTime<?>)d2) ? 1 : -1).get();
        return min;
    }

    private boolean isHolday(long dateAttributeId) {
        return dateAttributeId == 1220227377297100800L;
    }
}

