/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.tie.exexutor.ex;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContextExt;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.ExEvaluatorEvent;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.ExEvaluatorExpService;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.card.LogicCardExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSessionExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.AttBillTimeBucketExt;

public class EXEvaluatorExpServiceDemo
implements ExEvaluatorExpService {
    private TieContextExt tieContextExt;

    @Override
    public void extraTimeBucket(ExEvaluatorEvent event) {
        this.tieContextExt = event.getTieContextExt();
        List<AttBillTimeBucketExt> attBillTimeBuckets = event.getAttBillTimeBuckets();
        List<LogicCardExt> logicCards = event.getLogicCards();
        List<ShiftSessionExt> shiftSessionExts = event.getShiftSessionExts();
        ArrayList simpleTimeBuckets = Lists.newArrayListWithExpectedSize((int)(attBillTimeBuckets.size() + shiftSessionExts.size()));
        for (AttBillTimeBucketExt bill : attBillTimeBuckets) {
            simpleTimeBuckets.add(new ExSimpleTimeBucket(bill.getStartTime(), bill.getEndTime()));
        }
        for (ShiftSessionExt sessionExt : shiftSessionExts) {
            simpleTimeBuckets.add(new ExSimpleTimeBucket(sessionExt.getAbsoluteShiftStartDate(this.tieContextExt.getCalculateDate()), sessionExt.getAbsoluteShiftEndDate(this.tieContextExt.getCalculateDate())));
        }
        Map<LocalDateTime, List<LogicCardExt>> longListMap = logicCards.stream().collect(Collectors.groupingBy(LogicCardExt::getCardPointSupposed));
        longListMap = new TreeMap<LocalDateTime, List<LogicCardExt>>(longListMap);
        ArrayList cardPointSupposedList = Lists.newArrayList(longListMap.keySet());
        ArrayList res = Lists.newArrayList();
        int i = 0;
        while (i + 1 < cardPointSupposedList.size()) {
            int endDuringSecond;
            LocalDateTime startCardPoint = (LocalDateTime)cardPointSupposedList.get(i);
            LocalDateTime startLogicCards = longListMap.get(startCardPoint).size() > 0 ? longListMap.get(startCardPoint).get(0).getEffectiveCardPoint() : null;
            LocalDateTime endCardPoint = (LocalDateTime)cardPointSupposedList.get(i + 1);
            LocalDateTime endLogicCards = longListMap.get(endCardPoint).size() > 0 ? longListMap.get(endCardPoint).get(0).getEffectiveCardPoint() : null;
            int startDuringSecond = this.calcDuringSecond(startCardPoint, startLogicCards);
            if (startDuringSecond > (endDuringSecond = this.calcDuringSecond(endCardPoint, endLogicCards))) {
                endCardPoint = endCardPoint.plusSeconds(startDuringSecond);
            }
            ExSimpleTimeBucket simpleTimeBucket = new ExSimpleTimeBucket(endLogicCards, endCardPoint, endCardPoint);
            res.addAll(this.deductBillTime(simpleTimeBucket, simpleTimeBuckets));
            i += 2;
        }
        event.setAttItemSpecExtList(res);
    }

    private AttItemInstanceExt attItemInstanceExt(Long bid, ExSimpleTimeBucket simpleTimeBucket) {
        if (bid == null) {
            bid = 1803646758346039296L;
        }
        AttItemSpecExt attItemSpecExt = this.tieContextExt.getAttItemSpecExt(bid, this.tieContextExt.getCalculateDate());
        RosterExt rosterExt = this.tieContextExt.getRosterExt(this.tieContextExt.getCalculateDate());
        ShiftSpecExt shiftSpec = rosterExt.getShiftSpec();
        long millis = Duration.between(simpleTimeBucket.getStartTime(), simpleTimeBucket.getEndTime()).toMillis();
        BigDecimal secondDecimal = BigDecimal.valueOf((double)millis / 1000.0).setScale(6, RoundingMode.HALF_UP);
        BigDecimal dayDecimal = shiftSpec.secondsToDays(secondDecimal);
        AttItemInstanceExt attItemInstanceExt = new AttItemInstanceExt(attItemSpecExt, secondDecimal, dayDecimal, secondDecimal);
        return attItemInstanceExt;
    }

    private int calcDuringSecond(LocalDateTime beginDate, LocalDateTime endDate) {
        return (int)Duration.between(beginDate, endDate).toMillis() / 1000;
    }

    private List<AttItemInstanceExt> deductBillTime(ExSimpleTimeBucket simpleTimeBucket, List<ExSimpleTimeBucket> simpleTimeBuckets) {
        ArrayList res = Lists.newArrayList();
        simpleTimeBuckets.sort(Comparator.comparing(rec$ -> ((ExSimpleTimeBucket)rec$).getStartTime()));
        for (ExSimpleTimeBucket timeBucket : simpleTimeBuckets) {
            if (simpleTimeBucket.getStartTime().compareTo(timeBucket.getStartTime()) < 0 && simpleTimeBucket.getEndTime().compareTo(timeBucket.getStartTime()) > 0 && simpleTimeBucket.getEndTime().compareTo(timeBucket.getEndTime()) < 0) {
                simpleTimeBucket.setEndTime(timeBucket.getStartTime());
                continue;
            }
            if (simpleTimeBucket.getStartTime().compareTo(timeBucket.getStartTime()) > 0 && simpleTimeBucket.getEndTime().compareTo(timeBucket.getEndTime()) > 0 && simpleTimeBucket.getStartTime().compareTo(timeBucket.getEndTime()) < 0) {
                simpleTimeBucket.setStartTime(timeBucket.getEndTime());
                continue;
            }
            if (simpleTimeBucket.getStartTime().compareTo(timeBucket.getStartTime()) < 0 && simpleTimeBucket.getEndTime().compareTo(timeBucket.getEndTime()) > 0) {
                ExSimpleTimeBucket simpleTimeBucketTemp = new ExSimpleTimeBucket(simpleTimeBucket.getStartTime(), simpleTimeBucket.getEndTime(), simpleTimeBucket.getCardPointSupposed());
                simpleTimeBucketTemp.setEndTime(timeBucket.getStartTime());
                res.add(this.attItemInstanceExt(null, simpleTimeBucketTemp));
                simpleTimeBucket.setStartTime(timeBucket.getEndTime());
                continue;
            }
            if (simpleTimeBucket.getStartTime().compareTo(timeBucket.getEndTime()) > 0 || simpleTimeBucket.getEndTime().compareTo(timeBucket.getStartTime()) < 0 || simpleTimeBucket.getStartTime().compareTo(timeBucket.getStartTime()) <= 0 || simpleTimeBucket.getEndTime().compareTo(timeBucket.getEndTime()) >= 0) continue;
            simpleTimeBucket = null;
            break;
        }
        if (simpleTimeBucket != null) {
            res.add(this.attItemInstanceExt(null, simpleTimeBucket));
        }
        return res;
    }

    private static class ExSimpleTimeBucket {
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private LocalDateTime cardPointSupposed;

        private ExSimpleTimeBucket(LocalDateTime startTime, LocalDateTime endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        private ExSimpleTimeBucket(LocalDateTime startTime, LocalDateTime endTime, LocalDateTime cardPointSupposed) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.cardPointSupposed = cardPointSupposed;
        }

        private LocalDateTime getStartTime() {
            return this.startTime;
        }

        private void setStartTime(LocalDateTime startTime) {
            this.startTime = startTime;
        }

        private LocalDateTime getEndTime() {
            return this.endTime;
        }

        private void setEndTime(LocalDateTime endTime) {
            this.endTime = endTime;
        }

        private LocalDateTime getCardPointSupposed() {
            return this.cardPointSupposed;
        }

        private void setCardPointSupposed(LocalDateTime cardPointSupposed) {
            this.cardPointSupposed = cardPointSupposed;
        }
    }
}

