/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.tie.init.bill;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.wtc.wtes.business.tie.init.bill.TvlBillTimeBucketSplitEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.TvlBillTimeBucketSplitExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.roster.RosterExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftSpecExt;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftTableSingleExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.AttBillTimeBucketExt;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class TvlBillTimeBucketSplitExtPluginDemo
implements TvlBillTimeBucketSplitExtPlugin {
    @Override
    public void splitVaBillTimeBucket(TvlBillTimeBucketSplitEvent tvlBillTimeBucketSplitEvent) {
        HashSet timeBucketExtSetRes = Sets.newHashSet();
        for (AttBillTimeBucketExt billTimeBucketExt : tvlBillTimeBucketSplitEvent.getAttBillTimeBucketExtList()) {
            DynamicObject entryRowDy = billTimeBucketExt.getEntryRowDy();
            ShiftTableSingleExt shiftTableSingleExt = tvlBillTimeBucketSplitEvent.getShiftTableExt().shiftTableSingle(billTimeBucketExt.getAttPersonId());
            if (entryRowDy == null || !"3".equals(entryRowDy.getString("startmethod"))) continue;
            LocalDateTime startDate = billTimeBucketExt.getStartTime();
            LocalDateTime endDate = billTimeBucketExt.getEndTime();
            LocalDate shiftstartDate = tvlBillTimeBucketSplitEvent.getStartDate();
            LocalDate shiftendDate = tvlBillTimeBucketSplitEvent.getEndDate();
            HashSet timeBucketExtSet = Sets.newHashSet();
            while (shiftstartDate.compareTo(shiftendDate) <= 0) {
                LocalDateTime end;
                LocalDateTime shiftStart = this.getshiftStartDateTime(shiftstartDate, shiftTableSingleExt);
                LocalDateTime shiftStartNext = this.getshiftStartDateTime(shiftstartDate.plusDays(1L), shiftTableSingleExt);
                LocalDateTime start = startDate.compareTo(shiftStart) > 0 ? startDate : shiftStart;
                LocalDateTime localDateTime = end = endDate.compareTo(shiftStartNext) < 0 ? endDate : shiftStartNext;
                if (start.compareTo(end) < 0) {
                    timeBucketExtSet.add(billTimeBucketExt.newInstanceResetTime(billTimeBucketExt, shiftstartDate, start, end));
                }
                shiftstartDate = shiftstartDate.plusDays(1L);
            }
            if (timeBucketExtSet.isEmpty()) {
                timeBucketExtSet.add(billTimeBucketExt);
            }
            timeBucketExtSetRes.addAll(timeBucketExtSet);
        }
        tvlBillTimeBucketSplitEvent.setAttBillTimeBucketExtList(Lists.newArrayList((Iterable)timeBucketExtSetRes));
    }

    private LocalDateTime getshiftStartDateTime(LocalDate localDate, ShiftTableSingleExt shiftTableSingleExt) {
        RosterExt rosterExt = shiftTableSingleExt.getRoster(localDate);
        ShiftSpecExt shiftSpecExt = rosterExt.getShiftSpec();
        if (shiftSpecExt.isOffNonPlan()) {
            return this.getshiftStartDateTimeNoPlan(localDate, shiftTableSingleExt);
        }
        return this.getshiftStartDateTimeHasPlan(localDate, shiftTableSingleExt);
    }

    private LocalDateTime getshiftStartDateTimeNoPlan(LocalDate localDate, ShiftTableSingleExt shiftTableSingleExt) {
        RosterExt preRosterExt;
        ShiftSpecExt preShiftSpecExt;
        RosterExt rosterExt = shiftTableSingleExt.getRoster(localDate);
        ShiftSpecExt shiftSpecExt = rosterExt.getShiftSpec();
        LocalDateTime shiftStart = localDate.atStartOfDay();
        if (shiftSpecExt.isOffNonPlan() && !(preShiftSpecExt = (preRosterExt = shiftTableSingleExt.getRoster(localDate.plusDays(-1L))).getShiftSpec()).isOffNonPlan()) {
            LocalDateTime preShiftEndDateTime = this.getshiftEndDateTime(localDate.plusDays(-1L), shiftTableSingleExt);
            shiftStart = shiftStart.compareTo(preShiftEndDateTime) > 0 ? shiftStart : preShiftEndDateTime;
        }
        return shiftStart;
    }

    private LocalDateTime getshiftStartDateTimeHasPlan(LocalDate localDate, ShiftTableSingleExt shiftTableSingleExt) {
        RosterExt rosterExt = shiftTableSingleExt.getRoster(localDate);
        ShiftSpecExt shiftSpecExt = rosterExt.getShiftSpec();
        LocalDateTime shiftStart = localDate.atStartOfDay();
        if (shiftSpecExt.isOffNonPlan()) {
            return shiftStart;
        }
        if (RefDateType.TODAY.code.equals(shiftSpecExt.getFirstRefDateType())) {
            shiftStart = LocalDateTime.of(localDate, shiftSpecExt.getEarliestShiftTime());
        } else if (RefDateType.NEXTDAY.code.equals(shiftSpecExt.getFirstRefDateType())) {
            shiftStart = LocalDateTime.of(localDate.plusDays(1L), shiftSpecExt.getEarliestShiftTime());
        } else if (RefDateType.LASTDAY.code.equals(shiftSpecExt.getFirstRefDateType())) {
            shiftStart = LocalDateTime.of(localDate.plusDays(-1L), shiftSpecExt.getEarliestShiftTime());
        }
        return shiftStart;
    }

    private LocalDateTime getshiftEndDateTime(LocalDate localDate, ShiftTableSingleExt shiftTableSingleExt) {
        RosterExt rosterExt = shiftTableSingleExt.getRoster(localDate);
        ShiftSpecExt shiftSpecExt = rosterExt.getShiftSpec();
        LocalDateTime shiftEnd = localDate.plusDays(1L).atStartOfDay();
        if (shiftSpecExt.isOffNonPlan()) {
            return shiftEnd;
        }
        if (RefDateType.TODAY.code.equals(shiftSpecExt.getLastRefDateType())) {
            shiftEnd = LocalDateTime.of(localDate, shiftSpecExt.getLastShiftTime());
        } else if (RefDateType.NEXTDAY.code.equals(shiftSpecExt.getLastRefDateType())) {
            shiftEnd = LocalDateTime.of(localDate.plusDays(1L), shiftSpecExt.getLastShiftTime());
        } else if (RefDateType.LASTDAY.code.equals(shiftSpecExt.getLastRefDateType())) {
            shiftEnd = LocalDateTime.of(localDate.plusDays(-1L), shiftSpecExt.getLastShiftTime());
        }
        return shiftEnd;
    }

    static enum RefDateType {
        TODAY("D"),
        NEXTDAY("C"),
        LASTDAY("Q");

        public final String code;

        private RefDateType(String code) {
            this.code = code;
        }
    }
}

