/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtes.business.tie.init.bill;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.sdk.wtc.wtes.business.tie.init.bill.OnVaBillTimeBucketSplitEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.VaTimeBucketSplitExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.AttBillTimeBucketExt;

public class VaTimeBucketSplitExtPluginDemo
implements VaTimeBucketSplitExtPlugin {
    private static final Set<Long> DISCARD_VACATION_TYPES_WHEN_REPEAT = Sets.newHashSet((Object[])new Long[]{1574704097980843008L});

    @Override
    public void onSplitVaBillTimeBucket(OnVaBillTimeBucketSplitEvent onSplitVaBillTimeBucketEvent) {
        List<AttBillTimeBucketExt> attBillTimeBucketExtList = onSplitVaBillTimeBucketEvent.getAttBillTimeBucketExtList();
        onSplitVaBillTimeBucketEvent.setCancel(false);
        if (attBillTimeBucketExtList.size() <= 1) {
            return;
        }
        attBillTimeBucketExtList.sort((o1, o2) -> {
            if (o1.getRosterDate().equals(o2.getRosterDate())) {
                if (this.isNonTime(o1.getStartTime(), o1.getEndTime())) {
                    return 1;
                }
                if (this.isNonTime(o2.getStartTime(), o2.getEndTime())) {
                    return -1;
                }
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
            return o1.getRosterDate().compareTo(o2.getRosterDate());
        });
        HashSet<AttBillTimeBucketExt> retainAttBillSet = new HashSet<AttBillTimeBucketExt>(attBillTimeBucketExtList);
        for (int xIndex = 0; xIndex < attBillTimeBucketExtList.size(); ++xIndex) {
            AttBillTimeBucketExt left = attBillTimeBucketExtList.get(xIndex);
            for (int yIndex = xIndex + 1; yIndex < attBillTimeBucketExtList.size(); ++yIndex) {
                AttBillTimeBucketExt right = attBillTimeBucketExtList.get(yIndex);
                if (!this.timeRepeat(left, right)) continue;
                if (this.getCheckedVal(left)) {
                    retainAttBillSet.remove(left);
                    continue;
                }
                retainAttBillSet.remove(right);
            }
        }
        onSplitVaBillTimeBucketEvent.setAttBillTimeBucketExtList(Lists.newArrayList(retainAttBillSet));
    }

    private boolean isNonTime(LocalDateTime startTime, LocalDateTime endTime) {
        return startTime == null || endTime == null;
    }

    private boolean getCheckedVal(AttBillTimeBucketExt timeBucket) {
        long leftBillType = timeBucket.getBillType();
        return DISCARD_VACATION_TYPES_WHEN_REPEAT.contains(leftBillType);
    }

    private boolean timeRepeat(AttBillTimeBucketExt left, AttBillTimeBucketExt right) {
        boolean leftNonTime = this.isNonTime(left.getStartTime(), left.getEndTime());
        boolean rightNonTime = this.isNonTime(right.getStartTime(), right.getEndTime());
        if (leftNonTime || rightNonTime) {
            return false;
        }
        return VaTimeBucketSplitExtPluginDemo.hasIntersectionLCRO(left.getStartTime(), left.getEndTime(), right.getStartTime(), right.getEndTime());
    }

    private static boolean hasIntersectionLCRO(LocalDateTime start1, LocalDateTime end1, LocalDateTime start2, LocalDateTime end2) {
        return start1.compareTo(end2) < 0 && start2.compareTo(end1) < 0;
    }
}

