/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtp.business.attfile;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.annotation.SdkService;
import kd.sdk.wtc.wtbs.common.enums.UserModelType;
import kd.sdk.wtc.wtbs.common.lang.Nullable;
import kd.sdk.wtc.wtp.business.attfile.AttFileVersion;
import kd.sdk.wtc.wtp.constants.AttFileSDKKDString;

@SdkService(name="\u6863\u6848\u670d\u52a1\u52a9\u624b")
public class WTPAttFileHelper {
    private static final String ATT_FILE_QUERY_SERVICE = "IAttFileQueryService";
    private static final String METHOD_ATT_FILE_QUERY = "attFileQuery";

    @Nullable
    public static AttFileVersion getAttFile(LocalDate localDate, long userId, UserModelType userType) {
        return (AttFileVersion)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)ATT_FILE_QUERY_SERVICE, (String)METHOD_ATT_FILE_QUERY, (Object[])new Object[]{HRDateTimeUtils.localDate2Date((LocalDate)localDate), userId, userType});
    }

    public static List<AttFileVersion> getAttFileList(LocalDate startDate, LocalDate endDate, Set<Long> userIdList, UserModelType userType, boolean checkAuth) {
        return (List)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)ATT_FILE_QUERY_SERVICE, (String)METHOD_ATT_FILE_QUERY, (Object[])new Object[]{HRDateTimeUtils.localDate2Date((LocalDate)startDate), HRDateTimeUtils.localDate2Date((LocalDate)endDate), userIdList, userType, checkAuth});
    }

    public static Map<String, Map<Long, Boolean>> existBusinessData(Collection<Long> fileBoIds, LocalDate specialDate) {
        HashMap<String, Map<Long, Boolean>> result = new HashMap<String, Map<Long, Boolean>>();
        if (fileBoIds == null || fileBoIds.isEmpty()) {
            return result;
        }
        if (specialDate == null) {
            throw new KDBizException(AttFileSDKKDString.getDateNotNullTips());
        }
        ArrayList<Long> fileBoIdList = new ArrayList<Long>(fileBoIds);
        Date effectDate = Date.from(specialDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        LocalDate maxLocalDate = LocalDate.of(2999, 12, 31);
        Date maxDate = Date.from(maxLocalDate.atStartOfDay().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        HashMap<Long, Map<String, Date>> request = new HashMap<Long, Map<String, Date>>(16);
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        map.put("startdate", effectDate);
        map.put("enddate", maxDate);
        for (Long fileBoId : fileBoIdList) {
            request.put(fileBoId, map);
        }
        WTPAttFileHelper.businessDataQuery(result, fileBoIdList, effectDate, request);
        return result;
    }

    private static void businessDataQuery(Map<String, Map<Long, Boolean>> result, List<Long> fileBoIdList, Date effectDate, Map<Long, Map<String, Date>> request) {
        Map hasBtBillMap;
        Map hasOtBillMap;
        Map hasVaBillMap;
        Map responseMap = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getStopAttendanceEffectiveCards", (Object[])new Object[]{request});
        if (responseMap != null && !responseMap.isEmpty()) {
            result.put("signCardData", responseMap);
        }
        if ((hasVaBillMap = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaApplyBillService", (String)"hasVaBill", (Object[])new Object[]{fileBoIdList, effectDate})) != null && !hasVaBillMap.isEmpty()) {
            result.put("vaBillData", hasVaBillMap);
        }
        if ((hasOtBillMap = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtom", (String)"IOverTimeApplyBillService", (String)"hasValidOtBill", (Object[])new Object[]{fileBoIdList, effectDate})) != null && !hasOtBillMap.isEmpty()) {
            result.put("otBillData", hasOtBillMap);
        }
        if ((hasBtBillMap = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtam", (String)"IBusitripBillService", (String)"hasBtBill", (Object[])new Object[]{fileBoIdList, effectDate})) != null && !hasBtBillMap.isEmpty()) {
            result.put("tpBillData", hasBtBillMap);
        }
    }
}

