/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtp.business.quota.summary;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

final class QTReportUtils {
    private static final Log LOGGER = LogFactory.getLog(QTReportUtils.class);

    QTReportUtils() {
    }

    protected static <T> T filterDyCollection(FilterInfo filterInfo, Class<T> clazz, String key) {
        Object res = null;
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem(key);
        if (filterItemInfo != null) {
            res = filterItemInfo.getValue();
        }
        return (T)res;
    }

    protected static void addQFilter(DynamicObjectCollection dyc, String key, List<QFilter> qFilters) {
        if (dyc != null && dyc.size() > 0) {
            ArrayList<Object> list = new ArrayList<Object>(dyc.size());
            for (DynamicObject dy : dyc) {
                list.add(dy.getPkValue());
            }
            qFilters.add(new QFilter(key, "in", list));
        }
    }

    protected static void addQFilter(DynamicObject dy, String key, List<QFilter> qFilters) {
        if (dy != null && qFilters != null && HRStringUtils.isNotEmpty((String)key)) {
            qFilters.add(new QFilter(key, "=", dy.get("id")));
        }
    }

    protected static Date getBeginDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return QTReportUtils.getDayStartTime(cal.getTime());
    }

    protected static Date getEndDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return QTReportUtils.getDayEndTime(cal.getTime());
    }

    protected static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    protected static Date getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    protected static QFilter getDataRule(Long userId, String appNumber, String entityNumber, String orgKey, String perm, Map<String, Object> customParam) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, perm, customParam == null ? Collections.emptyMap() : customParam});
        LOGGER.info("getDateRule userId={}, appNumber={}, entityNumber={}, perm={}, orgKey={}, customParams={}, filter={}", new Object[]{userId, appNumber, entityNumber, perm, orgKey, customParam, filter});
        QFilter orgFilter = QTReportUtils.getAllPermOrgs(appNumber, entityNumber, orgKey);
        if (filter == null && orgFilter == null) {
            return null;
        }
        if (filter != null && orgFilter != null) {
            return filter.and(orgFilter);
        }
        if (filter != null) {
            return filter;
        }
        return orgFilter;
    }

    protected static QFilter getAllPermOrgs(String appNumber, String entityNumber, String orgKey) {
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        QFilter orgFilter = null;
        HasPermOrgResult allPermOrg = QTReportUtils.getAllPermOrgs0(appId, entityNumber, "47150e89000000ac");
        if (allPermOrg != null && !allPermOrg.hasAllOrgPerm() && !allPermOrg.getHasPermOrgs().isEmpty()) {
            orgFilter = new QFilter(orgKey, "in", (Object)allPermOrg.getHasPermOrgs());
        }
        return orgFilter;
    }

    private static HasPermOrgResult getAllPermOrgs0(String appId, String entityNum, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }
}

