/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtp.business.quota.summary;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.annotation.SdkPlugin;
import kd.sdk.wtc.wtp.business.quota.summary.QTReportUtils;
import kd.sdk.wtc.wtp.business.quota.summary.QTSummaryExpService;

@SdkPlugin(name="\u5b9a\u989d\u6c47\u603b\u62a5\u8868\u9ed8\u8ba4\u63d2\u4ef6(\u6807\u54c1)")
public class QTSummaryServiceDefault
implements QTSummaryExpService {
    private static final String selects = "id,attfileid,attfilebo,attfilebo.id,qttype qtname,qttype.category  qttype,ownvalue,usablevalue,freezevalue,usedvalue,canbeodvalue,useodvalue,pastvalue,invalidvalue,settlementvalue,cdedvalue";

    protected String getSelects() {
        return selects;
    }

    private QFilter[] buildFilter0(ReportQueryParam queryParam, String entityNumber) {
        Date genYear;
        FilterInfo filter = queryParam.getFilter();
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)7);
        Date useYear = filter.getDate("con_useyear");
        if (useYear != null) {
            Date beginDayOfYear = QTReportUtils.getBeginDayOfYear(useYear);
            Date endDayOfYear = QTReportUtils.getEndDayOfYear(useYear);
            qFilterList.add(new QFilter("usestartdate", "<=", (Object)endDayOfYear));
            qFilterList.add(new QFilter("useenddate", ">=", (Object)beginDayOfYear));
        }
        if ((genYear = filter.getDate("con_genyear")) != null) {
            Date beginDayOfYear = QTReportUtils.getBeginDayOfYear(genYear);
            Date endDayOfYear = QTReportUtils.getEndDayOfYear(genYear);
            qFilterList.add(new QFilter("genstartdate", "<=", (Object)endDayOfYear));
            qFilterList.add(new QFilter("genenddate", ">=", (Object)beginDayOfYear));
        }
        QTReportUtils.addQFilter(QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_qttype"), "qttype", (List<QFilter>)qFilterList);
        DynamicObject dynamicObject = QTReportUtils.filterDyCollection(filter, DynamicObject.class, "con_org");
        if (dynamicObject == null) {
            DynamicObjectCollection dynamicObjectCollection = QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_multorg");
            QTReportUtils.addQFilter(dynamicObjectCollection, "attfileid.org", (List<QFilter>)qFilterList);
        } else {
            QTReportUtils.addQFilter(dynamicObject, "attfileid.org", (List<QFilter>)qFilterList);
        }
        QTReportUtils.addQFilter(QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_adminorg"), "attfileid.adminorg", (List<QFilter>)qFilterList);
        QTReportUtils.addQFilter(QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_affiliateadminorg"), "attfileid.affiliateadminorg", (List<QFilter>)qFilterList);
        QTReportUtils.addQFilter(QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_empgroup"), "attfileid.empgroup", (List<QFilter>)qFilterList);
        this.convertQfLiter(QTReportUtils.filterDyCollection(filter, DynamicObjectCollection.class, "con_attperson"), qFilterList);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = QTReportUtils.getDataRule(currUserId, "wtte", entityNumber, "org", "47150e89000000ac", Collections.emptyMap());
        if (null != dataQFilter) {
            qFilterList.add(dataQFilter);
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    protected String[] getGroupbySelect() {
        return new String[]{"attfilebo", "qtname"};
    }

    protected String getOrderBySelect() {
        return "genenddate desc";
    }

    protected List<QFilter> buildQFilters(ReportQueryParam queryParam) {
        QFilter[] baseFilters = this.buildFilter0(queryParam, "wtp_qtlinedetail");
        return new ArrayList<QFilter>(Arrays.asList(baseFilters));
    }

    protected List<QFilter> afterQFilters(ReportQueryParam queryParam) {
        return null;
    }

    public List<QFilter> getQFilters(ReportQueryParam queryParam) {
        List<QFilter> qFilters = this.buildQFilters(queryParam);
        List<QFilter> addQFilters = this.afterQFilters(queryParam);
        if (addQFilters != null) {
            qFilters.addAll(addQFilters);
        }
        return qFilters;
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object object) {
        List currentBatchRows;
        List<QFilter> qFilters = this.getQFilters(queryParam);
        qFilters.add(new QFilter("busstatus", "=", (Object)"0"));
        qFilters.add(new QFilter("initstatus", "=", (Object)"2"));
        if (((ReportBatchQueryInfo)queryParam.byBatchInfo()).getCountPerBatch() > 0 && !CollectionUtils.isEmpty((Collection)(currentBatchRows = queryParam.byBatchInfo().getCurrentBatchRows()))) {
            Set detailIdSet = currentBatchRows.stream().map(item -> item.getLong(0)).collect(Collectors.toSet());
            qFilters.add(new QFilter("attfilebo", "in", detailIdSet));
        }
        DataSet dataSet = this.queryData(qFilters);
        dataSet = this.groupAndSum(dataSet);
        return dataSet;
    }

    public DataSet queryDataInBatch(List<QFilter> qFilterList) {
        QFilter[] qFilters = (QFilter[])qFilterList.stream().filter(Objects::nonNull).toArray(QFilter[]::new);
        if (qFilters.length == 0) {
            throw new KDException(new ErrorCode("DefQTSummaryService.queryDataInBatch", "filters can not be empty"), new Object[0]);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_qtlinedetail");
        DataSet dataSet = hrBaseServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet", "attfilebo", qFilters, this.getOrderBySelect()).distinct();
        return dataSet;
    }

    protected DataSet queryData(List<QFilter> qFilterList) {
        QFilter[] qFilters = (QFilter[])qFilterList.stream().filter(Objects::nonNull).toArray(QFilter[]::new);
        if (qFilters.length == 0) {
            throw new KDException(new ErrorCode("DefQTSummaryService.queryData", "filters can not be empty"), new Object[0]);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_qtlinedetail");
        DataSet dataSet = hrBaseServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet", this.getSelects(), qFilters, this.getOrderBySelect());
        return dataSet;
    }

    protected DataSet groupAndSum(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(this.getGroupbySelect());
        this.groupAndSum(groupbyDataSet);
        return groupbyDataSet.finish();
    }

    protected void groupAndSum(GroupbyDataSet groupbyDataSet) {
        groupbyDataSet.sum("ownvalue", "ownvalue");
        groupbyDataSet.sum("usablevalue", "usablevalue");
        groupbyDataSet.sum("freezevalue", "freezevalue");
        groupbyDataSet.sum("usedvalue", "usedvalue");
        groupbyDataSet.sum("canbeodvalue", "canbeodvalue");
        groupbyDataSet.sum("useodvalue", "useodvalue");
        groupbyDataSet.sum("pastvalue", "pastvalue");
        groupbyDataSet.sum("invalidvalue", "invalidvalue");
        groupbyDataSet.sum("cdedvalue", "cdedvalue");
        groupbyDataSet.sum("settlementvalue", "settlementvalue");
    }

    private void convertQfLiter(DynamicObjectCollection filterDyCollection, List<QFilter> qFilterList) {
        if (filterDyCollection == null) {
            return;
        }
        List fileBoIds = filterDyCollection.stream().map(dyn -> dyn.get("boid")).collect(Collectors.toList());
        qFilterList.add(new QFilter("attfilebo", "in", fileBoIds));
    }
}

