/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtpm.business;

import java.time.LocalDate;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkService;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchTaskParam;
import kd.sdk.wtc.wtpm.constants.SignCardKDString;

@SdkService(name="\u6253\u5361\u7ba1\u7406\u670d\u52a1")
public class WTPMSignCardHelper {
    private static final Log LOG = LogFactory.getLog(WTPMSignCardHelper.class);
    private static final String SIGN_CARD_SERVICE = "ISignCardService";
    private static final String EXECUTE_CARD_MATCH_TASK = "executeCardMatchTask";

    public static void executeCardMatchTask(CardMatchTaskParam cardMatchTaskParam) {
        HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)SIGN_CARD_SERVICE, (String)EXECUTE_CARD_MATCH_TASK, (Object[])new Object[]{cardMatchTaskParam});
    }

    public static ApiResult executeCustomCardMatchTask(CardMatchTaskParam cardMatchTaskParam) {
        try {
            String errMsg = WTPMSignCardHelper.checkTaskParam(cardMatchTaskParam);
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                return ApiResult.fail((String)errMsg);
            }
            HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)SIGN_CARD_SERVICE, (String)EXECUTE_CARD_MATCH_TASK, (Object[])new Object[]{cardMatchTaskParam});
        }
        catch (Exception exception) {
            LOG.warn("WTPMSignCardHelper.executeCustomCardMatchTask error", (Throwable)exception);
            return ApiResult.ex((Throwable)exception);
        }
        return ApiResult.success(null);
    }

    private static String checkTaskParam(CardMatchTaskParam param) {
        LocalDate todayLocal;
        if (null == param.getStartDate()) {
            return SignCardKDString.startDateNullTips();
        }
        if (null == param.getEndDate()) {
            return SignCardKDString.endDateNullTips();
        }
        if (HRCollUtil.isEmpty(param.getAttFileBoIds())) {
            return SignCardKDString.attFileNullTips();
        }
        if (param.getStartDate().after(param.getEndDate())) {
            return SignCardKDString.startDateIllegalTips();
        }
        if (HRStringUtils.isNotEmpty((String)param.getTaskDesc()) && param.getTaskDesc().length() > 200) {
            return SignCardKDString.descLengthTips();
        }
        LocalDate endDateLocal = param.getEndDate().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        if (endDateLocal.isAfter(todayLocal = LocalDate.now())) {
            return SignCardKDString.endDateIllegalTips(todayLocal.toString());
        }
        if (HRStringUtils.isNotEmpty((String)param.getTaskType())) {
            try {
                Integer.parseInt(param.getTaskType());
            }
            catch (Exception exception) {
                LOG.warn("WTPMSignCardHelper.executeCustomCardMatchTask getTaskType error", (Throwable)exception);
                return SignCardKDString.taskTypeTips();
            }
        }
        return null;
    }
}

