/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtpm.business.cardmatch;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtabm.business.model.VaBillEntryEntityValidVoExt;
import kd.sdk.wtc.wtabm.business.model.VaBillWithTimeVoExt;
import kd.sdk.wtc.wtabm.business.model.VaEntryValidTimeVoExt;
import kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchEvent;
import kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin;
import kd.sdk.wtc.wtpm.model.cardmatch.CardMatchTaskVoExt;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardEntryExt;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardEntryExtStd;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardExt;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardExtStd;

public class AfterCardMatchExtPluginDemo
implements AfterCardMatchExtPlugin {
    @Override
    public void adjustMultiCard(AfterCardMatchEvent event) {
        CardMatchTaskVoExt taskVoExt = event.getTaskVoExt();
        Set<MultiCardExtStd> multiCardExtSet = taskVoExt.getMultiCardSet();
        Map<Long, List<MultiCardExtStd>> multiCardExtMap = multiCardExtSet.stream().collect(Collectors.groupingBy(MultiCardExtStd::getAttFileBoId));
        Map<Long, List<VaBillWithTimeVoExt>> vaBillListExtMap = taskVoExt.getVaBillMap();
        if (HRMapUtils.isEmpty(vaBillListExtMap)) {
            return;
        }
        for (Map.Entry<Long, List<VaBillWithTimeVoExt>> vaBillEntry : vaBillListExtMap.entrySet()) {
            long attFileBoId = vaBillEntry.getKey();
            List<MultiCardExtStd> multiCardExtList = multiCardExtMap.get(attFileBoId);
            if (HRCollUtil.isEmpty(multiCardExtList)) continue;
            Map<LocalDate, List<MultiCardExtStd>> multiCardDateMap = multiCardExtList.stream().collect(Collectors.groupingBy(MultiCardExtStd::getShiftDate));
            for (VaBillWithTimeVoExt vaBillWithTimeVoExt : vaBillEntry.getValue()) {
                List<VaBillEntryEntityValidVoExt> entryList = vaBillWithTimeVoExt.getEntryEntities();
                if (HRCollUtil.isEmpty(entryList)) continue;
                for (VaBillEntryEntityValidVoExt subEntry : entryList) {
                    List<VaEntryValidTimeVoExt> subList = subEntry.getVaEntryValidTimeVoList();
                    if (HRCollUtil.isEmpty(subList)) continue;
                    for (VaEntryValidTimeVoExt validTimeVoExt : subList) {
                        MultiCardExtStd multiCardStd;
                        List<MultiCardEntryExtStd> multiCardEntryStd;
                        if (validTimeVoExt.getOffNonPlan() || null == validTimeVoExt.getStartDateTime() || null == validTimeVoExt.getEndDateTime() || null == validTimeVoExt.getShiftParseVo() || null == validTimeVoExt.getShiftParseVo().getRosterDate()) continue;
                        Date rosterDate = validTimeVoExt.getShiftParseVo().getRosterDate();
                        Date vaStart = this.cutDateSecondAndMillisecond(validTimeVoExt.getStartDateTime());
                        LocalDateTime vaStartLocal = LocalDateTime.ofInstant(vaStart.toInstant(), KDDateUtils.getSysTimeZone().toZoneId());
                        Date vaEnd = this.cutDateSecondAndMillisecond(validTimeVoExt.getEndDateTime());
                        LocalDateTime vaEndLocal = LocalDateTime.ofInstant(vaEnd.toInstant(), KDDateUtils.getSysTimeZone().toZoneId());
                        LocalDate vaDate = rosterDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
                        List<MultiCardExtStd> multiCards = multiCardDateMap.get(vaDate);
                        if (HRCollUtil.isEmpty(multiCards) || HRCollUtil.isEmpty(multiCardEntryStd = (multiCardStd = multiCards.get(0)).getEntryList()) || multiCardEntryStd.size() != 4) continue;
                        MultiCardEntryExtStd entryStd2nd = multiCardEntryStd.get(1);
                        MultiCardEntryExtStd entryStd3rd = multiCardEntryStd.get(2);
                        if (vaStartLocal.isAfter(entryStd2nd.getMustPoint()) || vaEndLocal.isBefore(entryStd2nd.getMustPoint()) || !vaEndLocal.isBefore(entryStd3rd.getMustPoint()) || null == entryStd2nd.getEffectivePoint() || null != entryStd3rd.getEffectivePoint() || HRStringUtils.equalsIgnoreCase((String)entryStd2nd.getAccessTag(), (String)"off") || !entryStd2nd.getEffectivePoint().isAfter(entryStd2nd.getMustPoint()) || !entryStd2nd.getEffectivePoint().isBefore(entryStd3rd.getMustPoint())) continue;
                        MultiCardExt multiCardExt = new MultiCardExt();
                        multiCardExt.setAttCard(multiCardStd.getAttCard());
                        multiCardExt.setAttFileBoId(multiCardStd.getAttFileBoId());
                        multiCardExt.setAttPersonId(multiCardStd.getAttPersonId());
                        multiCardExt.setAttFileId(multiCardStd.getAttFileId());
                        multiCardExt.setAttFileTimeZoneId(multiCardStd.getAttFileTimeZoneId());
                        multiCardExt.setDateTypeId(multiCardStd.getDateTypeId());
                        multiCardExt.setNotPlan(multiCardStd.isNotPlan());
                        multiCardExt.setOffShift(multiCardStd.isOffShift());
                        multiCardExt.setWeek(multiCardStd.getWeek());
                        multiCardExt.setShiftId(multiCardStd.getShiftId());
                        multiCardExt.setShiftDate(multiCardStd.getShiftDate());
                        multiCardExt.setOrgId(multiCardStd.getOrgId());
                        ArrayList<MultiCardEntryExt> entryListExt = new ArrayList<MultiCardEntryExt>(multiCardEntryStd.size());
                        for (MultiCardEntryExtStd entryExtStd : multiCardEntryStd) {
                            MultiCardEntryExt entryExt = new MultiCardEntryExt();
                            entryExt.setAttPersonId(entryExtStd.getAttPersonId());
                            entryExt.setMatchDate(entryExtStd.getMatchDate());
                            entryExt.setPointDescId(entryExtStd.getPointDescId());
                            entryExt.setMustPoint(entryExtStd.getMustPoint());
                            entryExt.setMustPointUtc(entryExtStd.getMustPointUtc());
                            entryExt.setExtFieldMap(new HashMap<String, Object>());
                            if (multiCardEntryStd.indexOf(entryExtStd) == 1) {
                                entryExt.setDeviceId(0L);
                                entryExt.setEffectivePoint(null);
                                entryExt.setMultiPointUtc(null);
                                entryExt.setPointTag("");
                                entryExt.setPresetBiz1("");
                                entryExt.setPresetBiz2("");
                                entryExt.setSourceId(0L);
                                entryExt.setTimeZoneId(0L);
                                entryExt.setSignCardId(0L);
                                entryExt.setAccessTag("");
                            } else if (multiCardEntryStd.indexOf(entryExtStd) == 2) {
                                entryExt.setDeviceId(entryStd2nd.getDeviceId());
                                entryExt.setEffectivePoint(entryStd2nd.getEffectivePoint());
                                entryExt.setMultiPointUtc(entryStd2nd.getMultiPointUtc());
                                entryExt.setPointDescId(entryStd2nd.getPointDescId());
                                entryExt.setPointTag(entryStd2nd.getPointTag());
                                entryExt.setPresetBiz1(entryStd2nd.getPresetBiz1());
                                entryExt.setPresetBiz2(entryStd2nd.getPresetBiz2());
                                entryExt.setSourceId(entryStd2nd.getSourceId());
                                entryExt.setTimeZoneId(entryStd2nd.getTimeZoneId());
                                entryExt.setSignCardId(entryStd2nd.getSignCardId());
                                entryExt.setAccessTag(entryStd2nd.getAccessTag());
                            } else {
                                entryExt.setDeviceId(entryExtStd.getDeviceId());
                                entryExt.setEffectivePoint(entryExtStd.getEffectivePoint());
                                entryExt.setMultiPointUtc(entryExtStd.getMultiPointUtc());
                                entryExt.setPointDescId(entryExtStd.getPointDescId());
                                entryExt.setPointTag(entryExtStd.getPointTag());
                                entryExt.setPresetBiz1(entryExtStd.getPresetBiz1());
                                entryExt.setPresetBiz2(entryExtStd.getPresetBiz2());
                                entryExt.setSourceId(entryExtStd.getSourceId());
                                entryExt.setTimeZoneId(entryExtStd.getTimeZoneId());
                                entryExt.setSignCardId(entryExtStd.getSignCardId());
                                entryExt.setAccessTag(entryExtStd.getAccessTag());
                            }
                            entryListExt.add(entryExt);
                        }
                        multiCardExt.setEntryList(entryListExt);
                        Map<LocalDate, MultiCardExt> subMap = event.getMulTiCardExtMap().get(attFileBoId);
                        if (HRMapUtils.isEmpty(subMap)) {
                            subMap = new HashMap<LocalDate, MultiCardExt>(2);
                        }
                        subMap.put(vaDate, multiCardExt);
                        event.getMulTiCardExtMap().put(attFileBoId, subMap);
                    }
                }
            }
        }
    }

    private Date cutDateSecondAndMillisecond(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("input date should not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

