/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wts.business.roster;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DateUtils;
import kd.sdk.wtc.wts.business.roster.RosterValidatorExt;

public class RosterValidatorExtDemo
implements RosterValidatorExt {
    private static final Log LOG = LogFactory.getLog(RosterValidatorExtDemo.class);

    @Override
    public Map<Long, Map<String, Map<String, String>>> onValidate(Collection<Long> attFileBoIds, Date startDate, Date endDate) {
        if (LOG.isInfoEnabled()) {
            LOG.info("RosterValidatorExtDemo.params:{},{},{}", new Object[]{attFileBoIds, startDate, endDate});
        }
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)attFileBoIds.size());
        HRBaseServiceHelper attStateHelper = new HRBaseServiceHelper("wtp_attstateinfo");
        DynamicObjectCollection attStateDys = attStateHelper.queryOriginalCollection("id,fileboid,personid,storageto", new QFilter[]{new QFilter("fileboid", "in", attFileBoIds)});
        HashMap failMap = null;
        Calendar calendar = Calendar.getInstance();
        for (DynamicObject attStateDy : attStateDys) {
            Date currDate;
            long fileBoid = attStateDy.getLong("fileboid");
            Date storageDate = attStateDy.getDate("storageto");
            if (storageDate == null || fileBoid == 0L) continue;
            calendar.setTime(startDate);
            while (!calendar.getTime().after(endDate) && !(currDate = calendar.getTime()).after(storageDate)) {
                if (failMap == null) {
                    String failMsg = ResManager.loadKDString((String)"\u6863\u6848\u5df2\u5c01\u5b58\uff0c\u4e0d\u53ef\u6392\u73ed\u3002", (String)"RosterValidatorExtDemo_0", (String)"sdk-wtc", (Object[])new Object[0]);
                    failMap = Maps.newHashMap();
                    failMap.put("plan", failMsg);
                    failMap.put("actual", failMsg);
                }
                Map fileValidMap = retMap.computeIfAbsent(fileBoid, key -> Maps.newHashMap());
                fileValidMap.put(DateUtils.getDate((Date)calendar.getTime()), failMap);
                calendar.add(6, 1);
            }
        }
        return retMap;
    }
}

