/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wts.business.roster;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wts.business.roster.OnRosterValidatorEvent;
import kd.sdk.wtc.wts.business.roster.RosterValidatorExtPlugin;
import kd.sdk.wtc.wts.business.roster.WTSRosterHelper;
import org.apache.commons.collections.CollectionUtils;

public class RosterValidatorExtPluginDemo
implements RosterValidatorExtPlugin {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtbd_shift");

    @Override
    public void onValidate(OnRosterValidatorEvent event) {
        Collection<DynamicObject> dynamicObjectList = event.getDynamicObjectList();
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        Map<Long, List<DynamicObject>> listMap = dynamicObjectList.stream().collect(Collectors.groupingBy(dy -> RosterValidatorExtPluginDemo.getBaseDataId(dy, "attfilebase")));
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>(dynamicObjectList.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : listMap.entrySet()) {
            Long attFileBoId = entry.getKey();
            List<DynamicObject> dyList = entry.getValue();
            List rosterDateList = dyList.stream().map(dy -> dy.getDate("rosterdate")).distinct().sorted().collect(Collectors.toList());
            List rosterDateStrList = rosterDateList.stream().map(RosterValidatorExtPluginDemo::date2Str).collect(Collectors.toList());
            Date startDate = (Date)rosterDateList.get(0);
            Date endDate = (Date)rosterDateList.get(rosterDateList.size() - 1);
            Date firstDayOfMonth = this.getFirstDayOfMonth(startDate);
            Date lastDayOfMonth = this.getLastDayOfMonth(endDate);
            Map<String, Map<String, Object>> map = WTSRosterHelper.queryRosterDataByFileId(attFileBoId, firstDayOfMonth, lastDayOfMonth);
            Map<String, Long> currentDateAndShiftVidMap = event.getFileAndRosterDateWithShiftVid().get(attFileBoId);
            HashMap<String, Long> dateAndShiftVidMap = new HashMap<String, Long>(16);
            ArrayList<Date> allDate = new ArrayList<Date>(10);
            for (Map.Entry<String, Map<String, Object>> mapEntry : map.entrySet()) {
                String rosterDate = mapEntry.getKey();
                allDate.add(this.str2Date(rosterDate));
                if (rosterDateStrList.contains(rosterDate)) {
                    dateAndShiftVidMap.put(rosterDate, currentDateAndShiftVidMap.get(rosterDate));
                    continue;
                }
                Map<String, Object> infoMap = mapEntry.getValue();
                dateAndShiftVidMap.put(rosterDate, (Long)infoMap.get("shiftid"));
            }
            Collection shiftVidList = dateAndShiftVidMap.values();
            DynamicObjectCollection shiftCollection = HELPER.queryOriginalCollection("id,alldayhour,isoff", new QFilter[]{new QFilter("id", "in", shiftVidList)});
            Map<Long, BigDecimal> shiftAndAllDayHour = shiftCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getBigDecimal("alldayhour"), (e1, e2) -> e2));
            Set isOffShiftIdSet = shiftCollection.stream().filter(dy -> dy.getBoolean("isoff")).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            LocalDate lastLocalDateOfMonth = lastDayOfMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate firstLocalDateOfMonth = firstDayOfMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Period period = Period.between(firstLocalDateOfMonth, lastLocalDateOfMonth);
            int months = period.getMonths();
            HashMap<String, String> errInfoMap = new HashMap<String, String>(16);
            for (int i = 0; i <= months; ++i) {
                LocalDate currentMonthLastDate = firstLocalDateOfMonth.plusMonths(i).with(TemporalAdjusters.lastDayOfMonth());
                LocalDate currentMonthFirstDate = firstLocalDateOfMonth.plusMonths(i).withDayOfMonth(1);
                List dateList = allDate.stream().filter(date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().compareTo(currentMonthLastDate) <= 0).filter(date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().compareTo(currentMonthFirstDate) >= 0).collect(Collectors.toList());
                BigDecimal totalHours = BigDecimal.ZERO;
                ArrayList<String> currentMonthDateList = new ArrayList<String>(10);
                for (Date date2 : dateList) {
                    String rosterDateStr = RosterValidatorExtPluginDemo.date2Str(date2);
                    if (rosterDateStrList.contains(rosterDateStr)) {
                        currentMonthDateList.add(rosterDateStr);
                        continue;
                    }
                    Long shiftVid = (Long)dateAndShiftVidMap.get(rosterDateStr);
                    if (isOffShiftIdSet.contains(shiftVid)) continue;
                    totalHours = totalHours.add(shiftAndAllDayHour.get(shiftVid));
                }
                Collections.sort(currentMonthDateList);
                for (String dateStr : currentMonthDateList) {
                    Long shiftVid = (Long)dateAndShiftVidMap.get(dateStr);
                    if (isOffShiftIdSet.contains(shiftVid) || (totalHours = totalHours.add(shiftAndAllDayHour.get(shiftVid))).compareTo(new BigDecimal(200)) <= 0) continue;
                    errInfoMap.put(dateStr, ResManager.loadKDString((String)"\u8d85\u8fc7\u6708\u5c0f\u65f6\u65f6\u6570\u9650\u5236\uff0c\u4e0d\u53ef\u6392\u73ed\u3002", (String)"RosterValidatorForHoursExtDemo_0", (String)"sdk-wtc", (Object[])new Object[0]));
                }
            }
            if (errInfoMap.size() == 0) continue;
            result.put(attFileBoId, errInfoMap);
        }
        event.setResult(result);
    }

    private Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    private Date str2Date(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(str);
        }
        catch (ParseException var5) {
            return null;
        }
    }

    private static long getBaseDataId(DynamicObject dynamicObject, String baseDataKey) {
        Object obj = dynamicObject.get(baseDataKey);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    private static String date2Str(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }
}

