/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wts.business.roster;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.business.custom.WTCCustomControlExtPlugin;
import org.apache.commons.lang3.StringUtils;

public class RosterViewCustomExtPluginDemo
implements WTCCustomControlExtPlugin {
    private static final Log LOG = LogFactory.getLog(RosterViewCustomExtPluginDemo.class);

    @Override
    public void setCustomData(String pageId, String eventName, Object args) {
        LOG.info("RosterViewCustomExtDemo.params:{},{}", (Object)pageId, (Object)eventName);
        if (!(args instanceof HashMap)) {
            return;
        }
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        if (formView == null || !"wts_rosterview".equals(formView.getEntityId())) {
            return;
        }
        this.setShowConfig(args, eventName);
        this.setPersonInfos(args);
    }

    private void setShowConfig(Object args, String eventName) {
        if (!"initdata".equals(eventName)) {
            return;
        }
        HashMap argsMap = (HashMap)args;
        Object showConfigObj = argsMap.get("showConfig");
        if (showConfigObj instanceof Map) {
            Object actualMapObj;
            Object planMapObj = ((Map)showConfigObj).get("plan");
            if (planMapObj instanceof Map) {
                ((Map)planMapObj).put("visible", false);
            }
            if ((actualMapObj = ((Map)showConfigObj).get("actual")) instanceof Map) {
                ((Map)actualMapObj).put("visible", false);
                ((Map)actualMapObj).put("checked", false);
            }
            ((Map)showConfigObj).put("hideRosterType", true);
        }
    }

    private void setPersonInfos(Object args) {
        Object rosterAdminOrgModelsListObj;
        HashMap argsMap = (HashMap)args;
        Object rosterShiftModelListObj = argsMap.get("rosterShiftModelList");
        if (rosterShiftModelListObj instanceof List) {
            this.setPersonInfos(argsMap, (List)rosterShiftModelListObj);
            return;
        }
        Object groupIdObj = argsMap.get("groupId");
        if (groupIdObj != null && StringUtils.isNotEmpty((CharSequence)groupIdObj.toString()) && (rosterAdminOrgModelsListObj = argsMap.get("rosterAdminOrgModelsList")) instanceof List) {
            List rosterAdminOrgModelsList = (List)rosterAdminOrgModelsListObj;
            for (Object adminOrgModelObj : rosterAdminOrgModelsList) {
                Object[] adminOrgModel;
                if (!(adminOrgModelObj instanceof Object[]) || (adminOrgModel = (Object[])adminOrgModelObj).length != 4 || !groupIdObj.equals(adminOrgModel[0])) continue;
                this.setPersonInfos(argsMap, (List)adminOrgModel[3]);
                return;
            }
        }
    }

    private void setPersonInfos(HashMap<String, Object> argsMap, List<Object> rosterShiftModelListObj) {
        if (rosterShiftModelListObj == null) {
            return;
        }
        List<Object> rosterShiftModelList = rosterShiftModelListObj;
        ArrayList<Long> fileBoIds = new ArrayList<Long>(rosterShiftModelList.size());
        for (Object objs : rosterShiftModelList) {
            Object personObj;
            long fileBoId = 0L;
            if (objs instanceof Object[] && ((Object[])objs).length > 0 && (personObj = ((Object[])objs)[0]) instanceof Object[] && ((Object[])personObj).length > 0) {
                try {
                    fileBoId = Long.parseLong(((Object[])personObj)[0].toString());
                }
                catch (NumberFormatException nfEx) {
                    LOG.info("rosterShiftModelList.personInfo.convertFail:{}", personObj);
                }
            }
            fileBoIds.add(fileBoId);
        }
        ArrayList personInfoList = new ArrayList(rosterShiftModelList.size());
        HRBaseServiceHelper fileQueryHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject[] fileDys = fileQueryHelper.loadDynamicObjectArray(fileBoIds.stream().filter(id -> id != 0L).toArray());
        Map fileDyMap = Arrays.stream(fileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (v1, v2) -> v2));
        for (Long fileBoId : fileBoIds) {
            ArrayList<ArrayList> personInfos = new ArrayList<ArrayList>();
            DynamicObject fileDy = (DynamicObject)fileDyMap.get(fileBoId);
            if (fileDy == null) {
                personInfoList.add(personInfos);
                continue;
            }
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"RosterViewCustomExtDemo_1", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("name"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5de5\u53f7", (String)"RosterViewCustomExtDemo_2", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("personnum"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7", (String)"RosterViewCustomExtDemo_3", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("org.name"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"RosterViewCustomExtDemo_4", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("empposorgrel.company.name"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"RosterViewCustomExtDemo_5", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("empposorgrel.adminorg.name"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"RosterViewCustomExtDemo_6", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("empposorgrel.position.name"))}));
            personInfos.add(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u804c\u4f4d", (String)"RosterViewCustomExtDemo_7", (String)"sdk-wtc", (Object[])new Object[0]), this.getDefaultStr(fileDy.getString("empposorgrel.job.name"))}));
            personInfoList.add(personInfos);
        }
        argsMap.put("personInfoList", personInfoList);
    }

    private String getDefaultStr(String str) {
        return StringUtils.isNotEmpty((CharSequence)str) ? str : ResManager.loadKDString((String)"\u65e0", (String)"RosterViewCustomExtDemo_0", (String)"sdk-wtc", (Object[])new Object[0]);
    }
}

