/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtss.business.homepage.demo;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.common.enums.WTCApplyType;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BeforeChooseApplyTypeEvent;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowApplyPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowDetailPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin;
import kd.sdk.wtc.wtss.business.homepage.MobileBillListDto;
import kd.sdk.wtc.wtss.business.homepage.OnFilterMobileBillListEvent;
import kd.sdk.wtc.wtss.business.homepage.OnQueryMobileBillListEvent;
import org.apache.commons.collections.CollectionUtils;

public class BillReplaceExtPluginDemo
implements BillReplaceExtPlugin {
    private static final String APP_ID_WTAM = "wtam";
    private static final String KDTEST_BUSITRIPTEST = "kdtest_busitriptest";
    private static final String KDTEST_BUSITRIPMOBTEST = "kdtest_busitripmobtest";
    private static final String KDTEST_VAAPPLYMOBTEST = "kdtest_vaapplymobtest";
    private static final String KDTEST_VAAPPLYTEST = "kdtest_vaapplytest";

    @Override
    public void beforeShowApplyPage(BeforeShowApplyPageEvent event) {
        FormShowParameter formShowParameter = event.getFormShowParameter();
        if (formShowParameter instanceof MobileBillShowParameter) {
            if (WTCBillType.BU == event.getBillType() && WTCApplyType.OTHER == event.getApplyType()) {
                formShowParameter.setFormId(KDTEST_BUSITRIPMOBTEST);
                formShowParameter.setAppId(APP_ID_WTAM);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            } else if (WTCBillType.VA == event.getBillType() && WTCApplyType.SELF == event.getApplyType()) {
                formShowParameter.setFormId(KDTEST_VAAPPLYMOBTEST);
                formShowParameter.setAppId(APP_ID_WTAM);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            }
        } else if (formShowParameter instanceof BillShowParameter) {
            if (WTCBillType.VA == event.getBillType() && WTCApplyType.SELF == event.getApplyType()) {
                formShowParameter.setFormId(KDTEST_VAAPPLYTEST);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            } else if (WTCBillType.BU == event.getBillType() && WTCApplyType.OTHER == event.getApplyType()) {
                formShowParameter.setFormId(KDTEST_BUSITRIPTEST);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
        }
    }

    @Override
    public void beforeShowDetailPage(BeforeShowDetailPageEvent event) {
        FormShowParameter formShowParameter = event.getFormShowParameter();
        if (formShowParameter instanceof MobileBillShowParameter && WTCBillType.BU == event.getBillType()) {
            MobileBillShowParameter showParameter = (MobileBillShowParameter)formShowParameter;
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId(KDTEST_BUSITRIPMOBTEST);
            showParameter.setAppId(APP_ID_WTAM);
            showParameter.setBillStatus(BillOperationStatus.VIEW);
        }
    }

    @Override
    public void onQueryMobileBillList(OnQueryMobileBillListEvent event) {
        if (event.getBillType() == WTCBillType.BU) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter dateFilter = null;
            if (event.getSearchStartDate() != null && event.getSearchEndDate() != null) {
                dateFilter = new QFilter("startDate", ">=", (Object)event.getSearchStartDate()).and("endDate", "<=", (Object)event.getSearchEndDate());
            } else if (event.getSearchStartDate() != null) {
                dateFilter = new QFilter("startDate", ">=", (Object)event.getSearchStartDate());
            } else if (event.getSearchEndDate() != null) {
                dateFilter = new QFilter("endDate", "<=", (Object)event.getSearchEndDate());
            }
            if (dateFilter != null) {
                filters.add(dateFilter);
            }
            String properties = "id,status,startDate,endDate,modifytime,applytyperadio,personid,creator,createtime";
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("");
            int rowCount = serviceHelper.count(KDTEST_BUSITRIPTEST, filters.toArray(new QFilter[0]));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)KDTEST_BUSITRIPTEST, (String)properties, (QFilter[])filters.toArray(new QFilter[0]), (String)"modifytime DESC", (int)event.getPageStart(), (int)event.getPageSize());
            MobileBillListDto[] billData = (MobileBillListDto[])Arrays.stream(dynamicObjects).map(obj -> {
                MobileBillListDto model = new MobileBillListDto();
                model.setId(obj.getLong("id"));
                model.setPersonId(obj.getLong("personid.id"));
                model.setPersonName(obj.getString("personid.name"));
                model.setBillStatus(obj.getString("status"));
                model.setStartDate(obj.getDate("startDate"));
                model.setEndDate(obj.getDate("endDate"));
                model.setSubmitDate(obj.getDate("createtime"));
                model.setModifyTime(obj.getDate("modifytime"));
                model.setApplyType(obj.getString("applytyperadio"));
                model.setCreatorId(obj.getLong("creator.id"));
                model.setCreatorName(obj.getString("creator.name"));
                return model;
            }).toArray(MobileBillListDto[]::new);
            event.setRowCount(rowCount);
            event.setBillData(billData);
        }
    }

    @Override
    public void beforeChooseApplyType(BeforeChooseApplyTypeEvent event) {
        if (event.getBillType() == WTCBillType.BU) {
            boolean hasRight = this.hasRight(KDTEST_BUSITRIPTEST, "47150e89000000ac");
            event.setShowChoices(hasRight);
        }
    }

    @Override
    public void onFilterMobileBillList(OnFilterMobileBillListEvent event) {
        HashMap billTypeRights = Maps.newHashMap();
        billTypeRights.put(WTCBillType.VA, this.hasRight(KDTEST_VAAPPLYTEST, "47150e89000000ac"));
        billTypeRights.put(WTCBillType.BU, this.hasRight(KDTEST_BUSITRIPTEST, "47150e89000000ac"));
        event.setBillTypeRights(billTypeRights);
    }

    private boolean hasRight(String formId, String permissionStatus) {
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)APP_ID_WTAM, (String)formId, (String)permissionStatus);
        return result != null && (result.hasAllOrgPerm() || CollectionUtils.isNotEmpty((Collection)result.getHasPermOrgs()));
    }
}

