/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.wtc.wtss.business.homepage.demo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.custom.WTCCustomControlExtPlugin;

public class WorkCalendarCustomExtPluginDemo
implements WTCCustomControlExtPlugin {
    private static final Log LOG = LogFactory.getLog(WorkCalendarCustomExtPluginDemo.class);

    @Override
    public void setCustomData(String pageId, String eventName, Object args) {
        LOG.info("WorkCalendarCustomExtPluginDemo.params:{},{}", (Object)pageId, (Object)eventName);
        if (!(args instanceof HashMap)) {
            return;
        }
        if (!"dateData".equals(eventName)) {
            return;
        }
        HashMap argsMap = (HashMap)args;
        long attPersonId = (Long)argsMap.get("attPersonId");
        String choseDate = (String)argsMap.get("chosedate");
        JSONObject jsonObject = (JSONObject)argsMap.get("args");
        JSONArray attRecord = (JSONArray)jsonObject.get((Object)"attRecord");
        JSONArray dateList = (JSONArray)jsonObject.get((Object)"dateList");
        if (null == dateList || dateList.isEmpty()) {
            return;
        }
        JSONObject start = dateList.getJSONObject(0);
        String startDateStr = start.getString("date");
        JSONObject end = dateList.getJSONObject(dateList.size() - 1);
        String endDateStr = end.getString("date");
        Date startDate = this.str2Date(startDateStr, "yyyy-MM-dd");
        Date endDate = this.str2Date(endDateStr, "yyyy-MM-dd");
        HRBaseServiceHelper rosterHelper = new HRBaseServiceHelper("wts_personroster");
        QFilter rosterDateQFilter = new QFilter("rosterdate", ">=", (Object)startDate).and(new QFilter("rosterdate", "<=", (Object)endDate));
        QFilter rosterPersonQFilter = new QFilter("attperson", "=", (Object)attPersonId);
        DynamicObject[] rosterDys = rosterHelper.query("id,shift.name,shift.isoff,rosterdate,dateproperty.number,rostertype", new QFilter[]{rosterPersonQFilter, rosterDateQFilter});
        Map<Date, List<DynamicObject>> rosterMap = Arrays.stream(rosterDys).collect(Collectors.groupingBy(d -> d.getDate("rosterdate")));
        HRBaseServiceHelper tripHelper = new HRBaseServiceHelper("wtam_busitripbill");
        QFilter tripPersonQFilter = new QFilter("personid", "=", (Object)attPersonId);
        QFilter tripStatusQFilter = new QFilter("auditstatus", "=", (Object)"C").or(new QFilter("auditstatus", "=", (Object)"H"));
        QFilter tripDateQFilter = new QFilter("sdate", ">=", (Object)startDate).and(new QFilter("edate", "<=", (Object)endDate));
        DynamicObject[] tripDys = tripHelper.loadDynamicObjectArray(new QFilter[]{tripPersonQFilter, tripDateQFilter, tripStatusQFilter});
        for (int index = 0; index < dateList.size(); ++index) {
            JSONArray billList;
            JSONObject detail = dateList.getJSONObject(index);
            String dateStr = detail.getString("date");
            Date date = this.str2Date(dateStr, "yyyy-MM-dd");
            List<DynamicObject> rosterList = rosterMap.get(date);
            if (!HRCollUtil.isEmpty(rosterList)) {
                rosterList.sort(Comparator.comparing(dyn -> dyn.getString("rostertype")).reversed());
            }
            DynamicObject rosterDy = rosterList.get(0);
            boolean isOff = rosterDy.getBoolean("shift.isoff");
            String dateProperty = rosterDy.getString("dateproperty.number");
            if (isOff && HRStringUtils.equalsIgnoreCase((String)dateProperty, (String)"DS-0001")) {
                detail.put("customLblText", (Object)rosterDy.getString("shift.name"));
                detail.put("useCustomLbl", (Object)true);
            }
            if (null == (billList = detail.getJSONArray("billList")) || billList.size() <= 0) continue;
            block1: for (int i = 0; i < billList.size(); ++i) {
                String billName = (String)billList.get(i);
                if (!HRStringUtils.startsWithIgnoreCase((String)billName, (String)ResManager.loadKDString((String)"\u51fa\u5dee", (String)"WorkCalendarCustomExtPluginDemo_1", (String)"sdk-wtc", (Object[])new Object[0]))) continue;
                for (DynamicObject tripDy : tripDys) {
                    boolean matchBill = false;
                    DynamicObjectCollection entryCol = tripDy.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryCol) {
                        Date ownDate = entry.getDate("owndate");
                        if (null == ownDate || null == date || ownDate.getTime() != date.getTime()) continue;
                        billList.set(i, (Object)entry.getString("busitriptype.name"));
                        matchBill = true;
                        break;
                    }
                    if (matchBill) continue block1;
                }
            }
        }
    }

    public Date str2Date(String str, String format) {
        if (HRStringUtils.isEmpty((String)str)) {
            return null;
        }
        if (HRStringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(str);
        }
        catch (ParseException var5) {
            return null;
        }
    }
}

