/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileServiceUtils {
    private static final Log LOG = LogFactory.getLog(FileServiceUtils.class);

    /*
     * Loose catch block
     */
    public static String getImageBase64ByIO(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
                int len;
                byte[] bs = new byte[1024];
                while ((len = in.read(bs)) != -1) {
                    ba.write(bs, 0, len);
                }
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] imgByte = encoder.encode(ba.toByteArray());
                String string = new String(imgByte, "UTF-8");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileServiceUtils.closeResource(in);
        }
    }

    public static void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                LOG.error("InputStream close error", (Throwable)ex);
            }
        }
    }
}

