/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.common.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class PermissionUtils {
    private static final Log logger = LogFactory.getLog(PermissionUtils.class);

    public static boolean checkPermission(String pageNum, String permItem) {
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"soefam", (String)pageNum, (String)permItem);
        return hasPerm;
    }

    public static QFilter getPermissionQFilter(Object[] params) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])params);
    }

    public static QFilter getPermissionQFilter(String formId) {
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)"soefam").getId(), formId, "47150e89000000ac", Collections.emptyMap()};
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])params);
    }

    public static QFilter getUserHasPermOrgs(String formId, String propKey) {
        String appId = AppMetadataCache.getAppInfo((String)"soefam").getId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"25", (String)appId, (String)formId, (String)"47150e89000000ac");
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return new QFilter(propKey, "in", (Object)result.getHasPermOrgs());
    }

    public static QFilter getUserHasPermOrgs(String propKey) {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return new QFilter(propKey, "in", (Object)result.getHasPermOrgs());
    }

    public static Map<Long, Boolean> validateManageOrg(String formId, List<Object> idList) {
        String appId = AppMetadataCache.getAppInfo((String)"soefam").getId();
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSDataPermissionService", (String)"matchDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, formId, "47150e89000000ac", new QFilter[]{new QFilter("id", "in", idList)}, Maps.newHashMapWithExpectedSize((int)1)});
    }

    public static Map<Boolean, List<Long>> invokeGetEntityDimValue(String entityNum) {
        AuthorizedOrgTeamResult result = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeams", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "soefam", entityNum, "47150e89000000ac", "manageorg"});
        logger.info("permission.invokeGetEntityDimValue.result:{}", (Object)result);
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        HashMap<Boolean, List<Long>> map = new HashMap<Boolean, List<Long>>(1);
        if (result == null) {
            map.put(Boolean.FALSE, Collections.emptyList());
            return map;
        }
        if (result.isHasAllOrgPerm() || superUser) {
            map.put(Boolean.TRUE, Collections.emptyList());
            return map;
        }
        Map permOrgTeamMap = result.getHasPermOrgTeamMap();
        logger.info("permission.invokeGetEntityDimValue.permOrgTeamMap:{}", (Object)permOrgTeamMap);
        if (permOrgTeamMap.isEmpty()) {
            map.put(Boolean.FALSE, Collections.emptyList());
        } else {
            map.put(Boolean.FALSE, (List<Long>)permOrgTeamMap.get(ManageOrgConstants.ID_MANAGEORG));
        }
        return map;
    }
}

