/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.mservice.msgcooperate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.sihc.soefam.business.application.external.hr.HrExternalService;
import kd.sihc.soefam.business.domain.filingsperson.FilPersonService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.mservice.api.msgcooperate.ITransferMsgConsumerService;

public class TransferMsgConsumerService
implements ITransferMsgConsumerService {
    private static final Log LOG = LogFactory.getLog(TransferMsgConsumerService.class);
    private static final HrExternalService HR_EXTERNAL_SERVICE = (HrExternalService)ServiceFactory.getService(HrExternalService.class);
    private static final FilPersonService FIL_PERSON_SERVICE = (FilPersonService)ServiceFactory.getService(FilPersonService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();

    public HRMServiceResult consumerSaveMsg(DynamicObject tplDy) {
        String contentBase64 = tplDy.getString("msgcontent");
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
        LOG.info("TransferMsgConsumerService.consumerSaveMsg:{},msgName:{},recordId:{}", new Object[]{tplDy.get("number"), null == tplDy.get("name") ? "" : tplDy.get("name").toString(), msgContent.get("recordId")});
        Object recordId = msgContent.get("recordId");
        Map fourPersonData = HR_EXTERNAL_SERVICE.getChgInfoByRecordId(recordId);
        JSONObject fourPersonJsonObj = new JSONObject(fourPersonData);
        Long employeeBoid = fourPersonJsonObj.getJSONObject("hrpi_employee").getLong("boid");
        Long personBoid = fourPersonJsonObj.getJSONObject("hrpi_person").getLong("boid");
        FILPERSONMG_APPLICATION_SERVICE.updateFilPersonEmpPosOrgRel(personBoid, employeeBoid);
        this.updateConsumeMsgInfo(tplDy);
        return HRMServiceResult.success();
    }

    private void updateConsumeMsgInfo(DynamicObject coordinationLog) {
        HashMap consumeMsgMap = Maps.newHashMapWithExpectedSize((int)3);
        Object msgCenterBO = coordinationLog.get("msgcenterbo");
        if (msgCenterBO instanceof DynamicObject) {
            msgCenterBO = coordinationLog.get("msgcenterbo.id");
        }
        consumeMsgMap.put("msgCenterId", msgCenterBO);
        consumeMsgMap.put("msgSubNo", coordinationLog.get("msgsubno"));
        consumeMsgMap.put("handleStatus", "1");
        this.callIHRCSMsgService(consumeMsgMap);
    }

    private void callIHRCSMsgService(Map<String, Object> consumeMsgMap) {
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{consumeMsgMap});
    }
}

