/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.external;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.url.UrlService;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import org.apache.commons.lang3.ObjectUtils;

public class PrintTemplateExternalService {
    public static Map<String, Object> defaultPrintTemplate(String entityKey) {
        Optional<Map> isDefault;
        List<Map<String, Object>> entityPrintTemplate = PrintTemplateExternalService.getEntityPrintTemplate(entityKey);
        if (ObjectUtils.isNotEmpty(entityPrintTemplate) && (isDefault = entityPrintTemplate.stream().filter(stringObjectMap -> (Boolean)stringObjectMap.get("isDefault") == true).findFirst()).isPresent()) {
            return isDefault.get();
        }
        return null;
    }

    public static Integer getNumberOfTemplate(String entityKey) {
        List<Map<String, Object>> entityPrintTemplate = PrintTemplateExternalService.getEntityPrintTemplate(entityKey);
        return entityPrintTemplate.size();
    }

    public static Map<String, Object> getFirstPrintTemplate(String entityKey) {
        Optional<Map<String, Object>> firstTemplate;
        List<Map<String, Object>> entityPrintTemplate = PrintTemplateExternalService.getEntityPrintTemplate(entityKey);
        if (ObjectUtils.isNotEmpty(entityPrintTemplate) && (firstTemplate = Optional.ofNullable(entityPrintTemplate.get(0))).isPresent()) {
            return firstTemplate.get();
        }
        return null;
    }

    public static List<Map<String, Object>> getEntityPrintTemplate(String entityKey) {
        List entityPrtTplList = PrintTemplateServiceFactory.getService().getUserPermPrintTemplateList(entityKey);
        return entityPrtTplList;
    }

    public static String getDownloadUrl(String tplId, List<Object> pkIds) {
        PrintTask printTask = new PrintTask();
        printTask.setTplId(tplId);
        printTask.setPkIds(pkIds);
        PrintWork printWork = new PrintWork();
        printWork.setTaskList((List)ImmutableList.of((Object)printTask));
        printWork.setPrintLang(RequestContext.get().getLang().toString());
        printWork.setExpType("pdf");
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
        String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
        downloadUrl = String.format(downloadUrl, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
        return downloadUrl;
    }

    public static Map<String, Map<String, Object>> getContactInfoMap(List<String> perIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"007"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", perIdList);
        Map<String, Map<String, Object>> employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        return employeeInfo;
    }

    public static Map<Long, List<Map<String, Object>>> getTargetResult(Map<String, Map<String, Object>> result, String targetName) {
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        HashMap targetResultMap = Maps.newHashMap();
        result.forEach((personIdStr, map) -> {
            if (null == map) {
                return;
            }
            Long personId = Long.parseLong(personIdStr);
            Object target = map.get(targetName);
            if (null == target) {
                return;
            }
            List targetMapList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(target), ArrayList.class);
            targetResultMap.put(personId, targetMapList);
        });
        return targetResultMap;
    }
}

