/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.external.hrmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HrpiQueryServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HrpiQueryServiceHelper.class);
    private static final HRBaseServiceHelper EMPJOBRELSERVICEHELPER = new HRBaseServiceHelper("hrpi_empjobrel");
    private static final HRBaseServiceHelper PERSONSERVICEHELPER = new HRBaseServiceHelper("hrpi_person");
    private static final HRBaseServiceHelper EMPLOYEESERVICEHELPER = new HRBaseServiceHelper("hrpi_employee");
    private static final HRBaseServiceHelper ADMINORGSERVICEHELPER = new HRBaseServiceHelper("haos_adminorghr");
    private static final HRBaseServiceHelper DEPEMPSERVICEHELPER = new HRBaseServiceHelper("hrpi_depemp");
    private static final HRBaseServiceHelper EMPPOSORGRELSERVICEHELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper EMPCADRESERVICEHELPER = new HRBaseServiceHelper("hrpi_empcadre");
    private static final HRBaseServiceHelper ERMANFILESERVICEHELPER = new HRBaseServiceHelper("hspm_ermanfile");

    public static QFilter getCommonFilter() {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        filter.and(new QFilter("businessstatus", "=", (Object)"1"));
        return filter;
    }

    public static DynamicObject[] getEmpjobrelByEmployeeId(List<Object> employeeIdList, String properties) {
        QFilter qFilter = new QFilter("employee", "in", employeeIdList);
        qFilter.and(HrpiQueryServiceHelper.getCommonFilter());
        return EMPJOBRELSERVICEHELPER.query(properties, qFilter.toArray());
    }

    public static DynamicObject[] getPersonInfoByNameAndNumber(List<Object> personnumber, List<Object> personname) {
        QFilter filter = new QFilter("number", "in", personnumber);
        filter.and(new QFilter("name", "in", personname));
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        return PERSONSERVICEHELPER.loadDynamicObjectArray(filter.toArray());
    }

    public static Map<Long, Long> getEmployeeInfoByPerson(List<Long> personIds) {
        QFilter filter = new QFilter("person", "in", personIds);
        filter.and(new QFilter("islatestrecord", "=", (Object)"1"));
        filter.and(HrpiQueryServiceHelper.getCommonFilter());
        DynamicObject[] employees = EMPLOYEESERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        HashMap<Long, Long> personEmployeeMap = new HashMap<Long, Long>(16);
        for (DynamicObject employee : employees) {
            personEmployeeMap.put(employee.getLong("person.id"), employee.getLong("id"));
        }
        return personEmployeeMap;
    }

    public static DynamicObject[] getAdminOrgByManOrgRanges(DynamicObject[] manOrgRangeList) {
        ArrayList<String> includeSubNumberList = new ArrayList<String>(10);
        ArrayList<String> notIncludeSubNumberList = new ArrayList<String>(10);
        for (DynamicObject manOrgRange : manOrgRangeList) {
            HrpiQueryServiceHelper.assembleAdminOrgNumber(includeSubNumberList, notIncludeSubNumberList, manOrgRange);
        }
        LOGGER.info("HrpiQueryServiceHelper.getAdminOrgByManOrgRanges.notIncludeSubNumberList:{},includeSubNumberList:{}", notIncludeSubNumberList, includeSubNumberList);
        QFilter filter = new QFilter("structnumber", "in", notIncludeSubNumberList);
        for (String includeSubNumber : includeSubNumberList) {
            filter.or(new QFilter("structlongnumber", "like", (Object)("%" + includeSubNumber + "%")));
        }
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        hisFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        hisFilter.and(new QFilter("enable", "=", (Object)"1"));
        return ADMINORGSERVICEHELPER.query(filter.and(hisFilter).toArray());
    }

    public static void assembleAdminOrgNumber(List<String> includeSubNumberList, List<String> notIncludeSubNumberList, DynamicObject manOrgRange) {
        DynamicObjectCollection cadreGroupEntry = manOrgRange.getDynamicObjectCollection("cadregroupentry");
        for (DynamicObject cadreGroup : cadreGroupEntry) {
            DynamicObjectCollection cadreOrgEntry = cadreGroup.getDynamicObjectCollection("cadreorgentry");
            for (DynamicObject cadreOrg : cadreOrgEntry) {
                boolean cadreIncludeSub = cadreOrg.getBoolean("cadreincludesub");
                if (cadreIncludeSub) {
                    includeSubNumberList.add(cadreOrg.getString("cadreadmorg.structnumber"));
                    continue;
                }
                notIncludeSubNumberList.add(cadreOrg.getString("cadreadmorg.structnumber"));
            }
        }
        DynamicObjectCollection specialGroupEntry = manOrgRange.getDynamicObjectCollection("specialgroupentry");
        for (DynamicObject specialGroup : specialGroupEntry) {
            DynamicObjectCollection specialOrgEntry = specialGroup.getDynamicObjectCollection("specialorgentry");
            for (DynamicObject specialOrg : specialOrgEntry) {
                boolean specialIncludeSub = specialOrg.getBoolean("specialincludesub");
                if (specialIncludeSub) {
                    includeSubNumberList.add(specialOrg.getString("specialadmorg.structnumber"));
                    continue;
                }
                notIncludeSubNumberList.add(specialOrg.getString("specialadmorg.structnumber"));
            }
        }
    }

    public static DynamicObject[] getDepEmpByManOrgRanges(DynamicObject[] manOrgRangeList) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        DynamicObject[] adminOrgs = HrpiQueryServiceHelper.getAdminOrgByManOrgRanges(manOrgRangeList);
        List adminOrgIds = Arrays.stream(adminOrgs).map(adminOrg -> adminOrg.getLong("id")).collect(Collectors.toList());
        LOGGER.info("HrpiQueryServiceHelper.getDepEmpByManOrgRanges.adminOrgIds:{}", adminOrgIds);
        commonFilter.and(new QFilter("adminorg", "in", adminOrgIds));
        return DEPEMPSERVICEHELPER.query("id,person,employee,isprimary,adminorg,postype,stdposition,position,apositiontype", commonFilter.toArray());
    }

    public static DynamicObject[] getDepEmpByEmployee(List<Long> employeeIds) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        commonFilter.and(new QFilter("employee", "in", employeeIds));
        return DEPEMPSERVICEHELPER.query("id,person,employee,isprimary,adminorg,postype,stdposition,position,apositiontype", commonFilter.toArray());
    }

    public static DynamicObject[] getEmpJobRelByEmployee(List<Long> employeeIds) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("employee", "in", employeeIds));
        return EMPJOBRELSERVICEHELPER.query("id,person,employee,joblevel,jobgrade,job,jobclass,jobfamily,jobseq", commonFilter.toArray());
    }

    public static DynamicObject[] getEmpCadreByEmployee(List<Long> employeeIds) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("depemp.isprimary", "=", (Object)"1"));
        commonFilter.and(new QFilter("employee", "in", employeeIds));
        Calendar cal = Calendar.getInstance();
        cal.set(2999, 11, 31);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        QFilter dateFilter = new QFilter("enddate", "=", (Object)cal.getTime());
        dateFilter.or(new QFilter("enddate", "=", null));
        return EMPCADRESERVICEHELPER.query("id,person,employee,iscadre,cadretype,depemp", commonFilter.and(dateFilter).toArray());
    }

    public static DataSet getEmpCadreByEmployee(String className, List<Long> employeeIds) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("depemp.isprimary", "=", (Object)"1"));
        commonFilter.and(new QFilter("employee", "in", employeeIds));
        Calendar cal = Calendar.getInstance();
        cal.set(2999, 11, 31);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        QFilter dateFilter = new QFilter("enddate", "=", (Object)cal.getTime());
        dateFilter.or(new QFilter("enddate", "=", null));
        return EMPCADRESERVICEHELPER.queryDataSet(className, "id,employee,cadretype.name as cadretype", commonFilter.and(dateFilter).toArray());
    }

    public static DynamicObject[] getEmpPosOrgRelByDepEmpIds(List<Long> matchedDepEmpIdList) {
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("depemp.id", "in", matchedDepEmpIdList));
        return EMPPOSORGRELSERVICEHELPER.query("id,person,adminorg,company,position,job,isprimary,cmpemp,depemp,employee,stdposition", commonFilter.toArray());
    }

    public static DynamicObject[] getErManFileByDepEmp(DynamicObject[] depEmps) {
        List depEmpIds = Arrays.stream(depEmps).map(depEmp -> depEmp.getLong("id")).collect(Collectors.toList());
        QFilter commonFilter = HrpiQueryServiceHelper.getCommonFilter();
        commonFilter.and(new QFilter("depemp", "in", depEmpIds));
        commonFilter.and(new QFilter("filetype", "=", (Object)1010L));
        return ERMANFILESERVICEHELPER.query("id,depemp", commonFilter.toArray());
    }

    public static List<Long> getModifiedEmployeeIds() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date yesterdayDate = cal.getTime();
        QFilter filter = new QFilter("modifytime", ">=", (Object)yesterdayDate);
        filter.and(new QFilter("modifytime", "<=", (Object)new Date()));
        filter.and(HrpiQueryServiceHelper.getCommonFilter());
        DynamicObject[] depemps = DEPEMPSERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        DynamicObject[] empjobrels = EMPJOBRELSERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        DynamicObject[] empposorgrels = EMPPOSORGRELSERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        DynamicObject[] empcadres = EMPCADRESERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        ArrayList<Long> allEmployeeIds = new ArrayList<Long>(10);
        for (DynamicObject depemp : depemps) {
            allEmployeeIds.add(depemp.getLong("employee.id"));
        }
        for (DynamicObject empjobrel : empjobrels) {
            allEmployeeIds.add(empjobrel.getLong("employee.id"));
        }
        for (DynamicObject empposorgrel : empposorgrels) {
            allEmployeeIds.add(empposorgrel.getLong("employee.id"));
        }
        for (DynamicObject empcadre : empcadres) {
            allEmployeeIds.add(empcadre.getLong("employee.id"));
        }
        return allEmployeeIds;
    }

    public static Map<Long, DynamicObject> getDepEmpAdminOrgMap(DynamicObject[] depemps) {
        List adminOrgIds = Arrays.stream(depemps).map(depemp -> depemp.getLong("adminorg.id")).collect(Collectors.toList());
        DynamicObject[] adminOrgs = ADMINORGSERVICEHELPER.query("id,structnumber,structlongnumber", new QFilter("id", "in", adminOrgIds).toArray());
        HashMap<Long, DynamicObject> adminOrgMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject adminOrg : adminOrgs) {
            adminOrgMap.put(adminOrg.getLong("id"), adminOrg);
        }
        return adminOrgMap;
    }

    public static List<Long> filterLatestRecordEmployeeIds(List<Long> employeeIds) {
        QFilter filter = new QFilter("id", "in", employeeIds);
        filter.and(new QFilter("islatestrecord", "=", (Object)"1"));
        filter.and(HrpiQueryServiceHelper.getCommonFilter());
        DynamicObject[] latestRecordEmployees = EMPLOYEESERVICEHELPER.query("id,islatestrecord", filter.toArray());
        return Arrays.stream(latestRecordEmployees).map(latestRecordEmployee -> latestRecordEmployee.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getLatestRecordEmployeeIds(List<Long> employeeIds) {
        DynamicObject[] employees = EMPLOYEESERVICEHELPER.query("id,person,islatestrecord", new QFilter("id", "in", employeeIds).toArray());
        List personIds = Arrays.stream(employees).map(employee -> employee.getLong("person.id")).collect(Collectors.toList());
        QFilter filter = new QFilter("person", "in", personIds);
        filter.and(new QFilter("islatestrecord", "=", (Object)"1"));
        filter.and(HrpiQueryServiceHelper.getCommonFilter());
        DynamicObject[] latestRecordEmployees = EMPLOYEESERVICEHELPER.query("id,person,islatestrecord", filter.toArray());
        return Arrays.stream(latestRecordEmployees).map(latestRecordEmployee -> latestRecordEmployee.getLong("id")).collect(Collectors.toList());
    }
}

