/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.external.ocr;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.common.constants.ocr.OcrParamConstants;
import kd.sihc.soefam.common.utils.FileServiceUtils;

public class OcrExternalService
implements OcrParamConstants {
    private static final Log LOG = LogFactory.getLog(OcrExternalService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject identifyDocument(String formId, String imgPath) {
        String businessObject = formId;
        String templateNumber = "OCRTEMPLATE-GATPass";
        InputStream inputStream = null;
        try {
            FileService fileService = FileServiceFactory.getImageFileService();
            inputStream = fileService.getInputStream(imgPath);
            String imageData = FileServiceUtils.getImageBase64ByIO((InputStream)inputStream);
            Object[] reqParams = new Object[]{businessObject, templateNumber, imageData};
            LOG.info("OcrExternalService.distinguishOcrImage imageData : {}", (Object)imageData);
            String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])reqParams);
            LOG.info("OcrExternalService.distinguishOcrImage : {}", (Object)result);
            JSONObject resParams = JSONObject.parseObject((String)result);
            int code = resParams.getInteger("errorCode");
            String desc = resParams.getString("description");
            if (code == 0 && HRStringUtils.equals((String)desc, (String)"success")) {
                JSONObject jSONObject = resParams.getJSONObject("data").getJSONObject("recognitionArea");
                return jSONObject;
            }
        }
        catch (Exception e) {
            LOG.error("OcrExternalService.distinguishOcrImage fail : ", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("OcrExternalService.distinguishOcrImage io error", (Throwable)e);
                }
            }
        }
        return null;
    }
}

