/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.service.certificate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.application.external.ocr.OcrExternalService;
import kd.sihc.soefam.business.application.external.task.SscTaskExternalService;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.queryservice.BaseDataQueryService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.CommonOperationKeyConstants;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.constants.ocr.OcrParamConstants;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;

public class CertificateApplicationService
implements OcrParamConstants,
CommonOperationKeyConstants,
CertificateConstants {
    private static final Log LOG = LogFactory.getLog(CertificateApplicationService.class);
    private static final BaseDataQueryService BASE_DATA_QUERY_SERVICE = ServiceFactory.getService(BaseDataQueryService.class);
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = ServiceFactory.getService(FilPersonQueryService.class);
    private static final CertificateDomainService CERTIFICATE_DOMAIN_SERVICE = ServiceFactory.getService(CertificateDomainService.class);
    private static final OcrExternalService OCR_EXTERNAL_SERVICE = ServiceFactory.getService(OcrExternalService.class);

    public void initCertificate(String operationKey, DynamicObject[] filPersons) {
        DynamicObject[] conCertTypes = BASE_DATA_QUERY_SERVICE.getAllConCertType();
        if (conCertTypes != null && conCertTypes.length > 0) {
            CERTIFICATE_DOMAIN_SERVICE.initCertificate(operationKey, filPersons, conCertTypes);
        }
    }

    public void initCertificateForConType(String operationKey, DynamicObject[] conCertTypes) {
        DynamicObject[] filPersons = FIL_PERSON_QUERY_SERVICE.getAllAuditFilPersonInfo();
        if (filPersons != null && filPersons.length > 0) {
            CERTIFICATE_DOMAIN_SERVICE.initCertificate(operationKey, filPersons, conCertTypes);
        }
    }

    public JSONObject getCertificateInfoByOCR(String formId, String imgPath) {
        return OCR_EXTERNAL_SERVICE.identifyDocument(formId, imgPath);
    }

    public void initCertificateManageStatus(String operationKey, DynamicObject[] certificates) {
        String manageStatus = "";
        String stockStatus = "";
        if ("in_reg".equals(operationKey)) {
            stockStatus = CertStockStatusEnum.STATUS_IN.getKey();
            manageStatus = CertManageStatusEnum.STATUS_SAVE.getKey();
        } else if ("lentout_reg".equals(operationKey)) {
            manageStatus = CertManageStatusEnum.STATUS_TORETURN.getKey();
        } else if ("return_reg".equals(operationKey)) {
            manageStatus = CertManageStatusEnum.STATUS_SAVE.getKey();
        } else if ("out_reg".equals(operationKey)) {
            List<Long> certificateIds = Arrays.stream(certificates).map(object -> object.getLong("id")).collect(Collectors.toList());
            stockStatus = CertStockStatusEnum.STATUS_OUT.getKey();
            manageStatus = "";
            DynamicObject[] lentOutRegs = CERTIFICATE_QUERY_SERVICE.queryToLentOutRegByCertIds(certificateIds);
            if (lentOutRegs != null && lentOutRegs.length > 0) {
                Arrays.stream(lentOutRegs).forEach(object -> {
                    object.set("registerstate", (Object)"2");
                    object.set("latestrecord", (Object)"0");
                    object.set("remark", (Object)ResManager.loadKDString((String)"\u57fa\u4e8e\u8bc1\u7167\u51fa\u5e93\u7ec8\u6b62\u501f\u51fa", (String)"CertificateApplicationService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
                });
                lentOutRegs[0].set("latestrecord", (Object)"1");
            }
            CERTIFICATE_DOMAIN_SERVICE.updateLentOutRegs(lentOutRegs);
        } else if ("over_reg".equals(operationKey)) {
            manageStatus = CertManageStatusEnum.STATUS_SAVE.getKey();
        }
        if (!"replace_reg".equals(operationKey)) {
            this.initCertificateStockStatusSpecial(certificates, stockStatus);
            this.initCertificateManageStatusSpecial(certificates, manageStatus);
        }
        CERTIFICATE_DOMAIN_SERVICE.batchUpdateCert(certificates);
    }

    public DynamicObject[] initCertinfo(String operationKey, DynamicObject[] certInfos) {
        if ("in_reg".equals(operationKey)) {
            List<Long> certificateIds = Arrays.stream(certInfos).map(object -> object.getLong("certificate.id")).collect(Collectors.toList());
            DynamicObject[] effCertInfos = CERTIFICATE_QUERY_SERVICE.queryEffCertInfoByCertificateIds(certificateIds);
            Map<Long, DynamicObject> effCertInfoMap = Arrays.stream(effCertInfos).collect(Collectors.toMap(o -> o.getLong("certificate.id"), o -> o));
            Set<Long> effCertInfoIds = effCertInfoMap.keySet();
            ArrayList<DynamicObject> certInfosForSave = new ArrayList<DynamicObject>(certInfos.length);
            for (DynamicObject certInfo : certInfos) {
                Long certificateId = certInfo.getLong("certificate.id");
                if (effCertInfoIds.contains(certificateId)) {
                    DynamicObject effCertInfo = effCertInfoMap.get(certificateId);
                    this.copyCertInfo(effCertInfo, certInfo);
                    certInfosForSave.add(effCertInfo);
                    continue;
                }
                certInfosForSave.add(certInfo);
            }
            DynamicObject[] certInfoSaves = certInfosForSave.toArray(new DynamicObject[0]);
            CERTIFICATE_DOMAIN_SERVICE.saveCertInfo(certInfoSaves);
            return certInfoSaves;
        }
        CERTIFICATE_DOMAIN_SERVICE.saveCertInfo(certInfos);
        return certInfos;
    }

    private void copyCertInfo(DynamicObject effCertInfo, DynamicObject certInfo) {
        effCertInfo.set("certificate", (Object)certInfo.getDynamicObject("certificate"));
        effCertInfo.set("certnumber", (Object)certInfo.getString("certnumber"));
        effCertInfo.set("signdate", (Object)certInfo.getDate("signdate"));
        effCertInfo.set("pervaldate", (Object)certInfo.getDate("pervaldate"));
        effCertInfo.set("signorg", (Object)certInfo.getString("signorg"));
        effCertInfo.set("signplace", (Object)certInfo.getString("signplace"));
        effCertInfo.set("remarks", (Object)certInfo.getString("remarks"));
        effCertInfo.set("org", (Object)certInfo.getDynamicObject("org"));
        effCertInfo.set("faceimage", (Object)certInfo.getString("faceimage"));
    }

    public void initCertificateManageStatus(String operationKey, DynamicObject faObjs) {
        Long faId = faObjs.getLong("id");
        DynamicObject[] lentOutRegs = CERTIFICATE_QUERY_SERVICE.queryUnUseLentOutRegByFaIds(faId);
        List<Long> certIds = Arrays.stream(lentOutRegs).map(object -> object.getDynamicObject("certificate").getLong("id")).collect(Collectors.toList());
        DynamicObject[] certificates = CERTIFICATE_QUERY_SERVICE.queryById("id,managestatus,recentfaid", certIds);
        String manageStatus = "";
        if ("fa_apply".equals(operationKey)) {
            Arrays.stream(lentOutRegs).forEach(object -> object.set("registerstate", (Object)"0"));
            CERTIFICATE_DOMAIN_SERVICE.updateLentOutRegs(lentOutRegs);
            Arrays.stream(certificates).forEach(object -> object.set("recentfaid", (Object)faId));
            manageStatus = CertManageStatusEnum.STATUS_TOLENTOUT.getKey();
        } else if ("fa_over".equals(operationKey)) {
            Arrays.stream(lentOutRegs).forEach(object -> object.set("registerstate", (Object)"2"));
            CERTIFICATE_DOMAIN_SERVICE.updateLentOutRegs(lentOutRegs);
            manageStatus = CertManageStatusEnum.STATUS_SAVE.getKey();
        }
        this.initCertificateManageStatusSpecial(certificates, manageStatus);
        CERTIFICATE_DOMAIN_SERVICE.batchUpdateCert(certificates);
    }

    public void initCertificateStockStatusSpecial(DynamicObject[] certificates, String stockStatus) {
        if (HRStringUtils.isNotEmpty((String)stockStatus)) {
            for (DynamicObject obj : certificates) {
                obj.set("stockstatus", (Object)stockStatus);
            }
        }
    }

    public void initCertificateManageStatusSpecial(DynamicObject[] certificates, String manageStatus) {
        List<Long> certIds = Arrays.stream(certificates).map(object -> object.getLong("id")).collect(Collectors.toList());
        DynamicObject[] certLentOutRegs = CERTIFICATE_QUERY_SERVICE.queryToLentOutRegByCertIds(certIds);
        List certToLentOutRegIds = Arrays.stream(certLentOutRegs).map(object -> object.getLong("certificate.id")).collect(Collectors.toList());
        ArrayList<Long> certificateIds = new ArrayList<Long>(10);
        for (DynamicObject obj : certificates) {
            if (manageStatus.equals(CertManageStatusEnum.STATUS_TOLENTOUT.getKey())) {
                String oldManageStatus = obj.getString("managestatus");
                if (!oldManageStatus.equals(CertManageStatusEnum.STATUS_SAVE.getKey())) continue;
                obj.set("managestatus", (Object)manageStatus);
                certificateIds.add(obj.getLong("id"));
                continue;
            }
            if (manageStatus.equals(CertManageStatusEnum.STATUS_SAVE.getKey())) {
                if (certToLentOutRegIds.contains(obj.getLong("id"))) {
                    obj.set("managestatus", (Object)CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
                    certificateIds.add(obj.getLong("id"));
                    continue;
                }
                obj.set("managestatus", (Object)manageStatus);
                continue;
            }
            obj.set("managestatus", (Object)manageStatus);
        }
        try {
            SscTaskExternalService.createTask4HRNotActivity("soefam_certlend_ssc", certificateIds);
        }
        catch (Exception exception) {
            LOG.info("CertificateApplicationService.initCertificateManageStatusSpecial.createTask4HRNotActivity.exception:{}", (Object)exception);
        }
    }

    public void generateToLentOutReg(DynamicObject faObjs, DynamicObject[] conCertObjs, DynamicObject[] filingObjs) {
        List<Long> filPersonIds = Arrays.stream(filingObjs).map(object -> object.getLong("id")).collect(Collectors.toList());
        List<Long> conCertTypeIds = Arrays.stream(conCertObjs).map(object -> object.getLong("id")).collect(Collectors.toList());
        DynamicObject[] certificates = CERTIFICATE_QUERY_SERVICE.queryByFilPersonAndConCertType(filPersonIds, conCertTypeIds);
        List<Long> certList = Arrays.stream(certificates).map(object -> object.getLong("id")).collect(Collectors.toList());
        Long faId = faObjs.getLong("id");
        CERTIFICATE_DOMAIN_SERVICE.delToLentOutReg(faId);
        CERTIFICATE_DOMAIN_SERVICE.saveLentOutRegs(faId, certList);
    }

    public void updateCertOrg(DynamicObject filPerson) {
        Long personId = filPerson.getLong("person.id");
        DynamicObject[] certificates = CERTIFICATE_QUERY_SERVICE.queryCertificateByPersonId(personId);
        LOG.info("CertificateApplicationService.updateCertOrg certificates.length : {} personId : {}", (Object)certificates.length, (Object)personId);
        Long orgId = filPerson.getLong("org");
        if (certificates != null && certificates.length > 0) {
            Arrays.stream(certificates).forEach(dynamicObject -> dynamicObject.set("org", (Object)orgId));
            CERTIFICATE_DOMAIN_SERVICE.batchUpdateCert(certificates);
            List<Long> certificateIds = Arrays.stream(certificates).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            DynamicObject[] certinfos = CERTIFICATE_QUERY_SERVICE.queryCertInfoByCertIds(certificateIds);
            if (certinfos != null && certinfos.length > 0) {
                Arrays.stream(certinfos).forEach(dynamicObject -> dynamicObject.set("org", (Object)orgId));
                CERTIFICATE_DOMAIN_SERVICE.saveCertInfo(certinfos);
            }
        }
    }
}

