/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.service.filingsperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class FilPerScopeApplicationService {
    private static final Log LOG = LogFactory.getLog(FilPerScopeApplicationService.class);
    private static final HRBaseServiceHelper DEPEMPSERVICEHELPER = new HRBaseServiceHelper("hrpi_depemp");
    private static final HRBaseServiceHelper EMPPOSORGRELSERVICEHELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper FILINGPERBASESERVICEHELPER = new HRBaseServiceHelper("soefam_filingperbase");
    private static final HRBaseServiceHelper PERSONINFOSERVICEHELPER = new HRBaseServiceHelper("hrpi_pernontsprop");
    private static final ManageOrgRangeQueryService MANAGE_ORG_RANGE_QUERY_SERVICE = ServiceFactory.getService(ManageOrgRangeQueryService.class);

    public static QFilter getCommonFilter() {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        filter.and(new QFilter("businessstatus", "=", (Object)"1"));
        return filter;
    }

    public static DynamicObject[] getEmpMatchDep(QFilter[] qFilter) {
        return DEPEMPSERVICEHELPER.query("id,person,employee,isprimary,adminorg,postype,stdposition", qFilter);
    }

    public static DynamicObject[] listPersonInfoDys(List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        qf.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qf.and(new QFilter("datastatus", "=", (Object)"1"));
        qf.and(new QFilter("initstatus", "=", (Object)"2"));
        return PERSONINFOSERVICEHELPER.query("id,person,gender", new QFilter[]{qf});
    }

    public static DynamicObject[] getEmpposorgrelByEmployeeIds(List<Long> matchedEmployeeIdList) {
        QFilter commonFilter = FilPerScopeApplicationService.getCommonFilter();
        commonFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        commonFilter.and(new QFilter("employee.id", "in", matchedEmployeeIdList));
        return EMPPOSORGRELSERVICEHELPER.query("id,person,adminorg,company,position,job,isprimary,cmpemp,depemp,employee,stdposition", commonFilter.toArray());
    }

    public static DynamicObject[] getAllEmpposorgrelByEmployeeIds(List<Long> matchedEmployeeIdList) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("isprimary", "=", (Object)"1"));
        filter.and(new QFilter("employee.id", "in", matchedEmployeeIdList));
        return EMPPOSORGRELSERVICEHELPER.query("id,person,adminorg,company,position,job,isprimary,cmpemp,depemp,employee,stdposition,businessstatus,datastatus,startdate,enddate,createtime", filter.toArray(), "createtime asc");
    }

    public static DynamicObject[] listEmpPosOrgRelDys(List<Long> depEmpIds) {
        QFilter commonFilter = FilPerScopeApplicationService.getCommonFilter();
        QFilter qf = new QFilter("depemp.id", "in", depEmpIds);
        return EMPPOSORGRELSERVICEHELPER.query("id,depemp,employee,company,adminorg,position", new QFilter[]{commonFilter, qf});
    }

    public static void toInvalidateFilPer(List<Long> matchedPersonIdList, List<Long> allPersonIdList, DynamicObject[] manOrgRangeList, boolean hasDefinitePersons) {
        QFilter filter = new QFilter("person.id", "not in", matchedPersonIdList);
        if (hasDefinitePersons) {
            filter.and(new QFilter("person.id", "in", allPersonIdList));
        }
        filter.and(new QFilter("effstatus", "!=", (Object)"0"));
        filter.and(new QFilter("entrymethod", "=", (Object)"0"));
        List manageOrgIds = Arrays.stream(manOrgRangeList).map(manOrgRange -> manOrgRange.getLong("manageorg.id")).collect(Collectors.toList());
        filter.and(new QFilter("primanageorg", "in", manageOrgIds));
        DynamicObject[] toHandleFilPers = FILINGPERBASESERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        Object[] toDeleteFilPers = Arrays.stream(toHandleFilPers).filter(toInvalidateFilPer -> "1".equals(toInvalidateFilPer.getString("listtype"))).map(toInvalidateFilPer -> toInvalidateFilPer.getLong("id")).toArray();
        FILINGPERBASESERVICEHELPER.delete(toDeleteFilPers);
        List<DynamicObject> toInvalidateFilPers = Arrays.stream(toHandleFilPers).filter(toInvalidateFilPer -> "0".equals(toInvalidateFilPer.getString("listtype"))).collect(Collectors.toList());
        for (DynamicObject toInvalidateFilPer2 : toInvalidateFilPers) {
            toInvalidateFilPer2.set("listtype", (Object)"2");
        }
        FILINGPERBASESERVICEHELPER.update(toInvalidateFilPers.toArray(new DynamicObject[0]));
    }

    public static void toAddFilPer(List<Long> matchedPersonIdList, Map<Long, Long> matchedEmployeeMap, Map<Long, DynamicObject> matchEmpPosOrgRelMap, Map<Long, Long> personRecPersonTypeMap, Map<Long, DynamicObject> personManageOrgMap, List<Map<String, Long>> resultList) {
        if (matchedPersonIdList.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("person.id", "in", matchedPersonIdList);
        DynamicObject[] existFilPers = FILINGPERBASESERVICEHELPER.loadDynamicObjectArray(filter.toArray());
        List effectPersonIds = Arrays.stream(existFilPers).filter(existFilPer -> !"0".equals(existFilPer.getString("effstatus"))).map(effectFilPer -> effectFilPer.getLong("person.id")).collect(Collectors.toList());
        matchedPersonIdList.removeAll(effectPersonIds);
        ArrayList<DynamicObject> filingPers = new ArrayList<DynamicObject>(10);
        List cadreInfoList = Arrays.stream(CadreInfoConsumerHelper.getCadreByPersonIds(matchedPersonIdList)).filter(dy -> "1".equals(dy.getString("businessstatus"))).collect(Collectors.toList());
        HashMap<Long, Long> cadreMap = new HashMap<Long, Long>(cadreInfoList.size());
        for (Object cadreInfo : cadreInfoList) {
            cadreMap.put(cadreInfo.getLong("person.id"), cadreInfo.getLong("id"));
        }
        LOG.info("FilPerScopeApplicationService.toAddFilPer cadreMap : {}", cadreMap);
        DynamicObject[] onBusManageOrg = MANAGE_ORG_RANGE_QUERY_SERVICE.getOnBusManageOrgInfo("0", null);
        for (Long personId : matchedPersonIdList) {
            FilPerScopeApplicationService.setFilPerInfoDynObj(matchedEmployeeMap, matchEmpPosOrgRelMap, resultList, personRecPersonTypeMap.get(personId), "0", filingPers, personId, cadreMap, onBusManageOrg.length > 0 ? onBusManageOrg[0].getLong("manageorg.id") : 0L, personManageOrgMap.get(personId).getLong("id"));
        }
        FILINGPERBASESERVICEHELPER.save(filingPers.toArray(new DynamicObject[0]));
        List<DynamicObject> ruleFilPers = Arrays.stream(existFilPers).filter(existFilPer -> "0".equals(existFilPer.getString("entrymethod"))).collect(Collectors.toList());
        for (DynamicObject ruleFilPer : ruleFilPers) {
            long oldPriManageOrgId = ruleFilPer.getLong("primanageorg.id");
            if (oldPriManageOrgId == 0L) {
                FilPerScopeApplicationService.manageOrgAssignment(personRecPersonTypeMap, personManageOrgMap, onBusManageOrg, ruleFilPer);
                continue;
            }
            if (ruleFilPer.getString("effstatus").equals("0")) continue;
            long newPriManageOrgId = personManageOrgMap.get(ruleFilPer.getLong("person.id")).getLong("id");
            String listType = ruleFilPer.getString("listtype");
            if ("0".equals(listType)) {
                if (oldPriManageOrgId == newPriManageOrgId) continue;
                ruleFilPer.set("listtype", (Object)"2");
                continue;
            }
            if ("1".equals(listType)) {
                if (oldPriManageOrgId == newPriManageOrgId) continue;
                FilPerScopeApplicationService.manageOrgAssignment(personRecPersonTypeMap, personManageOrgMap, onBusManageOrg, ruleFilPer);
                continue;
            }
            if (!"2".equals(listType) || oldPriManageOrgId != newPriManageOrgId) continue;
            ruleFilPer.set("listtype", (Object)"0");
        }
        FILINGPERBASESERVICEHELPER.update(ruleFilPers.toArray(new DynamicObject[0]));
    }

    public static void manageOrgAssignment(Map<Long, Long> personRecPersonTypeMap, Map<Long, DynamicObject> personManageOrgMap, DynamicObject[] onBusManageOrg, DynamicObject ruleFilPer) {
        DynamicObjectCollection manageOrgs = ruleFilPer.getDynamicObjectCollection("manageorg");
        manageOrgs.clear();
        if (onBusManageOrg.length > 0) {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)onBusManageOrg[0].getDynamicObject("manageorg"));
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(1)).set("fbasedataid", (Object)personManageOrgMap.get(ruleFilPer.getLong("person.id")));
        } else {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)personManageOrgMap.get(ruleFilPer.getLong("person.id")));
        }
        ruleFilPer.set("primanageorg", (Object)personManageOrgMap.get(ruleFilPer.getLong("person.id")));
        ruleFilPer.set("recpersontype", (Object)personRecPersonTypeMap.get(ruleFilPer.getLong("person.id")));
    }

    public static void setFilPerInfoDynObj(Map<Long, Long> matchedEmployeeMap, Map<Long, DynamicObject> matchEmpPosOrgRelMap, List<Map<String, Long>> resultList, Long recPersonTypeId, String entryMethod, List<DynamicObject> filingPers, Long personId, Map<Long, Long> cadreMap, long onBusManageOrgId, long priManageOrgId) {
        DynamicObject filingPer = FILINGPERBASESERVICEHELPER.generateEmptyDynamicObject();
        filingPer.set("person", (Object)personId);
        filingPer.set("employee", (Object)matchedEmployeeMap.get(personId));
        Long cadreId = cadreMap.get(personId);
        Optional.ofNullable(cadreId).ifPresent(id -> {
            filingPer.set("cadrefile", id);
            filingPer.set("iscadre", (Object)1);
        });
        DynamicObject empPosOrgRel = matchEmpPosOrgRelMap.get(personId);
        if (empPosOrgRel != null) {
            filingPer.set("number", empPosOrgRel.get("person") != null ? empPosOrgRel.getString("person.name") : null);
            filingPer.set("empposorgrel", (Object)empPosOrgRel.getLong("id"));
            long adminOrgId = empPosOrgRel.getLong("adminorg.id");
            filingPer.set("admorg", (Object)adminOrgId);
            LOG.info("FilPer.FilPerInfoDynObj.adminOrgId:{}", (Object)adminOrgId);
            LOG.info("FilPer.FilPerInfoDynObj.resultList:{}", resultList);
            for (Map<String, Long> result : resultList) {
                Long hrAdminOrgId = result.get("adminOrgId");
                if (hrAdminOrgId != adminOrgId) continue;
                Long hrBuId = result.get("hrBuId");
                filingPer.set("org", (Object)hrBuId);
            }
        }
        filingPer.set("primanageorg", (Object)priManageOrgId);
        DynamicObjectCollection manageOrgs = filingPer.getDynamicObjectCollection("manageorg");
        if (onBusManageOrgId != 0L) {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)onBusManageOrgId);
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(1)).set("fbasedataid", (Object)priManageOrgId);
        } else {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)priManageOrgId);
        }
        filingPer.set("manageorg", (Object)manageOrgs);
        filingPer.set("recpersontype", (Object)recPersonTypeId);
        filingPer.set("indexfield", (Object)personId);
        filingPer.set("entrymethod", (Object)entryMethod);
        filingPer.set("effstatus", null);
        filingPer.set("status", (Object)"C");
        filingPer.set("enable", (Object)"1");
        filingPer.set("listtype", (Object)"1");
        filingPer.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        filingPers.add(filingPer);
    }
}

