/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.service.filingsperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.service.filingsperson.FilPerScopeApplicationService;
import kd.sihc.soefam.business.domain.filingsperson.FilPersonService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonConstants;
import kd.sihc.soefam.common.enums.FilingStatusEnum;

public class FilPersonApplicationService
implements FilPersonConstants {
    private static final Log LOG = LogFactory.getLog(FilPersonApplicationService.class);
    private static final FilPersonService FIL_PERSON_SERVICE = ServiceFactory.getService(FilPersonService.class);
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = ServiceFactory.getService(FilPersonQueryService.class);
    private static final ManageOrgRangeQueryService MANAGE_ORG_RANGE_QUERY_SERVICE = ServiceFactory.getService(ManageOrgRangeQueryService.class);

    public void saveFilPersonInfo(List<Long> employeeIds, Map<Long, Map<Long, Long>> empIdAndTypeId) {
        HashMap<Long, Long> matchedEmployeeMap = new HashMap<Long, Long>(employeeIds.size());
        HashMap<Long, Long> matchedPersonMap = new HashMap<Long, Long>(employeeIds.size());
        HashMap<Long, DynamicObject> matchEmpPosOrgRelMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
        this.assemblyPerParam(employeeIds, matchedEmployeeMap, matchedPersonMap, matchEmpPosOrgRelMap, paramMap);
        List<Map<String, Long>> resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, HRCSRpcConstants.BIZ_OBJ_TYPE);
        ArrayList<DynamicObject> filingPerInfo = new ArrayList<DynamicObject>(employeeIds.size());
        ArrayList personIds = new ArrayList(matchedEmployeeMap.keySet());
        List cadreInfoList = Arrays.stream(CadreInfoConsumerHelper.getCadreByPersonIds(personIds)).filter(dy -> "1".equals(dy.getString("businessstatus"))).collect(Collectors.toList());
        HashMap<Long, Long> cadreMap = new HashMap<Long, Long>(cadreInfoList.size());
        for (DynamicObject cadreInfo : cadreInfoList) {
            cadreMap.put(cadreInfo.getLong("person.id"), cadreInfo.getLong("id"));
        }
        LOG.info("FilPersonApplicationService.saveFilPersonInfo cadreMap : {}", cadreMap);
        DynamicObject[] onBusManageOrg = MANAGE_ORG_RANGE_QUERY_SERVICE.getOnBusManageOrgInfo("0", null);
        long onBusManageOrgId = 0L;
        if (onBusManageOrg.length > 0) {
            onBusManageOrgId = onBusManageOrg[0].getLong("manageorg.id");
        }
        for (Long employeeId : employeeIds) {
            Map<Long, Long> dataMap = empIdAndTypeId.get(employeeId);
            Long recPersonTypeId = 0L;
            Long managerOrgId = 0L;
            for (Map.Entry<Long, Long> map : dataMap.entrySet()) {
                recPersonTypeId = map.getKey();
                managerOrgId = map.getValue();
            }
            FilPerScopeApplicationService.setFilPerInfoDynObj(matchedEmployeeMap, matchEmpPosOrgRelMap, resultList, recPersonTypeId, "1", filingPerInfo, (Long)matchedPersonMap.get(employeeId), cadreMap, onBusManageOrgId, managerOrgId);
        }
        FIL_PERSON_SERVICE.savePersonInfo(filingPerInfo.toArray(new DynamicObject[0]));
    }

    public void savePenFilPersonInfo(List<Long> filPerIds) {
        DynamicObject[] filPersonInfos;
        for (DynamicObject filPerDynObj : filPersonInfos = FIL_PERSON_QUERY_SERVICE.getFilPersonInfos(filPerIds)) {
            filPerDynObj.set("listtype", (Object)"2");
        }
        FIL_PERSON_SERVICE.savePersonInfo(filPersonInfos);
    }

    private void assemblyPerParam(List<Long> employeeIds, Map<Long, Long> matchedEmployeeMap, Map<Long, Long> matchedPersonMap, Map<Long, DynamicObject> matchEmpPosOrgRelMap, Map<Long, Set<Long>> paramMap) {
        DynamicObject[] empPosOrgRel;
        DynamicObject[] allDepEmp;
        QFilter commonFilter = FilPerScopeApplicationService.getCommonFilter();
        QFilter empQf = commonFilter.and(new QFilter("employee.id", "in", employeeIds));
        for (DynamicObject depEmp : allDepEmp = FilPerScopeApplicationService.getEmpMatchDep(new QFilter[]{empQf})) {
            long employeeId = depEmp.getLong("employee.id");
            long personId = depEmp.getLong("person.id");
            matchedEmployeeMap.put(personId, employeeId);
            matchedPersonMap.put(employeeId, personId);
        }
        for (DynamicObject empPosOrg : empPosOrgRel = FilPerScopeApplicationService.getEmpposorgrelByEmployeeIds(employeeIds)) {
            paramMap.put(empPosOrg.getLong("adminorg.id"), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
            matchEmpPosOrgRelMap.put(empPosOrg.getLong("person.id"), empPosOrg);
        }
    }

    public void updatePersonInfos(IFormView view, List<Long> perIds) {
        DynamicObject[] filPersonInfo = FIL_PERSON_QUERY_SERVICE.getFilPersonInfos(perIds);
        DynamicObjectCollection entityColl = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject filPer : filPersonInfo) {
            for (DynamicObject entity : entityColl) {
                if (filPer.getLong("id") != entity.getLong("filpersonid")) continue;
                filPer.set("recpersontype", entity.get("modrecpersontype"));
            }
        }
        FIL_PERSON_SERVICE.updatePersonInfos(filPersonInfo);
    }

    public void updateConFilPersonStatusForAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> filPersonList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            String filingStatus = dynamicObject.getString("filingstatus");
            if (!HRStringUtils.isEmpty((String)filingStatus)) continue;
            dynamicObject.set("listtype", (Object)"0");
            dynamicObject.set("effstatus", (Object)"1");
            dynamicObject.set("iregscopedate", (Object)new Date());
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("filingstatus", (Object)FilingStatusEnum.UNREGISTERED.code);
            filPersonList.add(dynamicObject);
        }
        if (!filPersonList.isEmpty()) {
            FIL_PERSON_SERVICE.updatePersonInfos(filPersonList.toArray(new DynamicObject[0]));
        }
    }

    public void updateFilPersonStatusForIgnore(DynamicObject[] dataEntities) {
        List<Object> filPersonList = Arrays.stream(dataEntities).map(filPer -> filPer.getLong("id")).collect(Collectors.toList());
        if (!filPersonList.isEmpty()) {
            FIL_PERSON_SERVICE.delPersonInfos(filPersonList.toArray(new Object[0]));
        }
    }

    public void updateFilPersonStatusForExitIgnore(DynamicObject[] dataEntities) {
        for (DynamicObject dynObj : dataEntities) {
            dynObj.set("listtype", (Object)"0");
        }
        FIL_PERSON_SERVICE.updatePersonInfos(dataEntities);
    }

    public void updatePenFilPersonStatusForAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> filPersonList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("listtype", null);
            dynamicObject.set("effstatus", (Object)"0");
            if (dynamicObject.get("filingstatus") != null && FilingStatusEnum.RECORDED.code.equals(dynamicObject.get("filingstatus"))) {
                dynamicObject.set("filingstatus", (Object)FilingStatusEnum.PEND_TERM_FILING.code);
            } else {
                dynamicObject.set("filingstatus", null);
            }
            dynamicObject.set("oregscopedate", (Object)new Date());
            dynamicObject.set("indexfield", (Object)dynamicObject.getLong("id"));
            filPersonList.add(dynamicObject);
        }
        if (!filPersonList.isEmpty()) {
            FIL_PERSON_SERVICE.updatePersonInfos(filPersonList.toArray(new DynamicObject[0]));
        }
    }
}

