/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.application.service.manageorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class ManageOrgApplicationService {
    private static final Log logger = LogFactory.getLog(ManageOrgApplicationService.class);
    private static final ManageOrgRangeQueryService MANAGE_ORG_RANGE_QUERY_SERVICE = ServiceFactory.getService(ManageOrgRangeQueryService.class);
    private static final CertificateDomainService CERTIFICATE_DOMAIN_SERVICE = ServiceFactory.getService(CertificateDomainService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();

    public List<Long> getManageOrgInfo(String queType, String entityNum) {
        Map manMap = PermissionUtils.invokeGetEntityDimValue((String)entityNum);
        logger.info("ManageOrgApplication.getManageOrgInfo.manMap:{}", (Object)manMap);
        boolean flag = false;
        List<Long> manageOrgIds = new ArrayList<Long>(16);
        for (Map.Entry map : manMap.entrySet()) {
            flag = (Boolean)map.getKey();
            manageOrgIds = (List)map.getValue();
        }
        if (!flag && manageOrgIds.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] onBusManageOrgInfo = MANAGE_ORG_RANGE_QUERY_SERVICE.getOnBusManageOrgInfo(queType, manageOrgIds);
        logger.info("ManageOrgApplication.getManageOrgInfo.manageOrgIds:{}", manageOrgIds);
        if (onBusManageOrgInfo != null && onBusManageOrgInfo.length > 0) {
            return Arrays.stream(onBusManageOrgInfo).map(onBusManage -> onBusManage.getDynamicObject("manageorg").getLong("id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Long> getUsableManageOrgInfo(String queType, String entityNum) {
        Map manMap = PermissionUtils.invokeGetEntityDimValue((String)entityNum);
        logger.info("ManageOrgApplication.getUsableManageOrgInfo.manMap:{}", (Object)manMap);
        boolean flag = false;
        List<Long> manageOrgIds = new ArrayList<Long>(16);
        for (Map.Entry map : manMap.entrySet()) {
            flag = (Boolean)map.getKey();
            manageOrgIds = (List)map.getValue();
        }
        if (!flag && manageOrgIds.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] onBusManageOrgInfo = MANAGE_ORG_RANGE_QUERY_SERVICE.getUsableManageOrgInfo(queType, manageOrgIds);
        if (onBusManageOrgInfo != null && onBusManageOrgInfo.length > 0) {
            return Arrays.stream(onBusManageOrgInfo).map(onBusManage -> onBusManage.getDynamicObject("manageorg").getLong("id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void updateManageOrgForFilPerAndCert(Long manageOrgId) {
        CERTIFICATE_DOMAIN_SERVICE.updateManageOrg(manageOrgId);
        FILPERSONMG_APPLICATION_SERVICE.updateFilPerManageOrg(manageOrgId);
    }

    public void updateFilPerManage(List<Long> manageOrgId) {
        FILPERSONMG_APPLICATION_SERVICE.updateFilPerState(manageOrgId);
    }

    public ArrayList<Long> queryAdmOrgIdByStructId(Long structId) {
        Map<String, Map<String, Object>> admOrgMap = HrmpExternalService.queryStructInfoByProIdAndLevel(structId);
        ArrayList<Long> admOrgIdList = new ArrayList<Long>(10);
        admOrgMap.forEach((k, v) -> admOrgIdList.add(Long.valueOf(k)));
        return admOrgIdList;
    }
}

