/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;

public class CertificateDomainService
implements CertificateConstants {
    private static final Log LOG = LogFactory.getLog(CertificateDomainService.class);
    private static final HRBaseServiceHelper CERTIFICATE_HELPER = new HRBaseServiceHelper("soefam_certificate");
    private static final HRBaseServiceHelper CERTINFO_HELPER = new HRBaseServiceHelper("soefam_certinfo");
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final CertlentoutregHelper CERTLENTOUTREGHELPER = CertlentoutregHelper.init();
    private static final CertreturnregHelper CERTRETURNREGHELPER = CertreturnregHelper.init();
    private static final HRBaseServiceHelper CERTINREG_HELPER = new HRBaseServiceHelper("soefam_certinreg");
    private static final ManageOrgRangeQueryService MANAGE_ORG_RANGE_QUERY_SERVICE = ServiceFactory.getService(ManageOrgRangeQueryService.class);

    public void initCertificate(String operationKey, DynamicObject[] filPersons, DynamicObject[] conCertTypes) {
        List<Long> personIds = Arrays.stream(filPersons).map(object -> object.getLong("person.id")).collect(Collectors.toList());
        List<Long> conCertTypeIds = Arrays.stream(conCertTypes).map(object -> object.getLong("id")).collect(Collectors.toList());
        DynamicObject[] existCertificates = CERTIFICATE_QUERY_SERVICE.queryByPersonIdAndConCertType(personIds, conCertTypeIds);
        LOG.info("personIds : {}", personIds);
        ArrayList<DynamicObject> certListForAdd = new ArrayList<DynamicObject>(conCertTypes.length);
        ArrayList<DynamicObject> certListForUpdate = new ArrayList<DynamicObject>(conCertTypes.length);
        ArrayList<DynamicObject> certListForDel = new ArrayList<DynamicObject>(conCertTypes.length);
        for (DynamicObject conCertType : conCertTypes) {
            for (DynamicObject filPerson : filPersons) {
                this.buildCertificateList(operationKey, conCertType, filPerson, existCertificates, certListForAdd, certListForUpdate, certListForDel);
            }
        }
        LOG.info("CertificateDomainService.initCertificate certListForAdd : {}", (Object)certListForAdd.size());
        LOG.info("CertificateDomainService.initCertificate certListForUpdate : {}", (Object)certListForUpdate.size());
        LOG.info("CertificateDomainService.initCertificate certListForDel : {}", (Object)certListForDel.size());
        if (!certListForAdd.isEmpty()) {
            CERTIFICATE_HELPER.save(certListForAdd.toArray(new DynamicObject[0]));
        }
        if (!certListForUpdate.isEmpty()) {
            CERTIFICATE_HELPER.update(certListForUpdate.toArray(new DynamicObject[0]));
        }
        if (!certListForDel.isEmpty()) {
            CERTIFICATE_HELPER.delete((Object[])certListForDel.toArray(new DynamicObject[0]));
        }
    }

    private void buildCertificateList(String operationKey, DynamicObject conCertType, DynamicObject filPerson, DynamicObject[] existCertificates, List<DynamicObject> certListForAdd, List<DynamicObject> certListForUpdate, List<DynamicObject> certListForDel) {
        Long conCertTypeId = conCertType.getLong("id");
        String controlClassFy = conCertType.getString("controlclassify");
        Long filPersonId = filPerson.getLong("id");
        Long personId = filPerson.getLong("person.id");
        DynamicObject org = filPerson.getDynamicObject("org");
        DynamicObjectCollection manageOrgs = filPerson.getDynamicObjectCollection("manageorg");
        List<Long> manageOrgIds = manageOrgs.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList());
        Long manageOrgId = null;
        if (HRStringUtils.equals((String)controlClassFy, (String)"0")) {
            DynamicObject[] manageOrgObj = MANAGE_ORG_RANGE_QUERY_SERVICE.getOnBusManageOrgInfo(controlClassFy, manageOrgIds);
            if (manageOrgObj != null && manageOrgObj.length > 0) {
                manageOrgId = manageOrgObj[0].getDynamicObject("manageorg").getLong("id");
            }
        } else {
            manageOrgId = filPerson.getDynamicObject("primanageorg").getLong("id");
        }
        if (operationKey.equals("save")) {
            for (DynamicObject dynamicObject : existCertificates) {
                Long existFilPersonId = dynamicObject.getLong("person.id");
                if (!personId.equals(existFilPersonId)) continue;
                dynamicObject.set("manageorg", (Object)manageOrgId);
                certListForUpdate.add(dynamicObject);
            }
            return;
        }
        for (DynamicObject dynamicObject : existCertificates) {
            Long existConCertTypeId = dynamicObject.getDynamicObject("concerttype").getLong("id");
            Long existFilPersonId = dynamicObject.getLong("person.id");
            Long existManageOrgId = dynamicObject.getLong("manageorg.id");
            if (!conCertTypeId.equals(existConCertTypeId) || !personId.equals(existFilPersonId) || !existManageOrgId.equals(manageOrgId)) continue;
            String stockStatus = dynamicObject.getString("stockstatus");
            if (operationKey.equals("audit") || operationKey.equals("enable")) {
                if (stockStatus.equals(CertStockStatusEnum.STATUS_TOOUT.getKey())) {
                    dynamicObject.set("stockstatus", (Object)CertStockStatusEnum.STATUS_IN.getKey());
                } else if (stockStatus.equals(CertStockStatusEnum.STATUS_OUT.getKey())) {
                    dynamicObject.set("stockstatus", (Object)CertStockStatusEnum.STATUS_NOTIN.getKey());
                }
                dynamicObject.set("filperson", (Object)filPerson);
                dynamicObject.set("org", (Object)org);
                certListForUpdate.add(dynamicObject);
            } else if (operationKey.equals("unaudit") || operationKey.equals("disable")) {
                if (stockStatus.equals(CertStockStatusEnum.STATUS_NOTIN.getKey())) {
                    Long certInfoId = dynamicObject.getLong("certinfo.id");
                    if (certInfoId == null || certInfoId == 0L) {
                        certListForDel.add(dynamicObject);
                    } else {
                        dynamicObject.set("stockstatus", (Object)CertStockStatusEnum.STATUS_OUT.getKey());
                        dynamicObject.set("managestatus", (Object)"");
                        certListForUpdate.add(dynamicObject);
                    }
                } else if (stockStatus.equals(CertStockStatusEnum.STATUS_IN.getKey())) {
                    dynamicObject.set("stockstatus", (Object)CertStockStatusEnum.STATUS_TOOUT.getKey());
                    certListForUpdate.add(dynamicObject);
                }
            }
            return;
        }
        if (operationKey.equals("audit") || operationKey.equals("enable")) {
            DynamicObject certificateForAdd = CERTIFICATE_HELPER.generateEmptyDynamicObject();
            certificateForAdd.set("concerttype", (Object)conCertTypeId);
            certificateForAdd.set("filperson", (Object)filPersonId);
            certificateForAdd.set("person", (Object)personId);
            certificateForAdd.set("stockstatus", (Object)CertStockStatusEnum.STATUS_NOTIN.getKey());
            certificateForAdd.set("enable", (Object)"1");
            certificateForAdd.set("org", (Object)org);
            certificateForAdd.set("manageorg", (Object)manageOrgId);
            certListForAdd.add(certificateForAdd);
        }
    }

    public int updateEffectiveStatus() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        Date nowDate = HRDateTimeUtils.getNowDate();
        QFilter qFilter1 = new QFilter("effectivestatus", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("pervaldate", "<", (Object)nowDate);
        DynamicObject[] certInfoList = CERTINFO_HELPER.query("id,effectivestatus,certificate", new QFilter[]{qFilter, qFilter1, qFilter2});
        Arrays.stream(certInfoList).forEach(object -> object.set("effectivestatus", (Object)"0"));
        return CERTINFO_HELPER.update(certInfoList).length;
    }

    public void batchUpdateCert(DynamicObject[] certificates) {
        CERTIFICATE_HELPER.update(certificates);
    }

    public void updateLentOutRegs(DynamicObject[] certLentOutRegs) {
        CERTLENTOUTREGHELPER.update(certLentOutRegs);
    }

    public void delToLentOutReg(Long faId) {
        QFilter qFilter = new QFilter("faid", "=", (Object)faId);
        CERTLENTOUTREGHELPER.deleteByFilter(new QFilter[]{qFilter});
    }

    public void saveLentOutRegs(Long faId, List<Long> certList) {
        ArrayList<DynamicObject> lentOutRegs = new ArrayList<DynamicObject>(4);
        for (Long certId : certList) {
            DynamicObject obj = CERTLENTOUTREGHELPER.generateEmptyDynamicObject();
            obj.set("faid", (Object)faId);
            obj.set("certificate", (Object)certId);
            lentOutRegs.add(obj);
        }
        if (!lentOutRegs.isEmpty()) {
            CERTLENTOUTREGHELPER.save(lentOutRegs.toArray(new DynamicObject[lentOutRegs.size()]));
        }
    }

    public void saveCertificate(DynamicObject[] certinfos) {
        CERTIFICATE_HELPER.save(certinfos);
    }

    public void saveCertInfo(DynamicObject[] certinfos) {
        this.setCertEffectiveStatus(certinfos);
        CERTINFO_HELPER.save(certinfos);
    }

    public void setCertEffectiveStatus(DynamicObject[] certinfos) {
        for (DynamicObject certinfo : certinfos) {
            certinfo.set("enable", (Object)"1");
            certinfo.set("status", (Object)"C");
            Date pervalDate = certinfo.getDate("pervaldate");
            Date date = HRDateTimeUtils.getNowDate();
            if (HRDateTimeUtils.dayAfter((Date)date, (Date)pervalDate)) {
                certinfo.set("effectivestatus", (Object)"0");
                continue;
            }
            certinfo.set("effectivestatus", (Object)"1");
        }
    }

    public void updateConCertType() {
        HRBaseServiceHelper conCertHelp = new HRBaseServiceHelper("soefam_concerttype");
        QFilter qFilter = new QFilter("id", "is not null", null);
        DynamicObject[] conCertDyn = conCertHelp.loadDynamicObjectArray(qFilter.toArray());
        ArrayList<DynamicObject> updateConDyn = new ArrayList<DynamicObject>(conCertDyn.length);
        for (DynamicObject dynObj : conCertDyn) {
            if (dynObj.get("credentialstype") == null || dynObj.getDynamicObject("credentialstype").getString("number").equals(dynObj.getString("number")) && dynObj.getDynamicObject("credentialstype").getString("name").equals(dynObj.getString("name"))) continue;
            dynObj.set("number", dynObj.getDynamicObject("credentialstype").get("number"));
            dynObj.set("name", dynObj.getDynamicObject("credentialstype").get("name"));
            updateConDyn.add(dynObj);
        }
        conCertHelp.update(updateConDyn.toArray(new DynamicObject[0]));
    }

    public DynamicObject generateCertInReg() {
        return CERTINREG_HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject generateCertInfo() {
        return CERTINFO_HELPER.generateEmptyDynamicObject();
    }

    public void saveCerInReg(DynamicObject[] certInRegs) {
        CERTINREG_HELPER.save(certInRegs);
    }

    public void saveOnlyCertInfo(DynamicObject[] certInfos) {
        CERTINFO_HELPER.save(certInfos);
    }

    public void updateCertIfiCate(DynamicObject[] certIfiCates) {
        CERTIFICATE_HELPER.update(certIfiCates);
    }

    public void updateCertInfo(DynamicObject[] certInfos) {
        CERTINFO_HELPER.update(certInfos);
    }

    public void deleteCertInfoByBatchNumber(Long batchNumber) {
        QFilter filter = new QFilter("initbatch", "=", (Object)batchNumber);
        CERTINFO_HELPER.deleteByFilter(filter.toArray());
    }

    public void deleteCertInRegByCertIfiCateIds(List<Long> certIfiCateIds) {
        QFilter filter = new QFilter("certificate", "in", certIfiCateIds);
        CERTINREG_HELPER.deleteByFilter(filter.toArray());
    }

    public void deleteCertIfiCateByBatchNumber(Long batchNumber) {
        QFilter filter = new QFilter("initbatch", "=", (Object)batchNumber);
        CERTIFICATE_HELPER.deleteByFilter(filter.toArray());
    }

    public void updateManageOrg(Long manageOrgId) {
        DynamicObject[] certificateList = CERTIFICATE_QUERY_SERVICE.getCertificateByConType("0");
        Arrays.stream(certificateList).forEach(dynamicObject -> dynamicObject.set("manageorg", (Object)manageOrgId));
        CERTIFICATE_HELPER.update(certificateList);
    }
}

