/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.certificate;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.formservice.CertificateserFormService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertificateInRegDomainService
extends HRBaseServiceHelper {
    private static final CertificateserFormService CERTIFICATESERFORMSERVICE = ServiceFactory.getService(CertificateserFormService.class);
    private static final CertificateQueryService CERTIFICATEQUERYSERVICE = ServiceFactory.getService(CertificateQueryService.class);
    public static final HRBaseServiceHelper CERT_INFO_HELPER = new HRBaseServiceHelper("soefam_certinfo");
    static CertificateInRegDomainService certInRegHelper;

    private CertificateInRegDomainService(String entityName) {
        super(entityName);
    }

    public static synchronized CertificateInRegDomainService init() {
        certInRegHelper = new CertificateInRegDomainService("soefam_certinreg");
        return certInRegHelper;
    }

    public DynamicObject[] getCertificateArray(IFormView formView) {
        Object idList = formView.getFormShowParameter().getCustomParams().get("idList");
        List selectIdList = JSON.parseArray((String)idList.toString(), Long.class);
        List<String> propList = Arrays.asList("filperson", "concerttype", "storageplace", "certinfo", "onfilenum");
        String properties = String.join((CharSequence)",", propList);
        return CERTIFICATEQUERYSERVICE.queryById(properties, selectIdList, null, "filperson.cadrefile.rulesortnum asc,filperson.cadrefile.usersortnum asc,filperson.recpersontype.number asc,filperson.iregscopedate desc,filperson asc");
    }

    public Map<Long, DynamicObject> getEffectiveData(DynamicObject[] certificateArray) {
        DynamicObject[] queryCerList = this.queryEffectiveData(certificateArray);
        Map<Long, Object> historyRecordMap = new HashMap<Long, DynamicObject>(certificateArray.length);
        if (queryCerList != null && queryCerList.length > 0) {
            historyRecordMap = Arrays.stream(queryCerList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), Function.identity(), (v1, v2) -> v1));
        }
        return historyRecordMap;
    }

    public DynamicObject[] queryEffectiveData(DynamicObject[] certificateArray) {
        List certificateIdList = Arrays.stream(certificateArray).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", certificateIdList);
        qFilter.and(new QFilter("latestrecord", "=", (Object)"1"));
        return this.query("storagedate,onfilenum,remark", qFilter.toArray());
    }

    public void updateInReg(Object regId, Date storageDate, String remark) {
        DynamicObject regDo = certInRegHelper.queryOne(regId);
        regDo.set("storagedate", (Object)storageDate);
        regDo.set("remark", (Object)remark);
        certInRegHelper.updateOne(regDo);
    }
}

