/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertificateLendDomainService {
    private static final CertlentoutregHelper CERTLENTOUTREGHELPER = CertlentoutregHelper.init();
    private static final CertreturnregHelper CERTRETURNREGHELPER = CertreturnregHelper.init();
    private static final LicenseService LICENSE_SERVICE = ServiceFactory.getService(LicenseService.class);

    public DynamicObject[] getFaidsByCertId(Long pkValue) {
        QFilter certidQFilter = new QFilter("certificate", "=", (Object)pkValue);
        QFilter stateQFilter = new QFilter("registerstate", "=", (Object)"0");
        certidQFilter.and(stateQFilter);
        return CERTLENTOUTREGHELPER.query("faid", certidQFilter.toArray());
    }

    public Map<Long, Long> getnewFaidsByCertId(List<Long> idList) {
        QFilter certidQFilter = new QFilter("certificate", "in", idList);
        QFilter stateQFilter = new QFilter("registerstate", "=", (Object)"0");
        certidQFilter.and(stateQFilter);
        DynamicObject[] query = CERTLENTOUTREGHELPER.query("faid,certificate", certidQFilter.toArray(), " modifytime desc");
        return Arrays.stream(query).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id"), dynamicObject -> dynamicObject.getLong("faid"), (v1, v2) -> v1));
    }

    public void updateCertlentout(DynamicObjectCollection entryentity, List<DynamicObject> updateCertObjectList, List<Long> certificateIds, List<Long> faids) {
        CertificateLendDomainService.setLendHistoryOld(certificateIds);
        ArrayList<DynamicObject> returnRegList = new ArrayList<DynamicObject>(entryentity.size());
        DynamicObject[] CertLends = this.getCertLends(certificateIds, faids);
        Map loanObjMap = Arrays.stream(CertLends).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id") + "_" + dynamicObject.getLong("faid"), Function.identity(), (v1, v2) -> v1));
        for (DynamicObject object : entryentity) {
            DynamicObject dynamicObject2 = (DynamicObject)loanObjMap.get(object.getLong("certificateentity.id") + "_" + object.getLong("faid"));
            dynamicObject2.set("lenddate", object.get("lenddate"));
            dynamicObject2.set("remark", object.get("remark"));
            dynamicObject2.set("registerstate", (Object)"1");
            dynamicObject2.set("latestrecord", (Object)"1");
            dynamicObject2.set("modifytime", (Object)new Date());
            dynamicObject2.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            dynamicObject2.set("receiver", object.get("receiver"));
            DynamicObject returnReg = CERTRETURNREGHELPER.generateEmptyDynamicObject();
            returnReg.set("certificate", (Object)object.getLong("certificateentity.id"));
            returnReg.set("certinfo", (Object)object.getDynamicObject("certificateentity").getLong("certinfo.id"));
            returnReg.set("faid", (Object)object.getLong("faid"));
            returnReg.set("registerstate", (Object)0);
            returnRegList.add(returnReg);
            this.buildUpdateData(updateCertObjectList, object);
        }
        CERTLENTOUTREGHELPER.update(CertLends);
        CERTRETURNREGHELPER.save(returnRegList.toArray(new DynamicObject[0]));
    }

    public void updateCertoverreg(DynamicObjectCollection entryentity, List<DynamicObject> updateCertObjectList, List<Long> certificateIds, List<Long> faids) {
        CertificateLendDomainService.setOverLendHistoryOld(certificateIds);
        DynamicObject[] CertLends = this.getCertLends(certificateIds, faids);
        Map loanObjMap = Arrays.stream(CertLends).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id") + "_" + dynamicObject.getLong("faid"), Function.identity(), (v1, v2) -> v1));
        for (DynamicObject object : entryentity) {
            DynamicObject dynamicObject2 = (DynamicObject)loanObjMap.get(object.getLong("certificateentity.id") + "_" + object.getLong("faid"));
            dynamicObject2.set("remark", object.get("remark"));
            dynamicObject2.set("registerstate", (Object)"2");
            dynamicObject2.set("latestrecord", (Object)"1");
            dynamicObject2.set("modifytime", (Object)new Date());
            dynamicObject2.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            this.buildUpdateData(updateCertObjectList, object);
        }
        CERTLENTOUTREGHELPER.update(CertLends);
    }

    public static void setLendHistoryOld(List<Long> certificateIds) {
        QFilter certnumQFilter = new QFilter("certificate", "in", certificateIds);
        QFilter latestrecordQFilter = new QFilter("latestrecord", "=", (Object)"1");
        QFilter registerStateQFilter = new QFilter("registerstate", "=", (Object)"1");
        certnumQFilter.and(latestrecordQFilter).and(registerStateQFilter);
        DynamicObject[] certList = CERTLENTOUTREGHELPER.query("latestrecord", certnumQFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
            CERTLENTOUTREGHELPER.update(certList);
        }
    }

    public static void setOverLendHistoryOld(List<Long> certificateIds) {
        QFilter certnumQFilter = new QFilter("certificate", "in", certificateIds);
        QFilter latestrecordQFilter = new QFilter("latestrecord", "=", (Object)"1");
        QFilter registerStateQFilter = new QFilter("registerstate", "=", (Object)"2");
        certnumQFilter.and(latestrecordQFilter).and(registerStateQFilter);
        DynamicObject[] certList = CERTLENTOUTREGHELPER.query("latestrecord", certnumQFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
            CERTLENTOUTREGHELPER.update(certList);
        }
    }

    private DynamicObject[] getCertLends(List<Long> certificateIds, List<Long> faids) {
        QFilter faidQFilter = new QFilter("faid", "in", faids);
        QFilter certnumberQFilter = new QFilter("certificate", "in", certificateIds);
        faidQFilter.and(certnumberQFilter);
        List<String> propList = Arrays.asList("certificate", "faid", "registerstate", "lenddate", "remark", "modifytime", "modifier", "latestrecord", "receiver");
        String properties = String.join((CharSequence)",", propList);
        return CERTLENTOUTREGHELPER.query(properties, faidQFilter.toArray());
    }

    private void buildUpdateData(List<DynamicObject> dynamicObjectList, DynamicObject dyObj) {
        DynamicObject certificateObj = dyObj.getDynamicObject("certificateentity");
        certificateObj.set("certinfo", dyObj.getDynamicObject("certificateentity").get("certinfo"));
        dynamicObjectList.add(certificateObj);
    }

    public void checkEffectLicense(IFormView view, BeforeClickEvent evt) {
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        List<Long> personIdList = entity.stream().map(obj -> obj.getLong("certificateentity.person.id")).distinct().collect(Collectors.toList());
        boolean effectLicense = LICENSE_SERVICE.isValidateSecurity(view, personIdList, "soefam_certificate", ResManager.loadKDString((String)"\u501f\u51fa\u767b\u8bb0", (String)"CertificateLendDomainService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
        if (!effectLicense) {
            evt.setCancel(true);
        }
    }
}

