/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.certificate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateInRegDomainService;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.formservice.faapplication.FAApplicationService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertificateMgDomainService
extends HRBaseServiceHelper {
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);
    private static final CertificateInRegDomainService CERTIFICATEINREGDOMAINSERVICE = CertificateInRegDomainService.init();
    private static final CertificateQueryService CERTIFICATEQUERYSERVICE = new CertificateQueryService();
    private static final CertlentoutregHelper CERTLENTOUTREGHELPER = CertlentoutregHelper.init();
    private static final CertreturnregHelper CERTRETURNREGHELPER = CertreturnregHelper.init();
    private static final HRBaseServiceHelper CERT_OUT_REG_HELPER = new HRBaseServiceHelper("soefam_certoutreg");
    private static final Map<String, HRBaseServiceHelper> HELPER_MAP = new HashMap<String, HRBaseServiceHelper>(8);
    public static final String ORDER_FILTER = "filperson.cadrefile.rulesortnum asc,filperson.cadrefile.usersortnum asc,filperson.recpersontype.number asc,filperson.iregscopedate desc,filperson asc";
    private static final Log LOG = LogFactory.getLog(CertificateMgDomainService.class);
    static CertificateMgDomainService certificateMgService;

    private CertificateMgDomainService(String entityName) {
        super(entityName);
    }

    public static synchronized CertificateMgDomainService init() {
        certificateMgService = new CertificateMgDomainService("soefam_certificate");
        return certificateMgService;
    }

    public Map<Object, DynamicObject> queryValidData(String pageKey, QFilter qFilter, String selectProperties, String mapKey) {
        DynamicObject[] recordObjList = HELPER_MAP.get(pageKey).query(selectProperties, qFilter.toArray());
        return Arrays.stream(recordObjList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(mapKey), Function.identity(), (v1, v2) -> v1));
    }

    public DynamicObject[] queryDynamicObjById(String selectProperties, List<Object> idList, QFilter qFilter) {
        if (qFilter != null) {
            qFilter.and(new QFilter("id", "in", idList));
        } else {
            qFilter = new QFilter("id", "in", idList);
        }
        return this.query(selectProperties, qFilter.toArray());
    }

    public void setOutBoundDateData(PackageDataEvent pkd, Object pkValue, Map<Object, DynamicObject> outRecordMap, SimpleDateFormat simpleDateFormat) {
        DynamicObject outRecordObj = outRecordMap.get(pkValue);
        Optional.ofNullable(outRecordObj).ifPresent(dynamicObject -> {
            if (outRecordObj.get("outdate") != null) {
                pkd.setFormatValue((Object)simpleDateFormat.format(outRecordObj.get("outdate")));
            }
        });
    }

    public void setReturnDataData(PackageDataEvent pkd, Object pkValue, Map<Object, DynamicObject> returnRecordMap, SimpleDateFormat simpleDateFormat) {
        DynamicObject returnRecordObj = returnRecordMap.get(pkValue);
        Optional.ofNullable(returnRecordObj).ifPresent(dynamicObject -> {
            if (returnRecordObj.get("returndate") != null) {
                pkd.setFormatValue((Object)simpleDateFormat.format(returnRecordObj.get("returndate")));
            }
        });
    }

    public void setReceiveDateData(PackageDataEvent pkd, Object pkValue, Map<Object, DynamicObject> lendRecordMap, SimpleDateFormat simpleDateFormat) {
        DynamicObject lendRecordObj = lendRecordMap.get(pkValue);
        Optional.ofNullable(lendRecordObj).ifPresent(dynamicObject -> {
            if (lendRecordObj.get("lenddate") != null) {
                pkd.setFormatValue((Object)simpleDateFormat.format(lendRecordObj.get("lenddate")));
            }
        });
    }

    public void setWareHousingDateData(PackageDataEvent pkd, Object pkValue, Map<Object, DynamicObject> inStoreRecordMap, SimpleDateFormat simpleDateFormat) {
        DynamicObject inStoreRecordObj = inStoreRecordMap.get(pkValue);
        Optional.ofNullable(inStoreRecordObj).ifPresent(dynamicObject -> {
            if (inStoreRecordObj.get("storagedate") != null) {
                pkd.setFormatValue((Object)simpleDateFormat.format(inStoreRecordObj.get("storagedate")));
            }
        });
    }

    public void setForeignApplicationData(PackageDataEvent pkd, Object pkValue, Map<Object, Long> certAndApplyMap, Map<Long, String> applyFormTypeMap) {
        Long applyId = certAndApplyMap.get(pkValue);
        Optional.ofNullable(applyId).ifPresent(dynamicObject -> pkd.setFormatValue(applyFormTypeMap.get(applyId)));
    }

    public void showForeignApplicationForm(IFormView formView) {
        IListView listView = (IListView)formView;
        ListSelectedRow listSelectedRow = listView.getCurrentSelectedRowInfo();
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        DynamicObject[] certificateObjList = this.queryDynamicObjById("recentfaid", Collections.singletonList(primaryKeyValue), null);
        if (certificateObjList == null) {
            return;
        }
        BillShowParameter billShowParameter = FAApplicationService.getBillShowParameter(certificateObjList[0].getLong("recentfaid"));
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setPageId(formView.getPageId() + certificateObjList[0].getLong("recentfaid"));
        formView.showForm((FormShowParameter)billShowParameter);
    }

    public void updateOperationResult(OperationResult operationResult, Object[] primaryKeyValue) {
        DynamicObject[] certificateObjList;
        ArrayList<Long> selectIdList = new ArrayList<Long>(primaryKeyValue.length);
        for (Object id : primaryKeyValue) {
            selectIdList.add((Long)id);
        }
        LOG.info("CertificateMgDomainService.updateOperationResult operationResult : {} primaryKeyValue : {}", (Object)operationResult, (Object)primaryKeyValue.length);
        HashMap certNumberMap = Maps.newHashMapWithExpectedSize((int)8);
        for (DynamicObject certificateObj : certificateObjList = CERTIFICATEQUERYSERVICE.queryById("certinfo,filperson,concerttype", selectIdList)) {
            if (certificateObj.getDynamicObject("certinfo") != null && StringUtils.isNotEmpty((CharSequence)certificateObj.getString("certinfo.certnumber"))) {
                certNumberMap.put(certificateObj.getLong("id"), certificateObj.getString("certinfo.certnumber"));
                continue;
            }
            String preMsg = certificateObj.getString("filperson.person.name") + "-" + certificateObj.getString("concerttype.name");
            certNumberMap.put(certificateObj.getLong("id"), preMsg);
        }
        Optional.ofNullable(operationResult.getAllErrorOrValidateInfo()).ifPresent(errorValidate -> errorValidate.forEach(result -> {
            OperateInfo operateInfo = (OperateInfo)result;
            Object pkValue = operateInfo.getPkValue();
            LOG.info("CertificateMgDomainService.updateOperationResult pkValue : {}", pkValue);
            String numberStr = (String)certNumberMap.get(pkValue);
            if (numberStr != null) {
                operateInfo.setMessage(numberStr + ": " + operateInfo.getMessage());
            }
        }));
    }

    public void lockListField(BeforeCreateListColumnsArgs args) {
        IListColumn personNumber = args.getListColumn("filperson.person.number");
        personNumber.setFixed(true);
        IListColumn filingStatus = args.getListColumn("filperson.filingstatus");
        filingStatus.setFixed(true);
        IListColumn personName = args.getListColumn("filperson.person.name");
        personName.setFixed(true);
        IListColumn concertType = args.getListColumn("concerttype.name");
        concertType.setFixed(true);
    }

    public void buildParameter(FormShowParameter parameter, String pageKey, IListView listView, IFormPlugin formPlugin, List<Object> successPkIds) {
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("idList", successPkIds);
        parameter.setFormId(pageKey);
        parameter.setCloseCallBack(new CloseCallBack(formPlugin, "CALLBACK_REFRESH"));
        listView.showForm(parameter);
    }

    public void modifyRecPersonType(DynamicObject dynamicObject, IFormView view) {
        ILocaleString recPersonType = dynamicObject.getDynamicObject("filperson").getLocaleString("recpersontype.name");
        if (null != recPersonType) {
            if (recPersonType.getLocaleValue().equals(ResManager.loadKDString((String)"\u7279\u6b8a\u8eab\u4efd\u5907\u6848", (String)"CertificateMgDomainService_0", (String)"sihc-soefam-business", (Object[])new Object[0]))) {
                view.setVisible(Boolean.TRUE, new String[]{"specialfiling"});
                view.setVisible(Boolean.FALSE, new String[]{"cadrefiling"});
            } else if (recPersonType.getLocaleValue().equals(ResManager.loadKDString((String)"\u9886\u5bfc\u5e72\u90e8\u5907\u6848", (String)"CertificateMgDomainService_1", (String)"sihc-soefam-business", (Object[])new Object[0]))) {
                view.setVisible(Boolean.FALSE, new String[]{"specialfiling"});
                view.setVisible(Boolean.TRUE, new String[]{"cadrefiling"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"specialfiling"});
            view.setVisible(Boolean.FALSE, new String[]{"cadrefiling"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OCRIdentify(PropertyChangedArgs args, IFormView view) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object imgPath = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"faceimage", (CharSequence)name) && null != view.getModel().getValue("faceimage") && !"true".equals(view.getPageCache().get("noChange"))) {
            Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"checkCVPLicense", (Object[])new Object[0]);
            if (result.booleanValue()) {
                view.showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bc1\u7167\u5185\u5bb9\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CertificateSerPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0])));
                try {
                    JSONObject jsonObject = CERTIFICATE_APPLICATION_SERVICE.getCertificateInfoByOCR("soefam_certificate", String.valueOf(imgPath));
                    if (jsonObject == null) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u5361\u8bc1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u3002", (String)"CertificateSerPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    }
                    String term = jsonObject.getString("term");
                    String[] split = term.split("-");
                    view.getModel().setValue("certnumberreg", (Object)jsonObject.getString("number"));
                    if (2 == split.length) {
                        view.getModel().setValue("signdatereg", (Object)HRDateTimeUtils.parseDate((String)split[0], (String)"yyyy.MM.dd"));
                        view.getModel().setValue("pervaldatereg", (Object)HRDateTimeUtils.parseDate((String)split[1], (String)"yyyy.MM.dd"));
                    }
                    view.getModel().setValue("signorgreg", (Object)jsonObject.getString("signorg"));
                    view.getModel().setValue("signplacereg", (Object)jsonObject.getString("signplace"));
                }
                catch (Exception exception) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u5361\u8bc1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u3002", (String)"CertificateSerPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    LOG.error("CertificateMgDomainService.OCRIdentify error ", (Throwable)exception);
                }
                finally {
                    view.hideLoading();
                }
            }
        } else if (StringUtils.equals((CharSequence)"pervaldatereg", (CharSequence)name)) {
            Object perValDate = view.getModel().getDataEntity().get("pervaldatereg");
            if (!ObjectUtils.isEmpty((Object)perValDate)) {
                String perVal;
                String currentDate = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                if (currentDate.compareTo(perVal = HRDateTimeUtils.format((Date)view.getModel().getDataEntity().getDate("pervaldatereg"), (String)"yyyy-MM-dd")) >= 1) {
                    view.getModel().setValue("effectivestatus", (Object)"0");
                } else {
                    view.getModel().setValue("effectivestatus", (Object)"1");
                }
            } else {
                view.getModel().setValue("effectivestatus", (Object)"");
            }
        }
    }

    static {
        HELPER_MAP.put("soefam_certinreg", CERTIFICATEINREGDOMAINSERVICE);
        HELPER_MAP.put("soefam_certlentoutreg", CERTLENTOUTREGHELPER);
        HELPER_MAP.put("soefam_certreturnreg", CERTRETURNREGHELPER);
        HELPER_MAP.put("soefam_certoutreg", CERT_OUT_REG_HELPER);
    }
}

