/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.certificate;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertificateReturnDomainService {
    private static final CertreturnregHelper CERTRETURNREGHELPER = CertreturnregHelper.init();
    private static final LicenseService LICENSE_SERVICE = ServiceFactory.getService(LicenseService.class);

    public DynamicObject[] getFaidsByCertId(Long pkValue) {
        QFilter certIdQFilter = new QFilter("certificate", "=", (Object)pkValue);
        QFilter stateQFilter = new QFilter("registerstate", "=", (Object)"0");
        certIdQFilter.and(stateQFilter);
        return CERTRETURNREGHELPER.query("faid", certIdQFilter.toArray());
    }

    public Map<Long, DynamicObject> getnewFaidsByCertId(List<Long> idList) {
        QFilter certidQFilter = new QFilter("certificate", "in", idList);
        QFilter stateQFilter = new QFilter("registerstate", "=", (Object)"0");
        certidQFilter.and(stateQFilter);
        DynamicObject[] query = CERTRETURNREGHELPER.query("faid,certificate", certidQFilter.toArray(), " modifytime desc");
        return Arrays.stream(query).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id"), Function.identity(), (v1, v2) -> v1));
    }

    public void updateCertreturn(DynamicObjectCollection entryEntity, List<DynamicObject> updateCertObjectList, List<Long> certificateIds, List<Long> faids) {
        this.setHistoryOld(certificateIds);
        QFilter faidQFilter = new QFilter("faid", "in", faids);
        QFilter certNumberQFilter = new QFilter("certificate", "in", certificateIds);
        faidQFilter.and(certNumberQFilter);
        List<String> propList = Arrays.asList("certificate", "faid", "registerstate", "returndate", "remark", "modifytime", "modifier", "latestrecord", "goabroad");
        String properties = String.join((CharSequence)",", propList);
        DynamicObject[] dynamicObjects = CERTRETURNREGHELPER.query(properties, faidQFilter.toArray());
        Map loanObjMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id") + "_" + dynamicObject.getLong("faid"), Function.identity(), (v1, v2) -> v1));
        for (DynamicObject object : entryEntity) {
            DynamicObject dynamicObject2 = (DynamicObject)loanObjMap.get(object.getLong("certificateentity.id") + "_" + object.getLong("faid"));
            dynamicObject2.set("returndate", object.get("returndate"));
            dynamicObject2.set("remark", object.get("remark"));
            dynamicObject2.set("goabroad", object.get("goabroad"));
            dynamicObject2.set("registerstate", (Object)"1");
            dynamicObject2.set("latestrecord", (Object)"1");
            dynamicObject2.set("modifytime", (Object)new Date());
            dynamicObject2.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            this.buildUpdateData(updateCertObjectList, object);
        }
        CERTRETURNREGHELPER.update(dynamicObjects);
    }

    public void setHistoryOld(List<Long> certificateIds) {
        QFilter certNumQFilter = new QFilter("certificate", "in", certificateIds);
        QFilter latestrecordQFilter = new QFilter("latestrecord", "=", (Object)"1");
        certNumQFilter.and(latestrecordQFilter);
        DynamicObject[] certList = CERTRETURNREGHELPER.query("latestrecord", certNumQFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
            CERTRETURNREGHELPER.update(certList);
        }
    }

    private void buildUpdateData(List<DynamicObject> dynamicObjectList, DynamicObject dyObj) {
        DynamicObject certificateObj = dyObj.getDynamicObject("certificateentity");
        certificateObj.set("certinfo", dyObj.getDynamicObject("certificateentity").get("certinfo"));
        dynamicObjectList.add(certificateObj);
    }

    public void checkEffectLicense(IFormView view, BeforeClickEvent evt) {
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        List<Long> personIdList = entity.stream().map(obj -> obj.getLong("certificateentity.person.id")).distinct().collect(Collectors.toList());
        boolean validateSecurity = LICENSE_SERVICE.isValidateSecurity(view, personIdList, "soefam_certificate", ResManager.loadKDString((String)"\u5f52\u8fd8\u767b\u8bb0", (String)"CertificateReturnDomainService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
        if (!validateSecurity) {
            evt.setCancel(true);
        }
    }
}

