/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.faapply;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.domain.faapply.FaapplicationHelper;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.faapply.FaApplyConstants;

public class FaApplyDomainService
implements FaApplyConstants {
    public static final HRBaseServiceHelper APPLICATION_HELPER = new HRBaseServiceHelper("soefam_faapplication");
    public static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final FaapplicationHelper FAAPPLICATION_HELPER = FaapplicationHelper.init();

    public DynamicObject[] queryDynamicObjById(String selectProperties, List<Long> idList, QFilter qFilter) {
        if (qFilter != null) {
            qFilter.and(new QFilter("id", "in", idList));
        } else {
            qFilter = new QFilter("id", "in", idList);
        }
        return APPLICATION_HELPER.query(selectProperties, qFilter.toArray());
    }

    public DynamicObject getApplyformtype(Object primaryKeyValue) {
        QFilter certificate = new QFilter("id", "=", primaryKeyValue);
        return FAAPPLICATION_HELPER.queryOne("applyformtype", certificate.toArray());
    }

    public Map<Long, DynamicObject> getApplyformtypes(List<Long> faids) {
        String selectFields = "id,applyformtype,person.name,certrecmethod,recipient,subrecipient";
        QFilter certificate = new QFilter("id", "in", faids);
        DynamicObject[] query = FAAPPLICATION_HELPER.query(selectFields, certificate.toArray());
        return Arrays.stream(query).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), Function.identity(), (v1, v2) -> v1));
    }

    public String applyFormTypeToString(Object applyFormType) {
        String recentFaIdName = null;
        if ("A".equals(applyFormType)) {
            recentFaIdName = ResManager.loadKDString((String)"\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"FaApplyDomainService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
        } else if ("B".equals(applyFormType)) {
            recentFaIdName = ResManager.loadKDString((String)"\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"FaApplyDomainService_1", (String)"sihc-soefam-business", (Object[])new Object[0]);
        } else if ("C".equals(applyFormType)) {
            recentFaIdName = ResManager.loadKDString((String)"\u56e0\u516c\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"FaApplyDomainService_2", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        return recentFaIdName;
    }

    public String applyFormTypeToString(DynamicObject applyBo) {
        String receiverName = null;
        String applyFormType = applyBo.getString("applyformtype");
        String certRecMethod = applyBo.getString("certrecmethod");
        if (applyFormType.equals("A") || applyFormType.equals("B")) {
            if (certRecMethod.equals("0")) {
                receiverName = applyBo.getString("person.name");
            } else if (certRecMethod.equals("1")) {
                receiverName = applyBo.getString("recipient");
            } else if (certRecMethod.equals("2")) {
                receiverName = applyBo.getString("subrecipient");
            }
        }
        return receiverName;
    }
}

