/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.filingspersonmg;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.application.external.SihcIHRPIPersonService;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class FilPersonMgDomainService
extends HRBaseServiceHelper {
    static FilPersonMgDomainService filPersonMgService;
    public static final Map<String, String> FORE_COLOR_MAP;
    public static final Map<String, String> BACKGROUND_COLOR_MAP;
    public static final Map<String, String> BORDER_COLOR_MAP;
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE;
    private static final Log LOG;
    private static final SihcIHRPIPersonService SIHCIHRPIPERSONSERVICE;

    private FilPersonMgDomainService(String entityName) {
        super(entityName);
    }

    public static synchronized FilPersonMgDomainService init() {
        filPersonMgService = new FilPersonMgDomainService("soefam_filpermanage");
        return filPersonMgService;
    }

    public DynamicObject getFilPersonByPerson(Long personId) {
        QFilter filter = new QFilter("person", "=", (Object)personId);
        filter.and(new QFilter("effstatus", "=", (Object)"1"));
        return filPersonMgService.loadDynamicObject(filter);
    }

    public DynamicObject[] getFilPersonByPersons(List<Long> personId) {
        QFilter filter = new QFilter("person", "in", personId);
        filter.and(new QFilter("effstatus", "=", (Object)"1"));
        return filPersonMgService.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] getFilPersonByNameAndNumber(List<Object> personNumber, List<Object> personName) {
        QFilter filter = new QFilter("person.number", "in", personNumber);
        filter.and(new QFilter("person.name", "in", personName));
        filter.and(new QFilter("effstatus", "=", (Object)"1"));
        return filPersonMgService.loadDynamicObjectArray(filter.toArray());
    }

    public void updateFilPersonEmpPosOrgRel(Long personId, Long employeeId) {
        LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.personId:{},employeeId:{}", (Object)personId, (Object)employeeId);
        Map primaryEmpposorgrel = SIHCIHRPIPERSONSERVICE.getPrimaryEmpposorgrel(personId);
        LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.primaryEmpposorgrel:{}", (Object)primaryEmpposorgrel);
        QFilter filter = new QFilter("person", "=", (Object)personId);
        filter.and(new QFilter("effstatus", "!=", (Object)"0"));
        DynamicObject filPerson = filPersonMgService.loadDynamicObject(filter);
        filPerson.set("empposorgrel", primaryEmpposorgrel.get("id"));
        LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.primaryEmpposorgrelId:{}", primaryEmpposorgrel.get("id"));
        filPerson.set("admorg", primaryEmpposorgrel.get("adminorg_id"));
        LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.adminOrg:{}", primaryEmpposorgrel.get("adminorg_id"));
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
        paramMap.put((Long)primaryEmpposorgrel.get("adminorg_id"), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
        List<Map<String, Long>> resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, HRCSRpcConstants.BIZ_OBJ_TYPE);
        LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.resultList:{}", resultList);
        for (Map<String, Long> result : resultList) {
            Long hrAdminOrgId = result.get("adminOrgId");
            if (!hrAdminOrgId.equals(primaryEmpposorgrel.get("adminorg_id"))) continue;
            Long hrBuId = result.get("hrBuId");
            filPerson.set("org", (Object)hrBuId);
            LOG.info("FilPersonService.updateFilPersonEmpPosOrgRel.hrBuId:{}", (Object)hrBuId);
        }
        filPersonMgService.updateOne(filPerson);
        CERTIFICATE_APPLICATION_SERVICE.updateCertOrg(filPerson);
    }

    public void setInfoPageTitle(PreOpenFormEventArgs args) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)args.getFormShowParameter();
        DynamicObject personMgObj = this.queryOne("person", Long.parseLong(baseShowParameter.getPkId().toString()));
        String titleName = ResManager.loadKDString((String)"\u5907\u6848\u4eba\u5458-{0}", (String)"FilPersonMgDomainService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
        titleName = MessageFormat.format(titleName, personMgObj.getString("person.name"));
        args.getFormShowParameter().setCaption(titleName);
    }

    public void getGradeRankInfo(List<Object> pkIdList, Map<Object, DynamicObject> gradeRankMap) {
        DynamicObject[] personMgList = this.query("employee", new QFilter("id", "in", pkIdList).toArray());
        List<Object> employeeIdList = Arrays.stream(personMgList).map(dynamicObject -> dynamicObject.get("employee.id")).collect(Collectors.toList());
        DynamicObject[] empJobRelList = HrpiQueryServiceHelper.getEmpjobrelByEmployeeId(employeeIdList, "employee,joblevel,jobgrade");
        HashMap<Long, DynamicObject> empJobMap = new HashMap<Long, DynamicObject>(empJobRelList.length);
        for (DynamicObject dynamicObject2 : empJobRelList) {
            empJobMap.put(dynamicObject2.getLong("employee.id"), dynamicObject2);
        }
        for (DynamicObject dynamicObject2 : personMgList) {
            gradeRankMap.put(dynamicObject2.getPkValue(), (DynamicObject)empJobMap.get(dynamicObject2.getLong("employee.id")));
        }
    }

    public DynamicObject[] getApprovedData(Object personId, List<Long> manageOrgInfo) {
        QFilter qFilter = new QFilter("person", "=", personId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        List<String> filingStatusList = Arrays.asList("A", "B", "C", "D");
        qFilter.and(new QFilter("filingstatus", "in", filingStatusList));
        qFilter.and(new QFilter("manageorg.fbasedataid", "in", manageOrgInfo));
        List<String> propList = Arrays.asList("regdate", "secregdate", "empposorgrel", "effstatus", "person", "recpersontype", "secregexp", "filingstatus", "iregscopedate", "oregscopedate", "regexp", "company", "depemp", "position", "stdposition", "job");
        String properties = String.join((CharSequence)",", propList);
        return this.query(properties, qFilter.toArray(), "iregscopedate desc");
    }

    public Map<String, Object> getLabelStyle(String effStatus) {
        return this.generateMap(FORE_COLOR_MAP.get(effStatus), BACKGROUND_COLOR_MAP.get(effStatus), BORDER_COLOR_MAP.get(effStatus));
    }

    public Map<String, Object> generateMap(String colorByStatus, String backgroundStatus, String borderStatus) {
        HashMap<String, Object> ctrl = new HashMap<String, Object>(8);
        ctrl.put("fc", colorByStatus);
        ctrl.put("bc", backgroundStatus);
        HashMap borderMap = new HashMap(8);
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("t", borderStatus);
        map.put("r", borderStatus);
        map.put("l", borderStatus);
        map.put("b", borderStatus);
        borderMap.put("b", map);
        ctrl.put("s", borderMap);
        return ctrl;
    }

    public DynamicObject[] getNotEffectFilPerByPersonNumber(List<Object> personNumber) {
        QFilter filter = new QFilter("person.number", "in", personNumber);
        filter.and(new QFilter("effstatus", "!=", (Object)"0"));
        return filPersonMgService.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getFilPerByBatchNumber(Long batchNumber) {
        QFilter filter = new QFilter("initbatch", "=", (Object)batchNumber);
        filter.and(new QFilter("effstatus", "=", (Object)"1"));
        return filPersonMgService.loadDynamicObjectArray(filter.toArray());
    }

    public void updateFilPerManageOrg(Long manageOrgId) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("1", "=", (Object)1);
        for (DynamicObject dynObj : dynamicObjects = filPersonMgService.loadDynamicObjectArray(filter.toArray())) {
            DynamicObjectCollection dynObjColl = dynObj.getDynamicObjectCollection("manageorg");
            ArrayList<Long> manageOrgIds = new ArrayList<Long>(2);
            manageOrgIds.add(manageOrgId);
            for (DynamicObject manageDyn : dynObjColl) {
                manageOrgIds.add(manageDyn.getLong("fbasedataid.id"));
            }
            dynObjColl.clear();
            for (int num = 0; num < manageOrgIds.size(); ++num) {
                dynObjColl.addNew();
                ((DynamicObject)dynObjColl.get(num)).set("fbasedataid", manageOrgIds.get(num));
            }
        }
        filPersonMgService.update(dynamicObjects);
    }

    public void updateFilPerState(List<Long> manageOrgId) {
        QFilter filter = new QFilter("primanageorg", "in", manageOrgId);
        DynamicObject[] dynamicObjects = filPersonMgService.loadDynamicObjectArray(filter.toArray());
        ArrayList<Long> delDynObj = new ArrayList<Long>(dynamicObjects.length);
        ArrayList<DynamicObject> updateDynObj = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynObj : dynamicObjects) {
            String state = dynObj.getString("effstatus");
            if ("".equals(state)) {
                delDynObj.add(dynObj.getLong("id"));
                continue;
            }
            if (!"1".equals(state)) continue;
            dynObj.set("listtype", (Object)"2");
            updateDynObj.add(dynObj);
        }
        filPersonMgService.delete(delDynObj.toArray());
        filPersonMgService.update(updateDynObj.toArray(new DynamicObject[0]));
    }

    static {
        FORE_COLOR_MAP = new HashMap<String, String>(8);
        BACKGROUND_COLOR_MAP = new HashMap<String, String>(8);
        BORDER_COLOR_MAP = new HashMap<String, String>(8);
        FORE_COLOR_MAP.put("1", "#1BA854");
        BACKGROUND_COLOR_MAP.put("1", "#F2FFF5");
        BORDER_COLOR_MAP.put("1", "1px_solid_#6DD18E");
        FORE_COLOR_MAP.put("0", "#999999");
        BACKGROUND_COLOR_MAP.put("0", "#FAFAFA");
        BORDER_COLOR_MAP.put("0", "1px_solid_#D9D9D9");
        CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);
        LOG = LogFactory.getLog(FilPersonMgDomainService.class);
        SIHCIHRPIPERSONSERVICE = ServiceFactory.getService(SihcIHRPIPersonService.class);
    }
}

