/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.ConCertTypeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class FilPerCertInitDataService
extends AbstractInitDomainDataService {
    private static final Log LOGGER = LogFactory.getLog(FilPerCertInitDataService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);
    private static final CertificateDomainService DOMAIN_SERVICE = ServiceFactory.getService(CertificateDomainService.class);

    public void validate() {
        Map info = this.getInfoWithMap();
        List data = (List)info.get("data");
        this.doValidate(data);
    }

    public void doValidate(List<Map<String, Object>> data) {
        List<Object> personNumber = data.stream().map(map -> map.get("personnumber")).collect(Collectors.toList());
        List<Object> personName = data.stream().map(map -> map.get("personname")).collect(Collectors.toList());
        DynamicObject[] filPersons = FILPERSONMG_APPLICATION_SERVICE.getFilPersonByNameAndNumber(personNumber, personName);
        DynamicObject[] certIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByPersonNumber(personNumber);
        DynamicObject[] effectCertIfiCates = CERTIFICATE_QUERY_SERVICE.getEffectCertIfiCateByPersonNumber(personNumber);
        DynamicObject[] enableConCertTypes = ConCertTypeQueryService.getEnableConCertTypes();
        for (Map<String, Object> map2 : data) {
            this.mapValicate(filPersons, certIfiCates, effectCertIfiCates, enableConCertTypes, map2);
        }
    }

    public void mapValicate(DynamicObject[] filPersons, DynamicObject[] certIfiCates, DynamicObject[] effectCertIfiCates, DynamicObject[] enableConCertTypes, Map<String, Object> map) {
        Date nowDate;
        Date storageDate;
        DynamicObject effectCertIfiCateExist;
        Object certNumber;
        Object conCertType;
        DynamicObject certIfiCateExist;
        String number = map.get("personnumber").toString();
        String name = map.get("personname").toString();
        String msg = "";
        DynamicObject filPersonExist = this.isFilPersonExist(filPersons, number, name);
        if (filPersonExist == null) {
            msg = msg + ResManager.loadKDString((String)"\u65e0\u5df2\u751f\u6548\u7684\u5907\u6848\u4eba\u5458\u3002", (String)"FilPerCertInitDataService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        Object signData = map.get("signdate");
        Object perValDate = map.get("pervaldate");
        if (signData != null && perValDate != null && ((Date)signData).after((Date)perValDate)) {
            msg = msg + ResManager.loadKDString((String)"\u7b7e\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u6709\u6548\u671f\u81f3\u65e5\u671f\u3002", (String)"FilPerCertInitDataService_1", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        if ((certIfiCateExist = this.isCertIfiCateExist(certIfiCates, number, name, conCertType = map.get("concerttype"), certNumber = map.get("certnumber"))) != null) {
            msg = msg + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u76f8\u540c\u8bc1\u7167\u53f7\u7801\u201c%2$s\u201d\u3002", (String)"FilPerCertInitDataService_2", (String)"sihc-soebs-business", (Object[])new Object[0]), certIfiCateExist.getString("concerttype.name"), certNumber);
        }
        if ((effectCertIfiCateExist = this.isEffectCertIfiCateExist(effectCertIfiCates, number, name, conCertType)) != null) {
            msg = msg + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b58\u5728\u751f\u6548\u4e2d\u7684\u201c%s\u201d\u3002", (String)"FilPerCertInitDataService_4", (String)"sihc-soebs-business", (Object[])new Object[0]), conCertType);
        }
        boolean conCertTypeIsEnable = false;
        for (DynamicObject enableConCertType : enableConCertTypes) {
            String conCertTypeName = enableConCertType.getString("name");
            if (!conCertTypeName.equals(conCertType)) continue;
            conCertTypeIsEnable = true;
        }
        if (!conCertTypeIsEnable) {
            msg = msg + String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ba1\u63a7\u8bc1\u7167\u7c7b\u578b\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"FilPerCertInitDataService_6", (String)"sihc-soebs-business", (Object[])new Object[0]), conCertType);
        }
        if (filPersonExist != null) {
            DynamicObject empposorgrel = filPersonExist.getDynamicObject("empposorgrel");
            String businessStatus = empposorgrel.getString("businessstatus");
            String dataStatus = empposorgrel.getString("datastatus");
            if (!"1".equals(businessStatus) || !"1".equals(dataStatus)) {
                msg = msg + ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u751f\u6548\u4e2d\u7684\u4efb\u804c\u7ecf\u5386\u3002", (String)"FilPerInitDataService_5", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        }
        if ((storageDate = (Date)map.get("storagedate")).after(nowDate = this.getNowDate())) {
            msg = msg + ResManager.loadKDString((String)"\u5165\u5e93\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"FilPerInitDataService_8", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        if ("".equals(msg)) {
            this.getInitOutParam().addSuccessMsg((Long)map.get("id"), "", "");
        } else {
            this.getInitOutParam().addErrorMsg((Long)map.get("id"), msg.substring(0, msg.length() - 1) + "\u3002");
        }
    }

    public void save() {
        this.validate();
        Map info = this.getInfoWithMap();
        List data = (List)info.get("data");
        this.doSave(data);
    }

    public void doSave(List<Map<String, Object>> data) {
        List<Object> personNumber = data.stream().map(map -> map.get("personnumber")).collect(Collectors.toList());
        List<Object> personName = data.stream().map(map -> map.get("personname")).collect(Collectors.toList());
        DynamicObject[] filPersons = FILPERSONMG_APPLICATION_SERVICE.getFilPersonByNameAndNumber(personNumber, personName);
        List<Long> personIds = Arrays.stream(filPersons).map(filPerson -> filPerson.getLong("person.id")).collect(Collectors.toList());
        DynamicObject[] certIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByPersonIds(personIds);
        ArrayList<DynamicObject> certIfiCateList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> certInfoList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> certInRegList = new ArrayList<DynamicObject>(10);
        for (Map<String, Object> map2 : data) {
            this.mapSave(certIfiCates, certIfiCateList, certInfoList, certInRegList, map2);
        }
        this.saveAllCertObj(certIfiCateList, certInfoList, certInRegList);
    }

    public void saveAllCertObj(List<DynamicObject> certIfiCateList, List<DynamicObject> certInfoList, List<DynamicObject> certInRegList) {
        if (certIfiCateList.size() > 0) {
            this.setInitDefalutValue(certIfiCateList);
        }
        if (certInfoList.size() > 0) {
            this.setInitDefalutValue(certInfoList);
        }
        DOMAIN_SERVICE.updateCertIfiCate(certIfiCateList.toArray(new DynamicObject[0]));
        DOMAIN_SERVICE.saveOnlyCertInfo(certInfoList.toArray(new DynamicObject[0]));
        DOMAIN_SERVICE.saveCerInReg(certInRegList.toArray(new DynamicObject[0]));
    }

    public void mapSave(DynamicObject[] certIfiCates, List<DynamicObject> certIfiCateList, List<DynamicObject> certInfoList, List<DynamicObject> certInRegList, Map<String, Object> map) {
        Map initOutMessageMap = this.getInitOutParam().getData();
        InitOutMessage initOutMessage = (InitOutMessage)initOutMessageMap.get(map.get("id"));
        if (!initOutMessage.getSuccess().booleanValue()) {
            return;
        }
        this.doMapSave(certIfiCates, certIfiCateList, certInfoList, certInRegList, map);
    }

    public void doMapSave(DynamicObject[] certIfiCates, List<DynamicObject> certIfiCateList, List<DynamicObject> certInfoList, List<DynamicObject> certInRegList, Map<String, Object> map) {
        String number = map.get("personnumber").toString();
        String conCertType = map.get("concerttype").toString();
        long[] certInfoIds = ORM.create().genLongIds("soefam_certinfo", certIfiCates.length);
        int idIndex = 0;
        for (DynamicObject certIfiCate : certIfiCates) {
            String filPersonNumber = certIfiCate.getString("filperson.person.number");
            String conCertTypeName = certIfiCate.getString("concerttype.name");
            if (!number.equals(filPersonNumber) || !conCertType.equals(conCertTypeName)) continue;
            DynamicObject certInfo = DOMAIN_SERVICE.generateCertInfo();
            long certInfoId = certInfoIds[idIndex];
            certInfo.set("id", (Object)certInfoId);
            ++idIndex;
            DynamicObject certInReg = DOMAIN_SERVICE.generateCertInReg();
            certIfiCate.set("stockstatus", (Object)"B");
            certIfiCate.set("storageplace", map.get("storageplace"));
            certIfiCate.set("onfilenum", map.get("onfilenum"));
            certIfiCate.set("certinfo", (Object)certInfo);
            certIfiCate.set("managestatus", (Object)"A");
            certIfiCate.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            certIfiCate.set("createtime", (Object)new Date());
            certIfiCate.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            certIfiCate.set("modifytime", (Object)new Date());
            certInfo.set("enable", (Object)"1");
            certInfo.set("status", (Object)"C");
            certInfo.set("certnumber", map.get("certnumber"));
            certInfo.set("signdate", map.get("signdate"));
            Object perValDate = map.get("pervaldate");
            certInfo.set("pervaldate", perValDate);
            certInfo.set("signorg", map.get("signorg"));
            certInfo.set("signplace", map.get("signplace"));
            certInfo.set("remarks", map.get("remarks"));
            certInfo.set("certificate", (Object)certIfiCate.getLong("id"));
            if (perValDate != null) {
                Date nowDate = this.getNowDate();
                if (((Date)perValDate).before(nowDate)) {
                    certInfo.set("effectivestatus", (Object)"0");
                } else {
                    certInfo.set("effectivestatus", (Object)"1");
                }
            }
            certInfo.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            certInfo.set("createtime", (Object)new Date());
            certInfo.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            certInfo.set("modifytime", (Object)new Date());
            certInfo.set("org", (Object)certIfiCate.getDynamicObject("org"));
            certInReg.set("storagedate", map.get("storagedate"));
            certInReg.set("certificate", (Object)certIfiCate.getLong("id"));
            certInReg.set("storagelocation", map.get("storageplace"));
            certInReg.set("remark", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8bc1\u7167\u4fe1\u606f\u521b\u5efa", (String)"FilPerCertInitDataService_5", (String)"sihc-soefam-business", (Object[])new Object[0]));
            certInReg.set("certinfo", (Object)certInfoId);
            certInReg.set("latestrecord", (Object)"1");
            certInReg.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            certInReg.set("createtime", (Object)new Date());
            certInReg.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            certInReg.set("modifytime", (Object)new Date());
            certIfiCateList.add(certIfiCate);
            certInfoList.add(certInfo);
            certInRegList.add(certInReg);
        }
    }

    public void changeSuccessStatus() {
        super.changeSuccessStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "2");
    }

    public void changeProcessingStatus() {
        super.changeProcessingStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "0");
    }

    public void changeValidatedStatus() {
        super.changeValidatedStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "1");
    }

    public void rollback() {
        Long batchNumber = this.getInitInParam().getBatchNumber();
        DynamicObject[] certIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByBatchNumber(batchNumber);
        super.rollback();
        this.doRollback(batchNumber, certIfiCates);
    }

    public void doRollback(Long batchNumber, DynamicObject[] certIfiCates) {
        DynamicObject[] newCertIfiCates;
        DOMAIN_SERVICE.deleteCertInfoByBatchNumber(batchNumber);
        List<Long> certIfiCateIds = Arrays.stream(certIfiCates).map(certIfiCate -> certIfiCate.getLong("id")).collect(Collectors.toList());
        DOMAIN_SERVICE.deleteCertInRegByCertIfiCateIds(certIfiCateIds);
        List<DynamicObject> filPersons = Arrays.stream(certIfiCates).map(certIfiCate -> certIfiCate.getDynamicObject("filperson")).distinct().collect(Collectors.toList());
        CERTIFICATE_APPLICATION_SERVICE.initCertificate("enable", filPersons.toArray(new DynamicObject[0]));
        List<Long> personIds = Arrays.stream(certIfiCates).map(certIfiCate -> certIfiCate.getLong("person.id")).collect(Collectors.toList());
        for (DynamicObject newCertIfiCate : newCertIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByPersonIds(personIds)) {
            newCertIfiCate.set("initdatasource", (Object)newCertIfiCate.getString("filperson.initdatasource"));
            newCertIfiCate.set("initstatus", (Object)newCertIfiCate.getString("filperson.initstatus"));
            newCertIfiCate.set("initbatch", (Object)newCertIfiCate.getLong("filperson.initbatch"));
        }
        DOMAIN_SERVICE.updateCertIfiCate(newCertIfiCates);
    }

    public DynamicObject isFilPersonExist(DynamicObject[] filPersons, String number, String name) {
        for (DynamicObject filPerson : filPersons) {
            String personNumber = filPerson.getString("person.number");
            String personName = filPerson.getString("person.name");
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            return filPerson;
        }
        return null;
    }

    public DynamicObject isCertIfiCateExist(DynamicObject[] certIfiCates, String number, String name, Object conCertType, Object certNumber) {
        for (DynamicObject certIfiCate : certIfiCates) {
            String personNumber = certIfiCate.getString("filperson.person.number");
            String personName = certIfiCate.getString("filperson.person.name");
            String conCertTypeName = certIfiCate.getString("concerttype.name");
            String certIfiCateNumber = certIfiCate.getString("certinfo.certnumber");
            if (!personNumber.equals(number) || !personName.equals(name) || !conCertTypeName.equals(conCertType) || !certNumber.equals(certIfiCateNumber)) continue;
            return certIfiCate;
        }
        return null;
    }

    public DynamicObject isEffectCertIfiCateExist(DynamicObject[] effectCertIfiCates, String number, String name, Object conCertType) {
        for (DynamicObject effectCertIfiCate : effectCertIfiCates) {
            String personNumber = effectCertIfiCate.getString("filperson.person.number");
            String personName = effectCertIfiCate.getString("filperson.person.name");
            String conCertTypeName = effectCertIfiCate.getString("concerttype.name");
            if (!personNumber.equals(number) || !personName.equals(name) || !conCertTypeName.equals(conCertType)) continue;
            return effectCertIfiCate;
        }
        return null;
    }

    public void doUpdateStatus(Long batchNumber, String initStatus) {
        DynamicObject[] certInfos;
        for (DynamicObject certInfo : certInfos = CERTIFICATE_QUERY_SERVICE.getCertInfoByBatchNumber(batchNumber)) {
            certInfo.set("initstatus", (Object)initStatus);
        }
        DOMAIN_SERVICE.updateCertInfo(certInfos);
    }

    public Date getNowDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

