/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;
import kd.sihc.soebs.common.constants.dto.response.cert.CertResDTO;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.application.service.filingsperson.FilPerScopeApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.business.queryservice.RecPersonTypeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class FilPerInitDataService
extends AbstractInitDomainDataService
implements ManageOrgConstants {
    private static final Log LOGGER = LogFactory.getLog(FilPerInitDataService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final CertificateDomainService DOMAIN_SERVICE = ServiceFactory.getService(CertificateDomainService.class);
    private static final ManageOrgRangeQueryService MANAGE_ORG_QUERY_SERVICE = ServiceFactory.getService(ManageOrgRangeQueryService.class);
    private static final LicenseService LICENSE_SERVICE = ServiceFactory.getService(LicenseService.class);

    public void validate() {
        Map info = this.getInfoWithMap();
        List data = (List)info.get("data");
        CertResDTO<String> responseDto = LICENSE_SERVICE.checkLicenseNum("soefam_filperlist");
        if (!responseDto.getSuccess().booleanValue()) {
            data.forEach(map -> this.getInitOutParam().addErrorMsg(Long.valueOf(Long.parseLong(map.get("id").toString())), responseDto.getMessage()));
            return;
        }
        this.doValidate(data);
    }

    public void doValidate(List<Map<String, Object>> data) {
        List<Object> personNumber = data.stream().map(map -> map.get("personnumber")).collect(Collectors.toList());
        List<Object> personName = data.stream().map(map -> map.get("personname")).collect(Collectors.toList());
        List<Object> manageOrgNameList = data.stream().map(map -> map.get("manageorg")).collect(Collectors.toList());
        DynamicObject[] personInfo = HrpiQueryServiceHelper.getPersonInfoByNameAndNumber(personNumber, personName);
        List<Long> personIds = Arrays.stream(personInfo).map(person -> person.getLong("id")).collect(Collectors.toList());
        Map<Long, Long> employeeInfo = HrpiQueryServiceHelper.getEmployeeInfoByPerson(personIds);
        LOGGER.info("FilPerInitDataService.validate.employeeInfo:{}", employeeInfo);
        List<Long> employeeIds = Arrays.asList(employeeInfo.values().toArray(new Long[0]));
        DynamicObject[] manageOrgArray = MANAGE_ORG_QUERY_SERVICE.getManageOrgNameInfos("1", manageOrgNameList);
        DynamicObject[] empposorgrels = FilPerScopeApplicationService.getEmpposorgrelByEmployeeIds(employeeIds);
        DynamicObject[] notEffectFilPers = FILPERSONMG_APPLICATION_SERVICE.getNotEffectFilPerByPersonNumber(personNumber);
        for (Map<String, Object> map2 : data) {
            this.mapValidate(data, personInfo, employeeInfo, empposorgrels, notEffectFilPers, manageOrgArray, map2);
        }
    }

    public void mapValidate(List<Map<String, Object>> data, DynamicObject[] personInfo, Map<Long, Long> employeeInfo, DynamicObject[] empposorgrels, DynamicObject[] notEffectFilPers, DynamicObject[] manageOrgArray, Map<String, Object> map) {
        boolean manageOrgExist;
        boolean empposorgrelExist;
        String number = map.get("personnumber").toString();
        String name = map.get("personname").toString();
        String manageOrgName = map.get("manageorg").toString();
        String msg = "";
        DynamicObject personExist = this.isPersonExist(personInfo, number, name);
        if (personExist == null) {
            msg = msg + ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"FilPerInitDataService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
        } else {
            Long employeeId = employeeInfo.get(personExist.getLong("id"));
            if (employeeId == null) {
                msg = msg + ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u3002", (String)"FilPerInitDataService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        }
        boolean notEffectFilPerExist = this.isNotEffectFilPerExist(notEffectFilPers, data, number, name);
        if (notEffectFilPerExist) {
            msg = msg + ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5df2\u751f\u6548\u7684\u5907\u6848\u4eba\u5458\u3002", (String)"FilPerInitDataService_1", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        Object effStatus = map.get("effstatus");
        Object iRegScopeDate = map.get("iregscopedate");
        if ("1".equals(effStatus)) {
            if (iRegScopeDate == null) {
                msg = msg + ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8fdb\u5165\u5907\u6848\u4eba\u5458\u65e5\u671f\u3002", (String)"FilPerInitDataService_6", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        } else if (iRegScopeDate != null) {
            msg = msg + ResManager.loadKDString((String)"\u8fdb\u5165\u5907\u6848\u4eba\u5458\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"FilPerInitDataService_7", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        Object filingStatus = map.get("filingstatus");
        if ("1".equals(effStatus)) {
            if (!"A".equals(filingStatus) && !"B".equals(filingStatus)) {
                msg = msg + ResManager.loadKDString((String)"\u5907\u6848\u72b6\u6001\u5e94\u4e3a\u672a\u5907\u6848\u6216\u5df2\u5907\u6848\u3002", (String)"FilPerInitDataService_2", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        } else {
            Object regDate;
            if (!"".equals(filingStatus)) {
                msg = msg + ResManager.loadKDString((String)"\u5907\u6848\u72b6\u6001\u5e94\u4e3a\u7a7a\u3002", (String)"FilPerInitDataService_3", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
            if ((regDate = map.get("regdate")) != null) {
                msg = msg + ResManager.loadKDString((String)"\u5907\u6848\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"FilPerInitDataService_4", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        }
        if (!(empposorgrelExist = this.isEmpposorgrelExist(empposorgrels, number, name))) {
            msg = msg + ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u751f\u6548\u4e2d\u7684\u4efb\u804c\u7ecf\u5386\u3002", (String)"FilPerInitDataService_5", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        if (!(manageOrgExist = this.isManageOrgExist(manageOrgName, manageOrgArray))) {
            msg = msg + ResManager.loadKDString((String)"\u5916\u4e8b\u7ba1\u7406\u5355\u4f4d\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"FilPerInitDataService_9", (String)"sihc-soefam-business", (Object[])new Object[]{manageOrgName});
        }
        Object regDate = map.get("regdate");
        if ("B".equals(filingStatus)) {
            if (regDate == null) {
                msg = msg + ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5907\u6848\u65e5\u671f\u3002", (String)"FilPerInitDataService_10", (String)"sihc-soefam-business", (Object[])new Object[0]);
            }
        } else if ("A".equals(filingStatus) && regDate != null) {
            msg = msg + ResManager.loadKDString((String)"\u5907\u6848\u65e5\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"FilPerInitDataService_11", (String)"sihc-soefam-business", (Object[])new Object[0]);
        }
        if ("".equals(msg)) {
            this.getInitOutParam().addSuccessMsg((Long)map.get("id"), "", "");
        } else {
            this.getInitOutParam().addErrorMsg((Long)map.get("id"), msg.substring(0, msg.length() - 1) + "\u3002");
        }
    }

    public void save() {
        this.validate();
        Map info = this.getInfoWithMap();
        List data = (List)info.get("data");
        this.doSave(data);
    }

    public void doSave(List<Map<String, Object>> data) {
        List<Object> personNumber = data.stream().map(map -> map.get("personnumber")).collect(Collectors.toList());
        List<Object> personName = data.stream().map(map -> map.get("personname")).collect(Collectors.toList());
        List<Object> manageOrgNameList = data.stream().map(map -> map.get("manageorg")).collect(Collectors.toList());
        DynamicObject[] personInfo = HrpiQueryServiceHelper.getPersonInfoByNameAndNumber(personNumber, personName);
        List<Long> personIds = Arrays.stream(personInfo).map(person -> person.getLong("id")).collect(Collectors.toList());
        List cadreInfoList = Arrays.stream(CadreInfoConsumerHelper.getCadreByPersonIds(personIds)).filter(dy -> "1".equals(dy.getString("businessstatus"))).collect(Collectors.toList());
        HashMap<Long, Long> cadreMap = new HashMap<Long, Long>(10);
        for (DynamicObject cadreInfo : cadreInfoList) {
            cadreMap.put(cadreInfo.getLong("person.id"), cadreInfo.getLong("id"));
        }
        Map<Long, Long> employeeInfo = HrpiQueryServiceHelper.getEmployeeInfoByPerson(personIds);
        LOGGER.info("FilPerInitDataService.save.employeeInfo:{}", employeeInfo);
        List<Long> employeeIds = Arrays.asList(employeeInfo.values().toArray(new Long[0]));
        DynamicObject[] empposorgrels = FilPerScopeApplicationService.getAllEmpposorgrelByEmployeeIds(employeeIds);
        HashMap<Long, List<DynamicObject>> empposorgrelMap = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObject[] personalPassportManageOrgInfo = MANAGE_ORG_QUERY_SERVICE.getManageOrgNameInfos("1", manageOrgNameList);
        HashMap<String, DynamicObject> personalPassportManageOrgInfoMap = new HashMap<String, DynamicObject>(personalPassportManageOrgInfo.length);
        for (DynamicObject onePersonalPassport : personalPassportManageOrgInfo) {
            personalPassportManageOrgInfoMap.put(onePersonalPassport.getString("manageorg.name"), onePersonalPassport.getDynamicObject("manageorg"));
        }
        DynamicObject[] onBusManageOrgInfo = MANAGE_ORG_QUERY_SERVICE.getOnBusManageOrgInfo("0", null);
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject empposorgrel : empposorgrels) {
            paramMap.put(empposorgrel.getLong("adminorg.id"), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
            List list = (List)empposorgrelMap.get(empposorgrel.getLong("employee.id"));
            if (list == null) {
                ArrayList<Object> empposorgrelNewList = new ArrayList<Object>(10);
                empposorgrelNewList.add(empposorgrel);
                empposorgrelMap.put(empposorgrel.getLong("employee.id"), empposorgrelNewList);
                continue;
            }
            list.add(empposorgrel);
        }
        LOGGER.info("FilPerInitDataService.save.empposorgrelMap:{}", empposorgrelMap);
        LOGGER.info("FilPerInitDataService.save.paramMap:{}", paramMap);
        List<Map<String, Long>> resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, HRCSRpcConstants.BIZ_OBJ_TYPE);
        LOGGER.info("FilPerInitDataService.save.resultList:{}", resultList);
        DynamicObject[] recPersonTypes = RecPersonTypeQueryService.getAllRecPersonType();
        ArrayList<DynamicObject> filPersons = new ArrayList<DynamicObject>(10);
        for (Map map2 : data) {
            this.mapSave(personInfo, employeeInfo, empposorgrelMap, cadreMap, resultList, recPersonTypes, filPersons, personalPassportManageOrgInfoMap, onBusManageOrgInfo, map2);
        }
        if (filPersons.size() > 0) {
            this.setInitDefalutValue(filPersons);
        }
        FILPERSONMG_APPLICATION_SERVICE.save(filPersons.toArray(new DynamicObject[0]));
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.initCertificate(batchNumber);
    }

    public void initCertificate(Long batchNumber) {
        DynamicObject[] effectFilPers = FILPERSONMG_APPLICATION_SERVICE.getFilPerByBatchNumber(batchNumber);
        CERTIFICATE_APPLICATION_SERVICE.initCertificate("enable", effectFilPers);
        List<Long> effectFilPerIds = Arrays.stream(effectFilPers).map(effectFilPer -> effectFilPer.getLong("id")).collect(Collectors.toList());
        DynamicObject[] certIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByFilPerIds(effectFilPerIds);
        if (certIfiCates.length > 0) {
            this.setInitDefalutValue(Arrays.asList(certIfiCates));
        }
        DOMAIN_SERVICE.updateCertIfiCate(certIfiCates);
    }

    public void mapSave(DynamicObject[] personInfo, Map<Long, Long> employeeInfo, Map<Long, List<DynamicObject>> empposorgrelMap, Map<Long, Long> cadreMap, List<Map<String, Long>> resultList, DynamicObject[] recPersonTypes, List<DynamicObject> filPersons, Map<String, DynamicObject> personalPassportManageOrg, DynamicObject[] onBusManageOrgInfo, Map<String, Object> map) {
        Map initOutMessageMap = this.getInitOutParam().getData();
        InitOutMessage initOutMessage = (InitOutMessage)initOutMessageMap.get(map.get("id"));
        if (!initOutMessage.getSuccess().booleanValue()) {
            return;
        }
        this.doMapSave(personInfo, employeeInfo, empposorgrelMap, cadreMap, resultList, recPersonTypes, filPersons, personalPassportManageOrg, onBusManageOrgInfo, map);
    }

    public void doMapSave(DynamicObject[] personInfo, Map<Long, Long> employeeInfo, Map<Long, List<DynamicObject>> empposorgrelMap, Map<Long, Long> cadreMap, List<Map<String, Long>> resultList, DynamicObject[] recPersonTypes, List<DynamicObject> filPersons, Map<String, DynamicObject> personalPassportManageOrg, DynamicObject[] onBusManageOrgInfo, Map<String, Object> map) {
        String number = map.get("personnumber").toString();
        String name = map.get("personname").toString();
        String manageOrgName = map.get("manageorg").toString();
        DynamicObject filPerson = FILPERSONMG_APPLICATION_SERVICE.generateEmptyDynamicObject();
        DynamicObject personExist = this.isPersonEmpPosOrgRelExist(personInfo, number, name, employeeInfo, empposorgrelMap);
        if (personExist == null) {
            return;
        }
        filPerson.set("number", (Object)personExist.getString("name"));
        filPerson.set("person", (Object)personExist.getLong("id"));
        Long cadreId = cadreMap.get(personExist.getLong("id"));
        if (cadreId != null && cadreId > 0L) {
            filPerson.set("cadrefile", (Object)cadreId);
            filPerson.set("iscadre", (Object)1);
        }
        Long employeeId = employeeInfo.get(personExist.getLong("id"));
        filPerson.set("employee", (Object)employeeId);
        DynamicObjectCollection manageOrgs = filPerson.getDynamicObjectCollection("manageorg");
        if (onBusManageOrgInfo.length != 0) {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)onBusManageOrgInfo[0].getDynamicObject("manageorg"));
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(1)).set("fbasedataid", (Object)personalPassportManageOrg.get(manageOrgName));
        } else {
            manageOrgs.addNew();
            ((DynamicObject)manageOrgs.get(0)).set("fbasedataid", (Object)personalPassportManageOrg.get(manageOrgName));
        }
        filPerson.set("primanageorg", (Object)personalPassportManageOrg.get(manageOrgName));
        filPerson.set("indexfield", (Object)personExist.getLong("id"));
        List<DynamicObject> empPosOrgRelList = empposorgrelMap.get(employeeId);
        if (empPosOrgRelList != null) {
            for (DynamicObject empPosOrgRel : empPosOrgRelList) {
                Date regDate;
                String dataStatus = empPosOrgRel.getString("datastatus");
                String businessStatus = empPosOrgRel.getString("businessstatus");
                if ("1".equals(dataStatus) && "1".equals(businessStatus)) {
                    filPerson.set("empposorgrel", (Object)empPosOrgRel.getLong("id"));
                    long adminOrgId = empPosOrgRel.getLong("adminorg.id");
                    filPerson.set("admorg", (Object)adminOrgId);
                    for (Map<String, Long> result : resultList) {
                        Long hrAdminOrgId = result.get("adminOrgId");
                        if (hrAdminOrgId != adminOrgId) continue;
                        Long hrBuId = result.get("hrBuId");
                        filPerson.set("org", (Object)hrBuId);
                    }
                }
                if ((regDate = (Date)map.get("regdate")) == null) continue;
                Date startDate = empPosOrgRel.getDate("startdate");
                Date endDate = empPosOrgRel.getDate("enddate");
                if (regDate.before(startDate) || regDate.after(endDate)) continue;
                filPerson.set("company", (Object)empPosOrgRel.getString("company.name"));
                filPerson.set("depemp", (Object)empPosOrgRel.getString("adminorg.name"));
                filPerson.set("job", (Object)empPosOrgRel.getString("job.name"));
                filPerson.set("position", (Object)empPosOrgRel.getString("position.name"));
                filPerson.set("stdposition", (Object)empPosOrgRel.getString("stdposition.name"));
            }
        }
        Object recPersonTypeName = map.get("recpersontype");
        for (DynamicObject recPersonType : recPersonTypes) {
            if (!recPersonType.getString("name").equals(recPersonTypeName)) continue;
            filPerson.set("recpersontype", (Object)recPersonType.getLong("id"));
        }
        filPerson.set("entrymethod", (Object)"1");
        filPerson.set("status", (Object)"C");
        Object effStatus = map.get("effstatus");
        filPerson.set("effstatus", effStatus);
        if ("1".equals(effStatus)) {
            filPerson.set("listtype", (Object)"0");
        } else {
            filPerson.set("listtype", (Object)"1");
        }
        filPerson.set("filingstatus", map.get("filingstatus"));
        filPerson.set("iregscopedate", map.get("iregscopedate"));
        filPerson.set("regdate", map.get("regdate"));
        filPerson.set("enable", (Object)"1");
        filPerson.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        filPerson.set("createtime", (Object)new Date());
        filPerson.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        filPerson.set("modifytime", (Object)new Date());
        filPersons.add(filPerson);
    }

    public void changeSuccessStatus() {
        super.changeSuccessStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "2");
    }

    public void changeProcessingStatus() {
        super.changeProcessingStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "0");
    }

    public void changeValidatedStatus() {
        super.changeValidatedStatus();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        this.doUpdateStatus(batchNumber, "1");
    }

    public void rollback() {
        super.rollback();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        DOMAIN_SERVICE.deleteCertIfiCateByBatchNumber(batchNumber);
    }

    public DynamicObject isPersonExist(DynamicObject[] personInfo, String number, String name) {
        for (DynamicObject person : personInfo) {
            String personNumber = person.getString("number");
            String personName = person.getString("name");
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            return person;
        }
        return null;
    }

    public DynamicObject isPersonEmpPosOrgRelExist(DynamicObject[] personInfo, String number, String name, Map<Long, Long> employeeInfo, Map<Long, List<DynamicObject>> empposorgrelMap) {
        for (DynamicObject person : personInfo) {
            String personNumber = person.getString("number");
            String personName = person.getString("name");
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            Long employeeId = employeeInfo.get(person.getLong("id"));
            List<DynamicObject> empPosOrgRels = empposorgrelMap.get(employeeId);
            for (DynamicObject empPosOrgRel : empPosOrgRels) {
                String dataStatus = empPosOrgRel.getString("datastatus");
                String businessStatus = empPosOrgRel.getString("businessstatus");
                if (!"1".equals(dataStatus) || !"1".equals(businessStatus)) continue;
                return person;
            }
        }
        return null;
    }

    public boolean isNotEffectFilPerExist(DynamicObject[] notEffectFilPers, List<Map<String, Object>> data, String number, String name) {
        for (DynamicObject notEffectFilPer : notEffectFilPers) {
            String personNumber = notEffectFilPer.getString("person.number");
            String personName = notEffectFilPer.getString("person.name");
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            return true;
        }
        int personCount = 0;
        for (Map<String, Object> map : data) {
            String personNumber = map.get("personnumber").toString();
            String personName = map.get("personname").toString();
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            ++personCount;
        }
        return personCount > 1;
    }

    public boolean isEmpposorgrelExist(DynamicObject[] empposorgrels, String number, String name) {
        for (DynamicObject empposorgrel : empposorgrels) {
            String personNumber = empposorgrel.getString("person.number");
            String personName = empposorgrel.getString("person.name");
            if (!number.equals(personNumber) || !name.equals(personName)) continue;
            return true;
        }
        return false;
    }

    private boolean isManageOrgExist(String manageOrgName, DynamicObject[] manageOrgArray) {
        for (DynamicObject oneManageOrg : manageOrgArray) {
            String orgName = oneManageOrg.getString("manageorg.name");
            String enable = oneManageOrg.getString("enable");
            if (!manageOrgName.equals(orgName) || !"1".equals(enable)) continue;
            return true;
        }
        return false;
    }

    public void doUpdateStatus(Long batchNumber, String initStatus) {
        DynamicObject[] certIfiCates;
        for (DynamicObject certIfiCate : certIfiCates = CERTIFICATE_QUERY_SERVICE.getCertIfiCateByBatchNumber(batchNumber)) {
            certIfiCate.set("initstatus", (Object)initStatus);
        }
        DOMAIN_SERVICE.updateCertIfiCate(certIfiCates);
    }
}

