/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.license;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sihc.soebs.business.application.impl.cert.SIHCCertApplicationServiceImpl;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;
import kd.sihc.soebs.common.constants.dto.response.cert.CertResDTO;
import kd.sihc.soebs.common.enums.cert.HRCertPromptInfoTypeEnum;

public class LicenseService {
    private static final SIHCCertApplicationServiceImpl CERT_APPLICATION_SERVICE = new SIHCCertApplicationServiceImpl();
    private static final String BIZ_APP_ID = "3IJ2R/+5/Q2+";
    private static final Log LOG = LogFactory.getLog(LicenseService.class);

    public boolean isOverLicenseNum(IFormView formView, String formKey) {
        CertResDTO responseDto = CERT_APPLICATION_SERVICE.verifyCertCount(BIZ_APP_ID, formKey);
        LOG.info("LicenseService#checkLicenseNum responseDto : {}", (Object)responseDto);
        if (!responseDto.getSuccess().booleanValue()) {
            formView.showErrorNotification(responseDto.getMessage());
            return true;
        }
        if (HRCertPromptInfoTypeEnum.WARNING.getName().equals(responseDto.getResult()) || HRCertPromptInfoTypeEnum.EXCEED.getName().equals(responseDto.getResult())) {
            formView.showTipNotification(responseDto.getMessage());
        }
        return false;
    }

    public CertResDTO<String> checkLicenseNum(String formKey) {
        CertResDTO responseDto = CERT_APPLICATION_SERVICE.verifyCertCount(BIZ_APP_ID, formKey);
        LOG.info("LicenseService#checkLicenseNum responseDto : {}", (Object)responseDto);
        return responseDto;
    }

    public boolean isValidateSecurity(IFormView formView, List<Long> personIdList, String formKey, String operateName) {
        DynamicObject[] effectCadres = CadreInfoConsumerHelper.getCadreByPersonIdsEffect(personIdList);
        if (effectCadres.length == 0) {
            LOG.info("LicenseService.isValidateSecurity no effect cadres personIdList : {}", personIdList);
            return true;
        }
        List pidList = Arrays.stream(effectCadres).map(dy -> dy.getLong("person.personindexid")).distinct().collect(Collectors.toList());
        CertResDTO responseDto = CERT_APPLICATION_SERVICE.verifyCertByPid(BIZ_APP_ID, formKey, pidList, operateName);
        LOG.info("LicenseService.isValidateSecurity responseDto : {} pidList : {}", (Object)responseDto, pidList);
        if (!responseDto.getSuccess().booleanValue()) {
            formView.showErrorNotification(responseDto.getMessage());
            return false;
        }
        if (HRCertPromptInfoTypeEnum.WARNING.getName().equals(responseDto.getResult()) || HRCertPromptInfoTypeEnum.EXCEED.getName().equals(responseDto.getResult())) {
            formView.getParentView().showTipNotification(responseDto.getMessage());
            formView.sendFormAction(formView.getParentView());
        }
        return true;
    }
}

