/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.manageorg;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.domain.manageorg.ManageOrgService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.time.StopWatch;

public class ManageOrgRangeService
extends HRBaseServiceHelper {
    private static final ManageOrgService CADRE_MANAGE_ORG_QUERY_SERVICE = ServiceFactory.getService(ManageOrgService.class);
    private static final Log LOG = LogFactory.getLog(ManageOrgRangeService.class);
    static ManageOrgRangeService manageOrgRangeService;

    private ManageOrgRangeService(String entityName) {
        super(entityName);
    }

    public static synchronized ManageOrgRangeService init() {
        manageOrgRangeService = new ManageOrgRangeService("soefam_manorgrange");
        return manageOrgRangeService;
    }

    public void setCadreInfo(IFormView formView) {
        long manageOrgId = formView.getModel().getDataEntity().getLong("manageorg.id");
        DynamicObject cadreConfigObj = CADRE_MANAGE_ORG_QUERY_SERVICE.getManageOrgById(Long.valueOf(manageOrgId));
        if (cadreConfigObj == null) {
            return;
        }
        DynamicObjectCollection groupEntity = cadreConfigObj.getDynamicObjectCollection("groupentity");
        if (groupEntity.size() - 1 > 0) {
            formView.getModel().batchCreateNewEntryRow("cadregroupentry", groupEntity.size() - 1);
        }
        for (int index = 0; index < groupEntity.size(); ++index) {
            this.initCadreEntityName(formView, groupEntity, index);
            this.initCadreCategory(formView, groupEntity, index);
            this.initSubEntryEntity(formView, groupEntity, index);
        }
        formView.updateView("cadreorgentry");
        formView.updateView("cadreentry");
    }

    public void checkRequiredAndGroupName(IFormView formView, BeforeItemClickEvent evt) {
        LOG.info("ManageOrgRangeService.checkRequiredAndGroupName start");
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        DynamicObjectCollection cadreGroupEntry = dataEntity.getDynamicObjectCollection("cadregroupentry");
        DynamicObjectCollection specialGroupEntry = dataEntity.getDynamicObjectCollection("specialgroupentry");
        boolean nextExec = this.cadreCheckInfo(formView, cadreGroupEntry);
        if (nextExec) {
            nextExec = this.specialCheckInfo(formView, specialGroupEntry);
        }
        if (nextExec) {
            nextExec = this.checkCombinationName(formView, cadreGroupEntry, specialGroupEntry);
        }
        if (!nextExec) {
            evt.setCancel(true);
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, ManageOrgRangeService.class, (String)"checkRequiredAndGroupName", null);
    }

    private void initCadreCategory(IFormView formView, DynamicObjectCollection groupEntity, int index) {
        DynamicObjectCollection cadSubEntity = ((DynamicObject)groupEntity.get(index)).getDynamicObjectCollection("cadsubentity");
        DynamicObject cadSubObj = (DynamicObject)cadSubEntity.get(0);
        formView.getModel().setEntryCurrentRowIndex("cadregroupentry", index);
        DynamicObjectCollection cadreCategory = cadSubObj.getDynamicObjectCollection("cadrecategory");
        DynamicObjectCollection jobLevels = cadSubObj.getDynamicObjectCollection("joblevel");
        DynamicObjectCollection jobGrades = cadSubObj.getDynamicObjectCollection("jobgrade");
        formView.getModel().setValue("cadrenolimit", (Object)cadSubObj.getString("nolimit"), 0);
        formView.getModel().setValue("cadrecategory", (Object)cadreCategory);
        formView.getModel().setValue("cadrejoblevelnolimit", (Object)cadSubObj.getString("levelnolimit"), 0);
        formView.getModel().setValue("cadrejoblevel", (Object)jobLevels);
        formView.getModel().setValue("cadrejobgradenolimit", (Object)cadSubObj.getString("gradenolimit"), 0);
        formView.getModel().setValue("cadrejobgrade", (Object)jobGrades);
    }

    private void initCadreEntityName(IFormView formView, DynamicObjectCollection groupEntity, int index) {
        formView.getModel().setValue("cadregroupname", (Object)((DynamicObject)groupEntity.get(index)).getString("groupname"), index);
        formView.getModel().setValue("cadregroupdesc", (Object)((DynamicObject)groupEntity.get(index)).getString("groupdesc"), index);
        if (index == groupEntity.size() - 1) {
            formView.getModel().setEntryCurrentRowIndex("cadregroupentry", 0);
            formView.getModel().setValue("cadregroupnameview", (Object)((DynamicObject)groupEntity.get(0)).getString("groupname"), 0);
            formView.getModel().setValue("cadregroupdescview", (Object)((DynamicObject)groupEntity.get(0)).getString("groupdesc"), 0);
        }
    }

    private void initSubEntryEntity(IFormView formView, DynamicObjectCollection groupEntity, int index) {
        DynamicObjectCollection subEntryEntity = ((DynamicObject)groupEntity.get(index)).getDynamicObjectCollection("subentryentity");
        formView.getModel().setEntryCurrentRowIndex("cadregroupentry", index);
        for (int flagIndex = 0; flagIndex < subEntryEntity.size(); ++flagIndex) {
            formView.getModel().createNewEntryRow("cadreorgentry");
            formView.getModel().setValue("cadreadmorg", (Object)((DynamicObject)subEntryEntity.get(flagIndex)).getDynamicObject("admorg"), flagIndex, index);
            formView.getModel().setValue("cadreincludesub", (Object)((DynamicObject)subEntryEntity.get(flagIndex)).getString("includesub"), flagIndex, index);
        }
    }

    private boolean checkCombinationName(IFormView formView, DynamicObjectCollection cadreGroupEntry, DynamicObjectCollection specialGroupEntry) {
        List cadreGroupNameList = cadreGroupEntry.stream().map(obj -> obj.getString("cadregroupname")).collect(Collectors.toList());
        List cadreRepeatName = ManageOrgRangeService.getDuplicateElements(cadreGroupNameList);
        if (cadreRepeatName.size() > 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u9886\u5bfc\u5e72\u90e8\u5907\u6848\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u5408\u540d\u79f0\u201c%s\u201d\u3002", (String)"ManageOrgRangeService_10", (String)"sihc-soefam-business", (Object[])new Object[]{cadreRepeatName.get(0)}));
            return false;
        }
        List specialGroupName = specialGroupEntry.stream().map(obj -> obj.getString("specialgroupname")).collect(Collectors.toList());
        List specialRepeatName = ManageOrgRangeService.getDuplicateElements(specialGroupName);
        if (specialRepeatName.size() > 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7279\u6b8a\u8eab\u4efd\u5907\u6848\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u5408\u540d\u79f0\u201c%s\u201d\u3002", (String)"ManageOrgRangeService_11", (String)"sihc-soefam-business", (Object[])new Object[]{specialRepeatName.get(0)}));
            return false;
        }
        return true;
    }

    private static <E> List<E> getDuplicateElements(List<E> list) {
        return list.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean specialCheckInfo(IFormView formView, DynamicObjectCollection specialGroupEntry) {
        TaskStatus taskStatus = new TaskStatus();
        StringBuilder strBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : specialGroupEntry) {
            if (!taskStatus.nextExec) break;
            this.checkSpecialEntity(formView, taskStatus, strBuilder, dynamicObject);
        }
        return taskStatus.nextExec;
    }

    private void checkSpecialEntity(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder, DynamicObject dynamicObject) {
        DynamicObjectCollection specialOrgEntry = dynamicObject.getDynamicObjectCollection("specialorgentry");
        taskStatus.setNextExec(true);
        taskStatus.setSplit(false);
        strBuilder.setLength(0);
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("specialgroupname"))) {
            this.checkSpecialOrgRequired(formView, taskStatus, strBuilder);
        } else {
            this.checkSpecialOrgCondition(formView, taskStatus, strBuilder, dynamicObject, specialOrgEntry);
        }
    }

    private void checkSpecialOrgCondition(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder, DynamicObject dynamicObject, DynamicObjectCollection specialOrgEntry) {
        DynamicObjectCollection specialEntry;
        DynamicObject specialObj;
        if (specialOrgEntry.isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u884c\u653f\u7ec4\u7ec7\u201d", (String)"ManageOrgRangeService_2", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!(specialObj = (DynamicObject)(specialEntry = dynamicObject.getDynamicObjectCollection("specialentry")).get(0)).getBoolean("positiontypenolimit") && specialObj.getDynamicObjectCollection("position").isEmpty() && specialObj.getDynamicObjectCollection("stposition").isEmpty() && specialObj.getDynamicObjectCollection("job").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u4efb\u5c97\u6a21\u5f0f\u201d", (String)"ManageOrgRangeService_7", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!specialObj.getBoolean("joblevelnolimit") && specialObj.getDynamicObjectCollection("joblevel").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u804c\u7ea7\u201d", (String)"ManageOrgRangeService_8", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!specialObj.getBoolean("jobgradenolimit") && specialObj.getDynamicObjectCollection("jobgrade").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u804c\u7b49\u201d", (String)"ManageOrgRangeService_9", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!taskStatus.nextExec) {
            String msgPre = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7279\u6b8a\u8eab\u4efd\u5907\u6848-%1$s\u7684%2$s\u3002", (String)"ManageOrgRangeService_5", (String)"sihc-soefam-business", (Object[])new Object[]{dynamicObject.getString("specialgroupname"), strBuilder.toString()});
            formView.showTipNotification(msgPre);
        }
    }

    private void checkSpecialOrgRequired(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder) {
        this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u7ec4\u5408\u540d\u79f0\u201d", (String)"ManageOrgRangeService_1", (String)"sihc-soefam-business", (Object[])new Object[0]));
        String msgPre = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7279\u6b8a\u8eab\u4efd\u5907\u6848\u7684%s\u3002", (String)"ManageOrgRangeService_6", (String)"sihc-soefam-business", (Object[])new Object[]{strBuilder.toString()});
        formView.showTipNotification(msgPre);
    }

    private boolean cadreCheckInfo(IFormView formView, DynamicObjectCollection cadreGroupEntry) {
        if (cadreGroupEntry.isEmpty()) {
            return true;
        }
        TaskStatus taskStatus = new TaskStatus();
        StringBuilder strBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : cadreGroupEntry) {
            if (!taskStatus.nextExec) break;
            this.checkCadreEntity(formView, taskStatus, strBuilder, dynamicObject);
        }
        return taskStatus.nextExec;
    }

    private void checkCadreEntity(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder, DynamicObject dynamicObject) {
        taskStatus.setNextExec(true);
        taskStatus.setSplit(false);
        DynamicObjectCollection cadreOrgEntry = dynamicObject.getDynamicObjectCollection("cadreorgentry");
        strBuilder.setLength(0);
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("cadregroupname"))) {
            this.checkCadreOrgRequired(formView, taskStatus, strBuilder);
        } else {
            this.checkCadreOrgCondition(formView, taskStatus, strBuilder, dynamicObject, cadreOrgEntry);
        }
    }

    private void checkCadreOrgRequired(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder) {
        this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u7ec4\u5408\u540d\u79f0\u201d", (String)"ManageOrgRangeService_1", (String)"sihc-soefam-business", (Object[])new Object[0]));
        String msgPre = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u9886\u5bfc\u5e72\u90e8\u5907\u6848\u7684%s\u3002", (String)"ManageOrgRangeService_4", (String)"sihc-soefam-business", (Object[])new Object[]{strBuilder.toString()});
        formView.showTipNotification(msgPre);
    }

    private void checkCadreOrgCondition(IFormView formView, TaskStatus taskStatus, StringBuilder strBuilder, DynamicObject dynamicObject, DynamicObjectCollection cadreOrgEntry) {
        DynamicObject cadreObj;
        if (cadreOrgEntry.isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u884c\u653f\u7ec4\u7ec7\u201d", (String)"ManageOrgRangeService_2", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!(cadreObj = (DynamicObject)dynamicObject.getDynamicObjectCollection("cadreentry").get(0)).getBoolean("cadrenolimit") && cadreObj.getDynamicObjectCollection("cadrecategory").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u5e72\u90e8\u7c7b\u522b\u201d", (String)"ManageOrgRangeService_3", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!cadreObj.getBoolean("cadrejoblevelnolimit") && cadreObj.getDynamicObjectCollection("cadrejoblevel").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u804c\u7ea7\u201d", (String)"ManageOrgRangeService_8", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!cadreObj.getBoolean("cadrejobgradenolimit") && cadreObj.getDynamicObjectCollection("cadrejobgrade").isEmpty()) {
            this.appendMsgField(strBuilder, taskStatus, ResManager.loadKDString((String)"\u201c\u804c\u7b49\u201d", (String)"ManageOrgRangeService_9", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        if (!taskStatus.nextExec) {
            String msgPre = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u9886\u5bfc\u5e72\u90e8\u5907\u6848-%1$s\u7684%2$s\u3002", (String)"ManageOrgRangeService_0", (String)"sihc-soefam-business", (Object[])new Object[]{dynamicObject.getString("cadregroupname"), strBuilder.toString()});
            formView.showTipNotification(msgPre);
        }
    }

    private void appendMsgField(StringBuilder strBuilder, TaskStatus taskStatus, String appendName) {
        if (taskStatus.split) {
            strBuilder.append('\u3001');
        }
        strBuilder.append(appendName);
        taskStatus.setSplit(true);
        taskStatus.setNextExec(false);
    }

    static class TaskStatus {
        boolean split = false;
        boolean nextExec = true;

        TaskStatus() {
        }

        public boolean isSplit() {
            return this.split;
        }

        public void setSplit(boolean split) {
            this.split = split;
        }

        public boolean isNextExec() {
            return this.nextExec;
        }

        public void setNextExec(boolean nextExec) {
            this.nextExec = nextExec;
        }
    }
}

