/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.manageorg;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.domain.manageorg.dto.CadreType;
import kd.sihc.soefam.business.domain.manageorg.dto.ManageOrgMatch;
import kd.sihc.soefam.business.domain.manageorg.dto.SpecialType;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class ManageOrgValidatorService
implements ManageOrgConstants {
    private static final HRBaseServiceHelper MANAGE_SERVICE = new HRBaseServiceHelper("soefam_manorgrange");
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)ManageOrgValidatorService.class.getName(), (int)16);
    private Table<String, Long, String> adminOrgTable = HashBasedTable.create();
    private static final Log LOG = LogFactory.getLog(ManageOrgValidatorService.class);

    public ManageOrgValidatorService() {
        Runtime.getRuntime().availableProcessors();
        QFilter orgFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection adminOrgList = QueryServiceHelper.query((String)"haos_adminorghr", (String)"id,name,structlongnumber", (QFilter[])new QFilter[]{orgFilter});
        adminOrgList.forEach(dynamicObject -> {
            Long adminOrgId = dynamicObject.getLong("id");
            String adminOrgName = dynamicObject.getString("name");
            String longNumber = dynamicObject.getString("structlongnumber");
            this.adminOrgTable.put((Object)longNumber, (Object)adminOrgId, (Object)adminOrgName);
        });
    }

    public String checkManageOrgPosition(Map<String, ManageOrgMatch> curMap) {
        ManageOrgMatch manageOrgMatch = curMap.values().stream().findFirst().orElse(null);
        if (manageOrgMatch == null) {
            return null;
        }
        List<SpecialType> specialTypes = manageOrgMatch.getSpecialTypes();
        HashMap admPositionTypeMap = new HashMap(16);
        specialTypes.forEach(object -> object.getAdmOrgId().forEach(adm -> {
            if (admPositionTypeMap.containsKey(adm)) {
                ((Set)admPositionTypeMap.get(adm)).add(object.getPositiontype());
            } else {
                admPositionTypeMap.put(adm, Sets.newHashSet((Object[])new String[]{object.getPositiontype()}));
            }
        }));
        List repeatAdmIdList = admPositionTypeMap.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (repeatAdmIdList.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            boolean split = false;
            for (Long admId : repeatAdmIdList) {
                Map rowMap;
                if (split) {
                    strBuilder.append('\u3001');
                }
                strBuilder.append(!(rowMap = this.adminOrgTable.column((Object)admId)).isEmpty() ? (String)rowMap.values().stream().findFirst().get() : "");
                split = true;
            }
            return ResManager.loadKDString((String)"%s\u884c\u653f\u7ec4\u7ec7\u4e0b\u7684\u4efb\u5c97\u6a21\u5f0f\u4e0d\u7edf\u4e00\u3002", (String)"MgOrgRangeSaveValidator_4", (String)"sihc-soefam-business", (Object[])new Object[]{strBuilder.toString()});
        }
        return null;
    }

    public DynamicObject[] getManageOrg(QFilter qFilter) {
        return MANAGE_SERVICE.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public Map<String, ManageOrgMatch> generateJudgeObj(DynamicObject mgOrgEntity) {
        HashMap<String, ManageOrgMatch> mgOrgMap = new HashMap<String, ManageOrgMatch>(8);
        if (mgOrgEntity != null) {
            ManageOrgMatch manageOrgMatch = new ManageOrgMatch(mgOrgEntity.getString("name"));
            this.generateCadreObj(mgOrgEntity, mgOrgMap, manageOrgMatch);
            this.generateSpecialObj(mgOrgEntity, mgOrgMap, manageOrgMatch);
        }
        return mgOrgMap;
    }

    private void generateSpecialObj(DynamicObject dynamicObject, Map<String, ManageOrgMatch> judgeMap, ManageOrgMatch manageOrgMatch) {
        List<SpecialType> manageOrgList = Collections.synchronizedList(new ArrayList(8));
        DynamicObjectCollection groupCol = dynamicObject.getDynamicObjectCollection("specialgroupentry");
        ArrayList futures = new ArrayList(groupCol.size());
        groupCol.forEach(orgItem -> futures.add(EXECUTOR_SERVICE.submit(() -> {
            DynamicObjectCollection subCol = orgItem.getDynamicObjectCollection("specialorgentry");
            String groupName = orgItem.getString("specialgroupname");
            for (DynamicObject sub : subCol) {
                this.iteratorSpecialOrgItem(manageOrgList, (DynamicObject)orgItem, groupName, sub);
            }
        })));
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception exception) {
            LOG.error("ManageOrgValidatorService.generateSpecialObj error", (Throwable)exception);
        }
        manageOrgMatch.setSpecialTypes(manageOrgList);
        String number = dynamicObject.getString("number");
        judgeMap.put(number, manageOrgMatch);
    }

    private void iteratorSpecialOrgItem(List<SpecialType> manageOrgList, DynamicObject orgItem, String groupName, DynamicObject sub) {
        DynamicObject admOrg = sub.getDynamicObject("specialadmorg");
        ArrayList<Long> admOrgIdList = new ArrayList<Long>(16);
        if (sub.getBoolean("specialincludesub")) {
            this.getOrgIdList(admOrg, admOrgIdList);
        } else {
            admOrgIdList.add(admOrg.getLong("id"));
        }
        String admOrgName = admOrg.getString("name");
        DynamicObject specialConditionObj = (DynamicObject)orgItem.getDynamicObjectCollection("specialentry").get(0);
        SpecialType specialType = new SpecialType();
        specialType.setPositiontype(specialConditionObj.getString("positiontype"));
        ArrayList<Long> positionIdList = new ArrayList<Long>(16);
        ArrayList<Long> stPositionIdList = new ArrayList<Long>(16);
        ArrayList<Long> jobIdList = new ArrayList<Long>(16);
        this.positionTypeBuild(specialConditionObj, positionIdList, stPositionIdList, jobIdList);
        ArrayList<Long> jobLevelIdList = new ArrayList<Long>(16);
        this.getJobLevelId(specialConditionObj, jobLevelIdList, "joblevelnolimit", "joblevel");
        ArrayList<Long> jobGradeIdList = new ArrayList<Long>(16);
        this.getJobGradeId(specialConditionObj, jobGradeIdList, "jobgradenolimit", "jobgrade");
        specialType.setGroupName(groupName);
        specialType.setAdmOrgName(admOrgName);
        specialType.setAdmOrgId(admOrgIdList);
        specialType.setPositionIdList(positionIdList);
        specialType.setStPositionIdList(stPositionIdList);
        specialType.setJobIdList(jobIdList);
        specialType.setJobLevelIdList(jobLevelIdList);
        specialType.setJobGradeIdList(jobGradeIdList);
        manageOrgList.add(specialType);
    }

    private void getJobGradeId(DynamicObject specialConditionObj, List<Long> jobGradeIdList, String fieldJobgradenolimit, String fieldJobgrade) {
        if (specialConditionObj.getBoolean(fieldJobgradenolimit)) {
            jobGradeIdList.add(-1L);
        } else {
            specialConditionObj.getDynamicObjectCollection(fieldJobgrade).forEach(dy -> jobGradeIdList.add(dy.getLong("fbasedataid_id")));
        }
    }

    private void getJobLevelId(DynamicObject specialConditionObj, List<Long> jobLevelIdList, String fieldJoblevelnolimit, String fieldJoblevel) {
        if (specialConditionObj.getBoolean(fieldJoblevelnolimit)) {
            jobLevelIdList.add(-1L);
        } else {
            specialConditionObj.getDynamicObjectCollection(fieldJoblevel).forEach(dy -> jobLevelIdList.add(dy.getLong("fbasedataid_id")));
        }
    }

    private void positionTypeBuild(DynamicObject specialConditionObj, List<Long> positionIdList, List<Long> stPositionIdList, List<Long> jobIdList) {
        if (specialConditionObj.getBoolean("positiontypenolimit")) {
            this.notLimitPositionType(specialConditionObj, positionIdList, stPositionIdList, jobIdList);
        } else {
            this.selectPositionType(specialConditionObj, positionIdList, stPositionIdList, jobIdList);
        }
    }

    private void selectPositionType(DynamicObject specialConditionObj, List<Long> positionIdList, List<Long> stPositionIdList, List<Long> jobIdList) {
        switch (specialConditionObj.getString("positiontype")) {
            case "0": {
                specialConditionObj.getDynamicObjectCollection("stposition").forEach(dy -> stPositionIdList.add(dy.getLong("fbasedataid_id")));
                break;
            }
            case "1": {
                specialConditionObj.getDynamicObjectCollection("position").forEach(dy -> positionIdList.add(dy.getLong("fbasedataid_id")));
                break;
            }
            case "2": {
                specialConditionObj.getDynamicObjectCollection("job").forEach(dy -> jobIdList.add(dy.getLong("fbasedataid_id")));
            }
        }
    }

    private void notLimitPositionType(DynamicObject specialConditionObj, List<Long> positionIdList, List<Long> stPositionIdList, List<Long> jobIdList) {
        switch (specialConditionObj.getString("positiontype")) {
            case "0": {
                stPositionIdList.add(-1L);
                break;
            }
            case "1": {
                positionIdList.add(-1L);
                break;
            }
            case "2": {
                jobIdList.add(-1L);
            }
        }
    }

    private void generateCadreObj(DynamicObject mgOrgEntity, Map<String, ManageOrgMatch> mgOrgMap, ManageOrgMatch manageOrgMatch) {
        List<CadreType> manageOrgList = Collections.synchronizedList(new ArrayList(8));
        DynamicObjectCollection cadreGroupCol = mgOrgEntity.getDynamicObjectCollection("cadregroupentry");
        ArrayList futures = new ArrayList(cadreGroupCol.size());
        cadreGroupCol.forEach(orgItem -> futures.add(EXECUTOR_SERVICE.submit(() -> this.iterateSubCol(manageOrgList, (DynamicObject)orgItem))));
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception exception) {
            LOG.error("ManageOrgValidatorService.generateCadreObj error", (Throwable)exception);
        }
        manageOrgMatch.setCadreTypes(manageOrgList);
        String number = mgOrgEntity.getString("number");
        mgOrgMap.put(number, manageOrgMatch);
    }

    private void iterateSubCol(List<CadreType> manageOrgList, DynamicObject orgItem) {
        DynamicObjectCollection subCol = orgItem.getDynamicObjectCollection("cadreorgentry");
        String groupName = orgItem.getString("cadregroupname");
        for (DynamicObject sub : subCol) {
            DynamicObject admOrg = sub.getDynamicObject("cadreadmorg");
            ArrayList<Long> admOrgId = new ArrayList<Long>(10);
            if (sub.getBoolean("cadreincludesub")) {
                this.getOrgIdList(admOrg, admOrgId);
            } else {
                admOrgId.add(admOrg.getLong("id"));
            }
            String admOrgName = admOrg.getString("name");
            DynamicObject cadCol = (DynamicObject)orgItem.getDynamicObjectCollection("cadreentry").get(0);
            ArrayList<Long> cadreCategoryId = new ArrayList<Long>(10);
            if (cadCol.getBoolean("cadrenolimit")) {
                cadreCategoryId.add(-1L);
            } else {
                cadCol.getDynamicObjectCollection("cadrecategory").forEach(dy -> cadreCategoryId.add(dy.getLong("fbasedataid_id")));
            }
            ArrayList<Long> jobLevelIdList = new ArrayList<Long>(16);
            this.getJobLevelId(cadCol, jobLevelIdList, "cadrejoblevelnolimit", "cadrejoblevel");
            ArrayList<Long> jobGradeIdList = new ArrayList<Long>(16);
            this.getJobGradeId(cadCol, jobGradeIdList, "cadrejobgradenolimit", "cadrejobgrade");
            CadreType manageOrg = new CadreType(groupName, admOrgName, admOrgId, cadreCategoryId, jobLevelIdList, jobGradeIdList);
            manageOrgList.add(manageOrg);
        }
    }

    private void getOrgIdList(DynamicObject admOrgItem, List<Long> admOrgIdList) {
        String admOrgNumber = admOrgItem.getString("structlongnumber");
        for (Table.Cell tableCell : this.adminOrgTable.cellSet()) {
            if (!((String)tableCell.getRowKey()).contains(admOrgNumber)) continue;
            admOrgIdList.add((Long)tableCell.getColumnKey());
        }
    }

    public Map<String, ManageOrgMatch> judgeRepeat(Map<String, ManageOrgMatch> curObj, Map<String, ManageOrgMatch> obj) {
        HashMap<String, ManageOrgMatch> repeatMap = new HashMap<String, ManageOrgMatch>(8);
        ManageOrgMatch curManageOrgObj = curObj.values().stream().findFirst().orElse(null);
        ManageOrgMatch manageOrgObj = obj.values().stream().findFirst().orElse(null);
        ManageOrgMatch manageOrgMatch = new ManageOrgMatch(curManageOrgObj.getMgRangName());
        this.judeCadreRepeat(obj, repeatMap, curManageOrgObj, manageOrgObj, manageOrgMatch);
        this.judeSpecialRepeat(obj, repeatMap, curManageOrgObj, manageOrgObj, manageOrgMatch);
        return repeatMap;
    }

    private void judeSpecialRepeat(Map<String, ManageOrgMatch> obj, Map<String, ManageOrgMatch> repeatMap, ManageOrgMatch curManageOrgObj, ManageOrgMatch manageOrgObj, ManageOrgMatch manageOrgMatch) {
        ArrayList<SpecialType> manageOrgRepeat = new ArrayList<SpecialType>(curManageOrgObj.getSpecialTypes().size());
        for (int curIndex = 0; curIndex < curManageOrgObj.getSpecialTypes().size(); ++curIndex) {
            this.iteratorSpecialType(curManageOrgObj, manageOrgObj, manageOrgMatch, manageOrgRepeat, curIndex);
        }
        if (manageOrgRepeat.size() > 0) {
            String repeatNum = (String)obj.keySet().stream().findFirst().get();
            manageOrgMatch.setSpecialTypes(manageOrgRepeat);
            repeatMap.put(repeatNum, manageOrgMatch);
        }
    }

    private void iteratorSpecialType(ManageOrgMatch curManageOrgObj, ManageOrgMatch manageOrgObj, ManageOrgMatch manageOrgMatch, List<SpecialType> manageOrgRepeat, int curIndex) {
        SpecialType curManageOrg = curManageOrgObj.getSpecialTypes().get(curIndex);
        HashSet admRepeatSet = Sets.newHashSet();
        HashSet positionIdRepeatSet = Sets.newHashSet();
        HashSet stPositionIdRepeatSet = Sets.newHashSet();
        HashSet jobIdRepeatSet = Sets.newHashSet();
        HashSet jobLevelIdRepeatSet = Sets.newHashSet();
        HashSet jobGradeIdRepeatSet = Sets.newHashSet();
        HashSet positionTypeRepeatSet = Sets.newHashSet();
        for (int index = 0; index < manageOrgObj.getSpecialTypes().size(); ++index) {
            SpecialType manageOrg = manageOrgObj.getSpecialTypes().get(index);
            admRepeatSet.addAll(curManageOrg.getAdmOrgId().stream().filter(dy -> manageOrg.getAdmOrgId().contains(dy)).collect(Collectors.toSet()));
            if (admRepeatSet.size() == 0) continue;
            SpecialType specialType = new SpecialType();
            specialType.setGroupName(curManageOrg.getGroupName());
            specialType.setAdmOrgName(curManageOrg.getAdmOrgName());
            specialType.setAdmOrgId(new ArrayList<Long>(admRepeatSet));
            if (!curManageOrg.getPositiontype().equals(manageOrg.getPositiontype())) {
                positionTypeRepeatSet.add(manageOrg.getPositiontype());
            }
            if (positionTypeRepeatSet.size() > 0) {
                specialType.setErrorType(0);
                specialType.setPositiontype(manageOrg.getPositiontype());
                manageOrgMatch.setRepeatMgRangName(manageOrgObj.getMgRangName());
                manageOrgRepeat.add(specialType);
                continue;
            }
            boolean flag = false;
            flag = this.isPositionRepeat(curManageOrg, positionIdRepeatSet, manageOrg, specialType, flag);
            flag = this.isStPositionRepeat(curManageOrg, stPositionIdRepeatSet, manageOrg, specialType, flag);
            flag = this.isJobRepeat(curManageOrg, jobIdRepeatSet, manageOrg, specialType, flag);
            boolean repeatJobLevel = this.isRepeatJobLevel(curManageOrg, jobLevelIdRepeatSet, manageOrg, specialType);
            boolean repeatJobGrade = this.isRepeatJobGrade(curManageOrg, jobGradeIdRepeatSet, manageOrg, specialType);
            if (flag && repeatJobLevel && repeatJobGrade) {
                manageOrgMatch.setRepeatMgRangName(manageOrgObj.getMgRangName());
                manageOrgRepeat.add(specialType);
            }
            admRepeatSet.clear();
            positionIdRepeatSet.clear();
            stPositionIdRepeatSet.clear();
            jobIdRepeatSet.clear();
            jobLevelIdRepeatSet.clear();
            jobGradeIdRepeatSet.clear();
        }
    }

    private boolean isRepeatJobGrade(SpecialType curManageOrg, Set<Long> jobGradeIdRepeatSet, SpecialType manageOrg, SpecialType specialType) {
        boolean repeatJobGrade = false;
        if (curManageOrg.getJobGradeIdList().contains(-1L) || manageOrg.getJobGradeIdList().contains(-1L)) {
            List<Long> jobGradeIdList = curManageOrg.getJobGradeIdList().contains(-1L) ? manageOrg.getJobGradeIdList() : curManageOrg.getJobGradeIdList();
            jobGradeIdRepeatSet.addAll(jobGradeIdList);
        } else {
            jobGradeIdRepeatSet.addAll(curManageOrg.getJobGradeIdList().stream().filter(dy -> manageOrg.getJobGradeIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (jobGradeIdRepeatSet.size() > 0) {
            repeatJobGrade = true;
            specialType.setErrorType(1);
            specialType.setJobGradeIdList(new ArrayList<Long>(jobGradeIdRepeatSet));
        }
        return repeatJobGrade;
    }

    private boolean isRepeatJobLevel(SpecialType curManageOrg, Set<Long> jobLevelIdRepeatSet, SpecialType manageOrg, SpecialType specialType) {
        boolean repeatJobLevel = false;
        if (curManageOrg.getJobLevelIdList().contains(-1L) || manageOrg.getJobLevelIdList().contains(-1L)) {
            List<Long> jobLevelIdList = curManageOrg.getJobLevelIdList().contains(-1L) ? manageOrg.getJobLevelIdList() : curManageOrg.getJobLevelIdList();
            jobLevelIdRepeatSet.addAll(jobLevelIdList);
        } else {
            jobLevelIdRepeatSet.addAll(curManageOrg.getJobLevelIdList().stream().filter(dy -> manageOrg.getJobLevelIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (jobLevelIdRepeatSet.size() > 0) {
            repeatJobLevel = true;
            specialType.setErrorType(1);
            specialType.setJobLevelIdList(new ArrayList<Long>(jobLevelIdRepeatSet));
        }
        return repeatJobLevel;
    }

    private boolean isJobRepeat(SpecialType curManageOrg, Set<Long> jobIdRepeatSet, SpecialType manageOrg, SpecialType specialType, boolean flag) {
        if (curManageOrg.getJobIdList().contains(-1L) || manageOrg.getJobIdList().contains(-1L)) {
            List<Long> jobIdList = curManageOrg.getJobIdList().contains(-1L) ? manageOrg.getJobIdList() : curManageOrg.getJobIdList();
            jobIdRepeatSet.addAll(jobIdList);
        } else {
            jobIdRepeatSet.addAll(curManageOrg.getJobIdList().stream().filter(dy -> manageOrg.getJobIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (jobIdRepeatSet.size() > 0) {
            flag = true;
            specialType.setErrorType(1);
            specialType.setJobIdList(new ArrayList<Long>(jobIdRepeatSet));
        }
        return flag;
    }

    private boolean isStPositionRepeat(SpecialType curManageOrg, Set<Long> stPositionIdRepeatSet, SpecialType manageOrg, SpecialType specialType, boolean flag) {
        if (curManageOrg.getStPositionIdList().contains(-1L) || manageOrg.getStPositionIdList().contains(-1L)) {
            List<Long> stPositionIdList = curManageOrg.getStPositionIdList().contains(-1L) ? manageOrg.getStPositionIdList() : curManageOrg.getStPositionIdList();
            stPositionIdRepeatSet.addAll(stPositionIdList);
        } else {
            stPositionIdRepeatSet.addAll(curManageOrg.getStPositionIdList().stream().filter(dy -> manageOrg.getStPositionIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (stPositionIdRepeatSet.size() > 0) {
            flag = true;
            specialType.setErrorType(1);
            specialType.setStPositionIdList(new ArrayList<Long>(stPositionIdRepeatSet));
        }
        return flag;
    }

    private boolean isPositionRepeat(SpecialType curManageOrg, Set<Long> positionIdRepeatSet, SpecialType manageOrg, SpecialType specialType, boolean flag) {
        if (curManageOrg.getPositionIdList().contains(-1L) || manageOrg.getPositionIdList().contains(-1L)) {
            List<Long> positionIdList = curManageOrg.getPositionIdList().contains(-1L) ? manageOrg.getPositionIdList() : curManageOrg.getPositionIdList();
            positionIdRepeatSet.addAll(positionIdList);
        } else {
            positionIdRepeatSet.addAll(curManageOrg.getPositionIdList().stream().filter(dy -> manageOrg.getPositionIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (positionIdRepeatSet.size() > 0) {
            flag = true;
            specialType.setErrorType(1);
            specialType.setPositionIdList(new ArrayList<Long>(positionIdRepeatSet));
        }
        return flag;
    }

    private void judeCadreRepeat(Map<String, ManageOrgMatch> obj, Map<String, ManageOrgMatch> repeatMap, ManageOrgMatch curManageOrgObj, ManageOrgMatch manageOrgObj, ManageOrgMatch manageOrgMatch) {
        ArrayList<CadreType> manageOrgRepeat = new ArrayList<CadreType>(curManageOrgObj.getCadreTypes().size());
        for (int curIndex = 0; curIndex < curManageOrgObj.getCadreTypes().size(); ++curIndex) {
            this.iteratorManageOrgRepeat(curManageOrgObj, manageOrgObj, manageOrgMatch, manageOrgRepeat, curIndex);
        }
        if (manageOrgRepeat.size() > 0) {
            String repeatNum = (String)obj.keySet().stream().findFirst().get();
            manageOrgMatch.setCadreTypes(manageOrgRepeat);
            repeatMap.put(repeatNum, manageOrgMatch);
        }
    }

    private void iteratorManageOrgRepeat(ManageOrgMatch curManageOrgObj, ManageOrgMatch manageOrgObj, ManageOrgMatch manageOrgMatch, List<CadreType> manageOrgRepeat, int curIndex) {
        CadreType curManageOrg = curManageOrgObj.getCadreTypes().get(curIndex);
        HashSet admRepeat = Sets.newHashSet();
        HashSet cadRepeat = Sets.newHashSet();
        HashSet jobLevelIdRepeatSet = Sets.newHashSet();
        HashSet jobGradeIdRepeatSet = Sets.newHashSet();
        for (int index = 0; index < manageOrgObj.getCadreTypes().size(); ++index) {
            CadreType manageOrg = manageOrgObj.getCadreTypes().get(index);
            admRepeat.addAll(curManageOrg.getAdmOrgId().stream().filter(dy -> manageOrg.getAdmOrgId().contains(dy)).collect(Collectors.toSet()));
            if (admRepeat.size() == 0) continue;
            CadreType cadreType = new CadreType();
            cadreType.setGroupName(curManageOrg.getGroupName());
            cadreType.setAdmOrgName(curManageOrg.getAdmOrgName());
            cadreType.setAdmOrgId(new ArrayList<Long>(admRepeat));
            boolean repeatCadreCategory = this.isRepeatCadreCategory(curManageOrg, cadRepeat, manageOrg, cadreType);
            boolean repeatJobLevel = this.isRepeatJobLevelForJude(curManageOrg, jobLevelIdRepeatSet, manageOrg, cadreType);
            boolean repeatJobGrade = this.isRepeatJobGradeForJude(curManageOrg, jobGradeIdRepeatSet, manageOrg, cadreType);
            if (repeatCadreCategory && repeatJobLevel && repeatJobGrade) {
                manageOrgMatch.setRepeatMgRangName(manageOrgObj.getMgRangName());
                manageOrgRepeat.add(cadreType);
            }
            admRepeat.clear();
            jobLevelIdRepeatSet.clear();
            jobGradeIdRepeatSet.clear();
        }
    }

    private boolean isRepeatJobGradeForJude(CadreType curManageOrg, Set<Long> jobGradeIdRepeatSet, CadreType manageOrg, CadreType cadreType) {
        boolean repeatJobGrade = false;
        if (curManageOrg.getJobGradeIdList().contains(-1L) || manageOrg.getJobGradeIdList().contains(-1L)) {
            List<Long> jobGradeIdList = curManageOrg.getJobGradeIdList().contains(-1L) ? manageOrg.getJobGradeIdList() : curManageOrg.getJobGradeIdList();
            jobGradeIdRepeatSet.addAll(jobGradeIdList);
        } else {
            jobGradeIdRepeatSet.addAll(curManageOrg.getJobGradeIdList().stream().filter(dy -> manageOrg.getJobGradeIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (jobGradeIdRepeatSet.size() > 0) {
            repeatJobGrade = true;
            cadreType.setJobGradeIdList(new ArrayList<Long>(jobGradeIdRepeatSet));
        }
        return repeatJobGrade;
    }

    private boolean isRepeatJobLevelForJude(CadreType curManageOrg, Set<Long> jobLevelIdRepeatSet, CadreType manageOrg, CadreType cadreType) {
        boolean repeatJobLevel = false;
        if (curManageOrg.getJobLevelIdList().contains(-1L) || manageOrg.getJobLevelIdList().contains(-1L)) {
            List<Long> jobLevelIdList = curManageOrg.getJobLevelIdList().contains(-1L) ? manageOrg.getJobLevelIdList() : curManageOrg.getJobLevelIdList();
            jobLevelIdRepeatSet.addAll(jobLevelIdList);
        } else {
            jobLevelIdRepeatSet.addAll(curManageOrg.getJobLevelIdList().stream().filter(dy -> manageOrg.getJobLevelIdList().contains(dy)).collect(Collectors.toSet()));
        }
        if (jobLevelIdRepeatSet.size() > 0) {
            repeatJobLevel = true;
            cadreType.setJobLevelIdList(new ArrayList<Long>(jobLevelIdRepeatSet));
        }
        return repeatJobLevel;
    }

    private boolean isRepeatCadreCategory(CadreType curManageOrg, Set<Long> cadRepeat, CadreType manageOrg, CadreType cadreType) {
        boolean repeatCadreCategory = false;
        if (curManageOrg.getCadreCategoryId().contains(-1L) || manageOrg.getCadreCategoryId().contains(-1L)) {
            List<Long> categoryIdList = curManageOrg.getCadreCategoryId().contains(-1L) ? manageOrg.getCadreCategoryId() : curManageOrg.getCadreCategoryId();
            cadRepeat.addAll(categoryIdList);
        } else {
            cadRepeat.addAll(curManageOrg.getCadreCategoryId().stream().filter(dy -> manageOrg.getCadreCategoryId().contains(dy)).collect(Collectors.toSet()));
        }
        if (cadRepeat.size() > 0) {
            repeatCadreCategory = true;
            cadreType.setCadreCategoryId(new ArrayList<Long>(cadRepeat));
        }
        return repeatCadreCategory;
    }

    public List<String> errorMessage(List<Map<String, ManageOrgMatch>> repeatObj) {
        ArrayList<String> errorMessage = new ArrayList<String>(repeatObj.size());
        for (Map<String, ManageOrgMatch> repeatMap : repeatObj) {
            ManageOrgMatch manageOrgMatch = repeatMap.values().stream().findFirst().orElseGet(ManageOrgMatch::new);
            this.cadreTypeErrorMessage(errorMessage, manageOrgMatch);
            this.specialTypeErrorMessage(errorMessage, manageOrgMatch);
        }
        return errorMessage;
    }

    private void specialTypeErrorMessage(List<String> errorMessage, ManageOrgMatch manageOrgMatch) {
        List<SpecialType> specialTypeList = manageOrgMatch.getSpecialTypes();
        for (SpecialType specialType : specialTypeList) {
            if (1 == specialType.getErrorType()) {
                String idType = ResManager.loadKDString((String)"\u7279\u6b8a\u8eab\u4efd\u5907\u6848", (String)"MgOrgRangeSaveValidator_3", (String)"sihc-soefam-business", (Object[])new Object[0]);
                String msg = ResManager.loadKDString((String)"%1$s-%2$s\u7ec4\u5408\u4e2d\u7684\u89c4\u5219\u4e0e%3$s\u89c4\u5219\u91cd\u590d\u3002", (String)"MgOrgRangeSaveValidator_1", (String)"sihc-soefam-business", (Object[])new Object[]{idType, specialType.getGroupName(), manageOrgMatch.getRepeatMgRangName()});
                errorMessage.add(msg);
                continue;
            }
            String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u5408\u4e0e%2$s\u5728\u540c\u4e00\u884c\u653f\u7ec4\u7ec7\u4e0b\u7684\u4efb\u5c97\u6a21\u5f0f\u4e0d\u7edf\u4e00\u3002", (String)"MgOrgRangeSaveValidator_0", (String)"sihc-soefam-business", (Object[])new Object[]{specialType.getGroupName(), manageOrgMatch.getRepeatMgRangName()});
            errorMessage.add(msg);
        }
    }

    private void cadreTypeErrorMessage(List<String> errorMessage, ManageOrgMatch manageOrgMatch) {
        List<CadreType> repeatManageList = manageOrgMatch.getCadreTypes();
        for (CadreType repeatManage : repeatManageList) {
            String idType = ResManager.loadKDString((String)"\u9886\u5bfc\u5e72\u90e8\u5907\u6848", (String)"MgOrgRangeSaveValidator_2", (String)"sihc-soefam-business", (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"%1$s-%2$s\u7ec4\u5408\u4e2d\u7684\u89c4\u5219\u4e0e%3$s\u89c4\u5219\u91cd\u590d\u3002", (String)"MgOrgRangeSaveValidator_1", (String)"sihc-soefam-business", (Object[])new Object[]{idType, repeatManage.getGroupName(), manageOrgMatch.getRepeatMgRangName()});
            errorMessage.add(msg);
        }
    }
}

