/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.messagerecord;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.util.SnowFlake;
import kd.sihc.soebs.common.constants.dto.message.MessageContentDO;
import kd.sihc.soebs.common.constants.dto.message.MsgRecordDTO;
import kd.sihc.soefam.common.constants.MsgRecordConstant;
import org.jetbrains.annotations.NotNull;

public class MessageRecordDomainService
implements MsgRecordConstant {
    private static final HRBaseServiceHelper REMINDERRECORDSERVICEHELPER = new HRBaseServiceHelper("soefam_reminderrecord");

    public void updateMsgRecordsByMap(HashMap<String, Object> paramMap) {
        DynamicObject[] updateMsgStatusDynamicObject;
        QFilter qFilter = new QFilter("msglogid", "in", paramMap.get("msgid"));
        for (DynamicObject dynamicObject : updateMsgStatusDynamicObject = REMINDERRECORDSERVICEHELPER.query("msglogid,sendstatus", qFilter.toArray())) {
            dynamicObject.set("sendstatus", paramMap.get("pushstatus"));
            dynamicObject.set("msglogid", paramMap.get("msgid"));
        }
        REMINDERRECORDSERVICEHELPER.update(updateMsgStatusDynamicObject);
    }

    public DynamicObject[] getDynamicObjects(Long pkId) {
        QFilter qFilter = new QFilter("bizobj", "=", (Object)pkId);
        DynamicObject[] dynamicObjects = REMINDERRECORDSERVICEHELPER.query("bizobj,pushscene,sendchannel,sendstatus,sender,sendtime,msgcontent_tag,msglogid,msgbatchid", qFilter.toArray());
        return dynamicObjects;
    }

    public void updateIntoStorage(List<MsgRecordDTO> msgRecordDTOs) {
        DynamicObject[] dynamicObjects;
        List msgRecordDTOList = msgRecordDTOs.stream().filter(msgRecordDTO -> msgRecordDTO.getSendChannel().equals("2")).collect(Collectors.toList());
        Map<Long, List<MsgRecordDTO>> messageIdMap = msgRecordDTOList.stream().collect(Collectors.groupingBy(msgRecordDTO -> msgRecordDTO.getMsgID()));
        List msgIdList = msgRecordDTOList.stream().map(MsgRecordDTO::getMsgID).collect(Collectors.toList());
        QFilter qFilter = new QFilter("msglogid", "in", msgIdList);
        DynamicObject[] dynamicObjectArray = dynamicObjects = REMINDERRECORDSERVICEHELPER.loadDynamicObjectArray(qFilter.toArray());
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject;
            List<MsgRecordDTO> msgRecordDTOS = messageIdMap.get((dynamicObject = dynamicObjectArray[i]).get("msglogid"));
            dynamicObject.set("sendstatus", (Object)(msgRecordDTOS.get(0).getSendStatus().equals("1") ? "2" : "0"));
        }
        REMINDERRECORDSERVICEHELPER.update(dynamicObjects);
    }

    public void saveMessageByMsgIds(List<MsgRecordDTO> msgRecordDTOList) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        for (MsgRecordDTO msgRecordDTO : msgRecordDTOList) {
            for (Long aLong : msgRecordDTO.getBizObj()) {
                DynamicObject dynamicObject = REMINDERRECORDSERVICEHELPER.generateEmptyDynamicObject();
                dynamicObject.set("pushscene", (Object)msgRecordDTO.getPushScene().toString());
                dynamicObject.set("sendchannel", (Object)msgRecordDTO.getSendChannel());
                dynamicObject.set("sendstatus", (Object)msgRecordDTO.getSendStatus());
                dynamicObject.set("sender", (Object)msgRecordDTO.getSender());
                dynamicObject.set("sendtime", (Object)new Date());
                dynamicObject.set("msgcontent_tag", (Object)msgRecordDTO.getMsgContent());
                dynamicObject.set("msglogid", (Object)msgRecordDTO.getMsgID());
                dynamicObject.set("bizobj", (Object)aLong);
                dynamicObject.set("msgbatchid", (Object)msgRecordDTO.getMsgBatchId());
                dynamicObjects.add(dynamicObject);
            }
        }
        DynamicObject[] dynamicObjectsArray = new DynamicObject[dynamicObjects.size()];
        int num = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObjectsArray[num++] = dynamicObject;
        }
        REMINDERRECORDSERVICEHELPER.save(dynamicObjectsArray);
    }

    @NotNull
    public List<MsgRecordDTO> getMsgRecordDTOS(List<MessageContentDO> messageContentDOList, String pushScene) {
        SnowFlake snowFlake = new SnowFlake(2L, 3L);
        long msgBatchId = snowFlake.nextId();
        ArrayList<MsgRecordDTO> msgRecordDTOList = new ArrayList<MsgRecordDTO>(messageContentDOList.size());
        for (MessageContentDO messageContentDO : messageContentDOList) {
            MsgRecordDTO msgRecordDTO = new MsgRecordDTO();
            this.calculateMessageDTO(messageContentDO, msgRecordDTO);
            msgRecordDTO.setMsgContent(messageContentDO.getMessageContent());
            String messageChannel = MessageChannels.EMAIL.equals((Object)messageContentDO.getMessageChannel()) ? "0" : (MessageChannels.SMS.equals((Object)messageContentDO.getMessageChannel()) ? "1" : "2");
            msgRecordDTO.setSendChannel(messageChannel);
            msgRecordDTO.setMsgBatchId(Long.valueOf(msgBatchId));
            msgRecordDTO.setSender(Long.valueOf(UserServiceHelper.getCurrentUserId()));
            msgRecordDTO.setBizObj(messageContentDO.getBusObjId());
            msgRecordDTO.setSendStatus("1");
            switch (pushScene) {
                case "instoreremin": {
                    pushScene = "2010";
                    break;
                }
                case "recremain": {
                    pushScene = "2020";
                    break;
                }
                case "returnremain": {
                    pushScene = "2030";
                    break;
                }
                case "repremain": {
                    pushScene = "2040";
                    break;
                }
                case "outremain": {
                    pushScene = "2050";
                }
            }
            msgRecordDTO.setPushScene(Long.valueOf(pushScene));
            msgRecordDTOList.add(msgRecordDTO);
        }
        return msgRecordDTOList;
    }

    private void calculateMessageDTO(MessageContentDO messageContentDO, MsgRecordDTO msgRecordDTO) {
        long messageId = ORM.create().genLongId("wf_msg_message");
        messageContentDO.setMsgId(Long.valueOf(messageId));
        msgRecordDTO.setMsgID(Long.valueOf(messageId));
    }
}

