/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.domain.onbusabroadapply;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.AnimationType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.domain.filingspersonmg.helper.FilPersonMgHelper;
import kd.sihc.soefam.business.queryservice.ConCertTypeQueryService;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;

public class OnBusHandInsService {
    private static final CertlentoutregHelper CERT_LENT_OUT_REG_HELPER = CertlentoutregHelper.init();
    private static final CertreturnregHelper CERT_RETURN_REG_HELPER = CertreturnregHelper.init();
    private static final FilPersonMgHelper FIL_PERSON_MG_HELPER = FilPersonMgHelper.init();
    private static final HRBaseServiceHelper ON_BUS_ABROAD_HELPER = new HRBaseServiceHelper("soefam_onbusabroad");
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final Log LOG = LogFactory.getLog(OnBusHandInsService.class);
    private static final Map<String, String> CERT_LEND_OUT_MAP = Maps.newHashMapWithExpectedSize((int)4);

    public DynamicObject[] queryLentOutReg(Object applyId, String props, QFilter qFilter) {
        if (qFilter != null) {
            qFilter.and("faid", "=", applyId);
        } else {
            qFilter = new QFilter("faid", "=", applyId);
        }
        if (StringUtils.isEmpty((String)props)) {
            props = "id";
        }
        return CERT_LENT_OUT_REG_HELPER.query(props, qFilter.toArray());
    }

    public DynamicObject[] queryReturnReg(Object applyId, String props, QFilter qFilter) {
        if (qFilter != null) {
            qFilter.and("faid", "=", applyId);
        } else {
            qFilter = new QFilter("faid", "=", applyId);
        }
        if (StringUtils.isEmpty((String)props)) {
            props = "id";
        }
        return CERT_RETURN_REG_HELPER.query(props, qFilter.toArray());
    }

    public void showOnBusInsSightForm(Object pkId, IFormView formView) {
        HashMap paramMap;
        DynamicObject[] lentOutRegs = this.queryLentOutReg(pkId, null, null);
        DynamicObject[] returnRegs = this.queryReturnReg(pkId, null, null);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        if (lentOutRegs.length > 0) {
            this.buildContainer("flex_onbusinsight", formView, lentOutRegs[0].getString("id"), flexPanelAp);
            paramMap = Maps.newHashMapWithExpectedSize((int)4);
            paramMap.put("showType", "0");
            paramMap.put("faid", pkId);
            this.showOnBusHandInsForm("soefam_onbusinsight", formView, flexPanelAp, paramMap);
        }
        if (returnRegs.length > 0) {
            this.buildContainer("flex_onbusinsight", formView, returnRegs[0].getString("id"), flexPanelAp);
            paramMap = Maps.newHashMapWithExpectedSize((int)4);
            paramMap.put("showType", "1");
            paramMap.put("faid", pkId);
            this.showOnBusHandInsForm("soefam_onbusinsight", formView, flexPanelAp, paramMap);
        }
    }

    public void showOnBusHandInsForm(String formId, IFormView formView, FlexPanelAp flexPanelAp, Map<String, Object> paramMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setTargetKey(flexPanelAp.getKey());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParams(paramMap);
        showParameter.setAnimationType(AnimationType.none);
        formView.showForm(showParameter);
    }

    public void buildContainer(String controlKey, IFormView formView, String idStr, FlexPanelAp flexPanelAp) {
        Container container = (Container)formView.getControl(controlKey);
        flexPanelAp.setKey(container.getKey().concat(idStr));
        flexPanelAp.setGrow(0);
        container.addControls(Collections.singletonList(flexPanelAp.createControl()));
    }

    public void showOnBusInsCarForm(Object showType, Object pkId, IFormView view) {
        Assert.notNull((Object)showType);
        view.getModel().setValue("lab_datatype", showType);
        view.setVisible(Boolean.FALSE, new String[]{"certdown"});
        DynamicObject dynamicObj = ON_BUS_ABROAD_HELPER.loadSingle(pkId);
        DynamicObjectCollection onBusAbroadList = dynamicObj.getDynamicObjectCollection("concerttype");
        List<Long> conCertTypeIds = onBusAbroadList.stream().map(conCertType -> conCertType.getLong("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] sortedConCertTypes = ConCertTypeQueryService.getSortedConCertTypesByIds(conCertTypeIds);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        for (DynamicObject sortedConCertType : sortedConCertTypes) {
            this.showOnBusHandInsForm(showType, pkId, view, flexPanelAp, sortedConCertType);
        }
    }

    private void showOnBusHandInsForm(Object showType, Object pkId, IFormView view, FlexPanelAp flexPanelAp, DynamicObject dynamicObject) {
        String certTypeName = dynamicObject.getString("name");
        long certTypeId = dynamicObject.getLong("id");
        this.buildContainer("flex_certinfo", view, dynamicObject.getString("id"), flexPanelAp);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("faid", pkId);
        paramMap.put("certTypeId", certTypeId);
        paramMap.put("name", certTypeName);
        paramMap.put("showType", showType);
        this.showOnBusHandInsForm("soefam_onbusinscar", view, flexPanelAp, paramMap);
    }

    public void initCardContent(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object pkId = customParams.get("faid");
        Object showType = customParams.get("showType");
        Assert.notNull(showType);
        Label labCarName = (Label)view.getControl("lab_crename");
        labCarName.setText(customParams.get("name").toString());
        DynamicObject onBusAbroadObj = ON_BUS_ABROAD_HELPER.loadSingle(pkId);
        DynamicObjectCollection personCollection = onBusAbroadObj.getDynamicObjectCollection("vispersonentity");
        List filPerIdList = personCollection.stream().map(dynamicObject -> dynamicObject.getLong("visfilpermanage.id")).collect(Collectors.toList());
        AtomicInteger handCount = new AtomicInteger(0);
        int allCount = 0;
        switch (showType.toString()) {
            case "0": {
                allCount = this.initLendOutCar(view, customParams, pkId, personCollection, handCount);
                break;
            }
            case "1": {
                allCount = this.initReturnCar(view, customParams, pkId, personCollection, handCount);
                break;
            }
        }
        if (allCount == 0) {
            view.close();
            return;
        }
        if (view.getParentView() != null) {
            view.getParentView().setVisible(Boolean.TRUE, new String[]{"panel_content"});
            view.sendFormAction(view.getParentView());
        }
        if (handCount.get() > 0) {
            Label labSeveral = (Label)view.getControl("lab_several");
            labSeveral.setText(handCount.get() + "");
            view.setVisible(Boolean.FALSE, new String[]{"lab_complete"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"lab_several", "lab_desc"});
        }
    }

    private int initReturnCar(IFormView view, Map<String, Object> customParams, Object pkId, DynamicObjectCollection personCollection, AtomicInteger handCount) {
        DynamicObject[] dynamicObjects;
        QFilter qFilter = new QFilter("faid", "=", pkId);
        qFilter.and(new QFilter("certificate.concerttype", "=", customParams.get("certTypeId")));
        DynamicObject[] certReturnRegs = CERT_RETURN_REG_HELPER.loadDynamicObjectArray(qFilter.toArray());
        HashMap<Long, DynamicObject> certReturnRegMap = new HashMap<Long, DynamicObject>(certReturnRegs.length);
        ArrayList<Long> personIdList = new ArrayList<Long>(certReturnRegs.length);
        for (DynamicObject certReturnReg : certReturnRegs) {
            personIdList.add(certReturnReg.getLong("certificate.filperson.id"));
        }
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(personIdList.size());
        for (DynamicObject dynamicObject : dynamicObjects = FIL_PERSON_MG_HELPER.loadDynamicObjectArray(new QFilter("id", "in", personIdList).toArray())) {
            idMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("person.id"));
        }
        LOG.info("OnBusHandInsService.initLendOutCar certReturnRegs : {} idMap : {}", (Object)certReturnRegs.length, idMap);
        for (DynamicObject certReturnReg : certReturnRegs) {
            String registerState = certReturnReg.getString("registerstate");
            if (!"0".equals(registerState) && !"1".equals(registerState)) continue;
            certReturnRegMap.put((Long)idMap.get(certReturnReg.getLong("certificate.filperson.id")), certReturnReg);
            personIdList.add((Long)idMap.get(certReturnReg.getLong("certificate.filperson.id")));
        }
        Map<Object, Object> personMap = Maps.newHashMapWithExpectedSize((int)personIdList.size());
        if (personIdList.size() > 0) {
            DynamicObject[] dynamicObjectList = FIL_PERSON_MG_HELPER.loadDynamicObjectArray(new QFilter("person", "in", personIdList).toArray());
            personMap = Arrays.stream(dynamicObjectList).collect(Collectors.toMap(obj -> obj.getLong("person.id"), obj -> obj.getString("person.name"), (v1, v2) -> v1));
        }
        if (certReturnRegMap.size() == 0) {
            return 0;
        }
        this.initNewReturnCar(view, personCollection, handCount, certReturnRegMap, personMap);
        return certReturnRegMap.size();
    }

    private void initNewReturnCar(IFormView view, DynamicObjectCollection personCollection, AtomicInteger handCount, Map<Long, DynamicObject> certReturnRegMap, Map<Long, String> personMap) {
        int newEntryRow = 0;
        try {
            for (DynamicObject entity : personCollection) {
                Long visPersonId = entity.getLong("visperson.id");
                if (!certReturnRegMap.containsKey(visPersonId)) continue;
                newEntryRow = view.getModel().createNewEntryRow("entryentity");
                this.initReturnCarEntityValue(view, handCount, certReturnRegMap, personMap, newEntryRow, visPersonId);
            }
        }
        catch (Exception ex) {
            LOG.error("OnBusHandInsService.initNewReturnCar initCar error ", (Throwable)ex);
            view.getModel().deleteEntryRow("entryentity", newEntryRow);
        }
    }

    private void initReturnCarEntityValue(IFormView view, AtomicInteger handCount, Map<Long, DynamicObject> certReturnRegMap, Map<Long, String> personMap, int newEntryRow, Long visPersonId) {
        DynamicObject certReturnRegObj = certReturnRegMap.get(visPersonId);
        view.getModel().setValue("text_certname", (Object)personMap.get(visPersonId), newEntryRow);
        String registerState = certReturnRegObj.getString("registerstate");
        Date opDate = certReturnRegObj.getDate("modifytime");
        if ("0".equals(registerState)) {
            String remark = ResManager.loadKDString((String)"\u8bc1\u7167\u5f85\u5f52\u8fd8", (String)"OnBusHandInsService_3", (String)"sihc-soefam-business", (Object[])new Object[0]);
            view.getModel().setValue("text_remark", (Object)remark, newEntryRow);
            handCount.getAndAdd(1);
        } else if ("1".equals(registerState)) {
            String remark = ResManager.loadKDString((String)"\u8bc1\u7167\u4e8e {0} \u5f52\u8fd8\u3002", (String)"OnBusHandInsService_4", (String)"sihc-soefam-business", (Object[])new Object[0]);
            String remarkFormat = MessageFormat.format(remark, SIMPLE_DATE_FORMAT.format(opDate));
            view.getModel().setValue("text_remark", (Object)remarkFormat, newEntryRow);
        }
    }

    private int initLendOutCar(IFormView view, Map<String, Object> customParams, Object pkId, DynamicObjectCollection personCollection, AtomicInteger handCount) {
        DynamicObject[] personMgs;
        QFilter qFilter = new QFilter("faid", "=", (Object)Long.parseLong(pkId.toString()));
        qFilter.and(new QFilter("certificate.concerttype", "=", customParams.get("certTypeId")));
        DynamicObject[] certLendOutRegs = CERT_LENT_OUT_REG_HELPER.loadDynamicObjectArray(qFilter.toArray());
        HashMap<Long, DynamicObject> certLendOutRegMap = new HashMap<Long, DynamicObject>(certLendOutRegs.length);
        ArrayList<Long> personIdList = new ArrayList<Long>(certLendOutRegs.length);
        for (DynamicObject certLendOutReg : certLendOutRegs) {
            personIdList.add(certLendOutReg.getLong("certificate.filperson.id"));
        }
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(personIdList.size());
        for (DynamicObject personMg : personMgs = FIL_PERSON_MG_HELPER.loadDynamicObjectArray(new QFilter("id", "in", personIdList).toArray())) {
            idMap.put(personMg.getLong("id"), personMg.getLong("person.id"));
        }
        LOG.info("OnBusHandInsService.initLendOutCar certLendOutRegs : {} idMap : {}", (Object)certLendOutRegs.length, idMap);
        for (DynamicObject certLendOutReg : certLendOutRegs) {
            String registerState = certLendOutReg.getString("registerstate");
            if ("0".equals(registerState) && !CERT_LEND_OUT_MAP.containsKey(certLendOutReg.getString("certificate.managestatus"))) continue;
            certLendOutRegMap.put((Long)idMap.get(certLendOutReg.getLong("certificate.filperson.id")), certLendOutReg);
            personIdList.add((Long)idMap.get(certLendOutReg.getLong("certificate.filperson.id")));
        }
        Map<Object, Object> personMap = Maps.newHashMapWithExpectedSize((int)personIdList.size());
        if (personIdList.size() > 0) {
            DynamicObject[] dynamicObjectList = FIL_PERSON_MG_HELPER.loadDynamicObjectArray(new QFilter("person", "in", personIdList).toArray());
            personMap = Arrays.stream(dynamicObjectList).collect(Collectors.toMap(obj -> obj.getLong("person.id"), obj -> obj.getString("person.name"), (v1, v2) -> v1));
        }
        if (certLendOutRegMap.size() == 0) {
            return 0;
        }
        this.initNewEntry(view, personCollection, handCount, certLendOutRegMap, personMap);
        return certLendOutRegMap.size();
    }

    private void initNewEntry(IFormView view, DynamicObjectCollection personCollection, AtomicInteger handCount, Map<Long, DynamicObject> certLendOutRegMap, Map<Long, String> personMap) {
        LOG.info("OnBusHandInsService.initNewEntry  personMap : {}", personMap);
        int newEntryRow = 0;
        try {
            for (DynamicObject entity : personCollection) {
                Long visPersonId = entity.getLong("visperson.id");
                LOG.info("OnBusHandInsService.initNewEntry visPersonIndexId : {}", (Object)visPersonId);
                if (!certLendOutRegMap.containsKey(visPersonId)) continue;
                newEntryRow = view.getModel().createNewEntryRow("entryentity");
                this.initEntityValue(view, handCount, certLendOutRegMap, personMap, newEntryRow, visPersonId);
            }
        }
        catch (Exception ex) {
            LOG.error("OnBusHandInsService.initNewEntry initCar error ", (Throwable)ex);
            view.getModel().deleteEntryRow("entryentity", newEntryRow);
        }
    }

    private void initEntityValue(IFormView view, AtomicInteger handCount, Map<Long, DynamicObject> certLendOutRegMap, Map<Long, String> personMap, int newEntryRow, Long visPersonId) {
        DynamicObject certLentOutRegObj = certLendOutRegMap.get(visPersonId);
        view.getModel().setValue("text_certname", (Object)personMap.get(visPersonId), newEntryRow);
        String registerState = certLentOutRegObj.getString("registerstate");
        Date opDate = certLentOutRegObj.getDate("modifytime");
        if ("0".equals(registerState)) {
            String remark = ResManager.loadKDString((String)"\u8bc1\u7167\u5f85\u9886\u53d6", (String)"OnBusHandInsService_0", (String)"sihc-soefam-business", (Object[])new Object[0]);
            view.getModel().setValue("text_remark", (Object)remark, newEntryRow);
            handCount.getAndAdd(1);
        } else if ("1".equals(registerState)) {
            String remark = ResManager.loadKDString((String)"\u8bc1\u7167\u4e8e {0} \u501f\u51fa\u3002", (String)"OnBusHandInsService_1", (String)"sihc-soefam-business", (Object[])new Object[0]);
            String remarkFormat = MessageFormat.format(remark, SIMPLE_DATE_FORMAT.format(opDate));
            view.getModel().setValue("text_remark", (Object)remarkFormat, newEntryRow);
        } else if ("2".equals(registerState)) {
            String remark = ResManager.loadKDString((String)"\u8bc1\u7167\u4e8e {0} \u7ec8\u6b62\u501f\u51fa\u3002", (String)"OnBusHandInsService_5", (String)"sihc-soefam-business", (Object[])new Object[0]);
            String remarkFormat = MessageFormat.format(remark, SIMPLE_DATE_FORMAT.format(opDate));
            view.getModel().setValue("text_remark", (Object)remarkFormat, newEntryRow);
        }
    }

    static {
        CERT_LEND_OUT_MAP.put(CertManageStatusEnum.STATUS_TOLENTOUT.getKey(), CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        CERT_LEND_OUT_MAP.put(CertManageStatusEnum.STATUS_TORETURN.getKey(), CertManageStatusEnum.STATUS_TORETURN.getKey());
    }
}

