/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.service.filingsperson.FilPersonApplicationService;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class FilPersonListFormService {
    private static Log LOG = LogFactory.getLog(FilPersonListFormService.class);
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = kd.sihc.soefam.business.servicehelper.ServiceFactory.getService(FilPersonQueryService.class);
    private static final FilPersonApplicationService FIL_PERSON_APPLICATION_SERVICE = kd.sihc.soefam.business.servicehelper.ServiceFactory.getService(FilPersonApplicationService.class);
    private static final LicenseService LICENSE_SERVICE = kd.sihc.soefam.business.servicehelper.ServiceFactory.getService(LicenseService.class);

    public FormShowParameter getFormShowParameter(String pageNum, CloseCallBack closeCallBack, List<Long> selectIds, String entityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageNum);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", selectIds);
        showParameter.setCustomParam("entityId", (Object)entityId);
        return showParameter;
    }

    public FormShowParameter getModPersonFormShowParameter(String pageNum, CloseCallBack closeCallBack, List<Long> selectIds, String entityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageNum);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", selectIds);
        showParameter.setCustomParam("entityId", (Object)entityId);
        return showParameter;
    }

    public ListShowParameter getListShowParameter(CloseCallBack closeCallBack) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"soefam_filpermanag_dis", (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5907\u6848\u4eba\u5458", (String)"FilPersonListFormService_2", (String)"sihc-soefam-business", (Object[])new Object[0]));
        DynamicObject[] allPenFilPersonInfos = FIL_PERSON_QUERY_SERVICE.getAllPenFilPersonInfos();
        List collect = Arrays.stream(allPenFilPersonInfos).map(penFil -> penFil.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "not in", collect);
        qFilter.and(new QFilter("effstatus", "=", (Object)"1"));
        ArrayList<String> filingStatusList = new ArrayList<String>(10);
        filingStatusList.add("A");
        filingStatusList.add("B");
        qFilter.and(new QFilter("filingstatus", "in", filingStatusList));
        QFilter userOrgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"org");
        if (userOrgFilter != null) {
            qFilter.and(userOrgFilter);
        }
        QFilter dataRuleQFilter = HrmpExternalService.getDataRule("soefam_filpermanage");
        LOG.info("filperson.getListShowParameter.dataRuleQFilter:{}", (Object)dataRuleQFilter);
        qFilter.and(dataRuleQFilter);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        return listShowParameter;
    }

    public ListShowParameter getModPerTypeListShowParameter(CloseCallBack closeCallBack, QFilter filter) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"soefam_filpermanag_dis", (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        filter.and(new QFilter("effstatus", "!=", (Object)"0"));
        QFilter userOrgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"org");
        if (userOrgFilter != null) {
            filter.and(userOrgFilter);
        }
        QFilter dataRuleQFilter = HrmpExternalService.getDataRule("soefam_filpermanage");
        LOG.info("filperson.getListShowParameter.dataRuleQFilter:{}", (Object)dataRuleQFilter);
        filter.and(dataRuleQFilter);
        listShowParameter.getListFilterParameter().setFilter(filter);
        return listShowParameter;
    }

    public ListShowParameter getFilingListShowParameter(CloseCallBack closeCallBack, String caption, QFilter filter) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"soefam_filpermanag_batch", (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        listShowParameter.setCaption(caption);
        List<Long> userOrgFilter = this.getUserOrgFilter();
        if (userOrgFilter != null) {
            QFilter permFilter = new QFilter("org", "in", userOrgFilter);
            LOG.info("filperson.getListShowParameter.getHasPermOrgs:{}", userOrgFilter);
            filter.and(permFilter);
        }
        QFilter dataRuleQFilter = HrmpExternalService.getDataRule("soefam_filpermanage");
        LOG.info("filperson.getListShowParameter.dataRuleQFilter:{}", (Object)dataRuleQFilter);
        filter.and(dataRuleQFilter);
        listShowParameter.getListFilterParameter().setFilter(filter);
        return listShowParameter;
    }

    public List<Long> getUserOrgFilter() {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!result.hasAllOrgPerm()) {
            return result.getHasPermOrgs();
        }
        return null;
    }

    public ListShowParameter getEmployeeShowParam(CloseCallBack closeCallBack) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"hrpi_employeef7query", (boolean)true);
        para.setCloseCallBack(closeCallBack);
        para.setFormId("soebs_employeetreelist");
        para.setBillFormId("hrpi_employeef7redlist");
        para.setShowApproved(true);
        para.setShowUsed(true);
        para.setCustomParam("listmodel", (Object)"list");
        para.setCustomParam("nameKey", (Object)"person.name");
        para.setCustomParam("numberKey", (Object)"person.number");
        para.setCustomParam("ignorgDataRule", (Object)"true");
        DynamicObject[] filPersonInfo = FIL_PERSON_QUERY_SERVICE.getEmpFilPersonInfo();
        List personIds = Arrays.stream(filPersonInfo).filter(filPerson -> filPerson.get("person") != null).map(filPer -> filPer.getDynamicObject("person").getLong("id")).collect(Collectors.toList());
        if (personIds.size() != 0) {
            LOG.info("filperson.getEmployeeShowParam.personIds:{}", personIds);
            QFilter qFilter = new QFilter("person.id", "not in", personIds);
            qFilter.and(new QFilter("islatestrecord", "=", (Object)"1"));
            para.getListFilterParameter().getQFilters().add(qFilter);
        }
        return para;
    }

    public boolean checkEntityRow(IFormView view, String entityNum) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entityNum);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityNum);
        int[] selectRows = entryGrid.getSelectRows();
        if (entryEntity.size() == selectRows.length) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u884c\u6570\u636e\u3002", (String)"FilPersonListFormService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public FormShowParameter generateBosOperationResultFormShowParam(Object titleMsg, Object errorMsg, boolean showTitle) {
        FormShowParameter bosOperationResultFormShowParam = new FormShowParameter();
        bosOperationResultFormShowParam.setFormId("bos_operationresult");
        bosOperationResultFormShowParam.setShowTitle(showTitle);
        bosOperationResultFormShowParam.setCustomParam("title", titleMsg);
        bosOperationResultFormShowParam.setCustomParam("errorMsg", errorMsg);
        bosOperationResultFormShowParam.getOpenStyle().setShowType(ShowType.Modal);
        return bosOperationResultFormShowParam;
    }

    public String getPartSuccessMsg(Integer totalCount, String operationName, Integer successCount) {
        return String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"FilPersonListFormService_1", (String)"sihc-soefam-business", (Object[])new Object[0]), totalCount, operationName, successCount, totalCount - successCount);
    }

    public MultiLangEnumBridge getPartSuccessMsg() {
        return new MultiLangEnumBridge("\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", "FilPersonListFormService_1", "sihc-soefam-business");
    }

    public void addLogInfo(String bizObjId, MultiLangEnumBridge msgStr) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        String appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)"soefam");
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(bizObjId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName("addper", ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]));
        logInfo.setOpDesc(msgStr, new String[0]);
        logService.addLog((AppLogInfo)logInfo);
    }

    public void addPartSucLogInfo(String bizObjId, MultiLangEnumBridge msgStr, int totalCount, String operationName, int successCount) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        String appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)"soefam");
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(bizObjId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName("addper", ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]));
        int fail = totalCount - successCount;
        logInfo.setOpDesc(msgStr, new String[]{String.valueOf(totalCount), operationName, String.valueOf(successCount), String.valueOf(fail)});
        logService.addLog((AppLogInfo)logInfo);
    }

    public void addEmpPerOperate(IFormView view, List<Long> employeeIds, Map<Long, Map<Long, Long>> empIdAndTypeId) {
        DynamicObject[] empFilPersonInfos = FIL_PERSON_QUERY_SERVICE.getEmpFilPersonInfos(employeeIds);
        if (empFilPersonInfos.length == 0) {
            FIL_PERSON_APPLICATION_SERVICE.saveFilPersonInfo(employeeIds, empIdAndTypeId);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"FilPersonListFormService_5", (String)"sihc-soefam-business", (Object[])new Object[0]));
            MultiLangEnumBridge successMsg = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f", "FilPersonListFormService_4", "sihc-soefam-business");
            this.addLogInfo("soefam_filperlist", successMsg);
        } else if (employeeIds.size() == 1) {
            if (empFilPersonInfos[0].get("employee") != null) {
                employeeIds.remove(empFilPersonInfos[0].getLong("employee.id"));
                FIL_PERSON_APPLICATION_SERVICE.saveFilPersonInfo(employeeIds, empIdAndTypeId);
            }
            if ("1".equals(empFilPersonInfos[0].get("effstatus"))) {
                view.showErrorNotification(ResManager.loadKDString((String)"%s\u662f\u5df2\u751f\u6548\u7684\u5907\u6848\u4eba\u5458\uff0c\u65e0\u9700\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_6", (String)"sihc-soefam-business", (Object[])new Object[]{empFilPersonInfos[0].getDynamicObject("employee").get("person.name")}));
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"%s\u5728\u5f85\u8fdb\u5165\u540d\u5355\u7ba1\u7406\u4e2d\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_7", (String)"sihc-soefam-business", (Object[])new Object[]{empFilPersonInfos[0].getDynamicObject("employee").get("person.name")}));
            }
            MultiLangEnumBridge failMsg = new MultiLangEnumBridge("\u6dfb\u52a0\u5931\u8d25", "FilPersonListFormService_10", "sihc-soefam-business");
            this.addLogInfo("soefam_filperlist", failMsg);
        } else {
            int totalCount = employeeIds.size();
            int successCount = employeeIds.size() - empFilPersonInfos.length;
            String headMess = this.getPartSuccessMsg(employeeIds.size(), ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]), successCount);
            ArrayList<Long> employeeRepIds = new ArrayList<Long>(empFilPersonInfos.length);
            ArrayList<String> errorMsg = new ArrayList<String>(empFilPersonInfos.length);
            for (DynamicObject dynObj : empFilPersonInfos) {
                if (dynObj.get("employee") == null) continue;
                employeeRepIds.add(dynObj.getLong("employee.id"));
                if ("1".equals(dynObj.get("effstatus"))) {
                    errorMsg.add(ResManager.loadKDString((String)"%s\u662f\u5df2\u751f\u6548\u7684\u5907\u6848\u4eba\u5458\uff0c\u65e0\u9700\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_6", (String)"sihc-soefam-business", (Object[])new Object[]{dynObj.getDynamicObject("employee").get("person.name")}));
                    continue;
                }
                errorMsg.add(ResManager.loadKDString((String)"%s\u5728\u5f85\u8fdb\u5165\u540d\u5355\u7ba1\u7406\u4e2d\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_7", (String)"sihc-soefam-business", (Object[])new Object[]{dynObj.getDynamicObject("employee").get("person.name")}));
            }
            employeeIds.removeAll(employeeRepIds);
            FIL_PERSON_APPLICATION_SERVICE.saveFilPersonInfo(employeeIds, empIdAndTypeId);
            FormShowParameter formShowParameter = this.generateBosOperationResultFormShowParam(headMess, errorMsg, false);
            view.showForm(formShowParameter);
            MultiLangEnumBridge partSuccessMsg = this.getPartSuccessMsg();
            this.addPartSucLogInfo("soefam_filperlist", partSuccessMsg, totalCount, ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]), successCount);
        }
    }

    public void addFilingPerOperate(IFormView view, List<Long> filPerIds) {
        DynamicObject[] penFilPersonInfos = FIL_PERSON_QUERY_SERVICE.getPenFilPersonInfos(filPerIds);
        if (penFilPersonInfos.length == 0) {
            FIL_PERSON_APPLICATION_SERVICE.savePenFilPersonInfo(filPerIds);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"FilPersonListFormService_5", (String)"sihc-soefam-business", (Object[])new Object[0]));
            MultiLangEnumBridge successMsg = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f", "FilPersonListFormService_4", "sihc-soefam-business");
            this.addLogInfo("soefam_filingperpenter", successMsg);
        } else if (filPerIds.size() == 1) {
            filPerIds.remove(penFilPersonInfos[0].getLong("id"));
            FIL_PERSON_APPLICATION_SERVICE.savePenFilPersonInfo(filPerIds);
            if ("2".equals(penFilPersonInfos[0].get("listtype"))) {
                view.showErrorNotification(ResManager.loadKDString((String)"%s\u5728\u5f85\u9000\u51fa\u540d\u5355\u7ba1\u7406\u4e2d\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_8", (String)"sihc-soefam-business", (Object[])new Object[]{penFilPersonInfos[0].getDynamicObject("employee").get("person.name")}));
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"%s\u662f\u5df2\u5931\u6548\u7684\u5907\u6848\u4eba\u5458\uff0c\u65e0\u9700\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_9", (String)"sihc-soefam-business", (Object[])new Object[]{penFilPersonInfos[0].getDynamicObject("employee").get("person.name")}));
            }
            MultiLangEnumBridge failMsg = new MultiLangEnumBridge("\u6dfb\u52a0\u5931\u8d25", "FilPersonListFormService_10", "sihc-soefam-business");
            this.addLogInfo("soefam_filingperpenter", failMsg);
        } else {
            int totalCount = filPerIds.size();
            int successCount = filPerIds.size() - penFilPersonInfos.length;
            String headMess = this.getPartSuccessMsg(filPerIds.size(), ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]), filPerIds.size() - penFilPersonInfos.length);
            ArrayList<Long> filPerId = new ArrayList<Long>(penFilPersonInfos.length);
            ArrayList<String> errorMsg = new ArrayList<String>(penFilPersonInfos.length);
            for (DynamicObject dynObj : penFilPersonInfos) {
                if (dynObj.get("employee") == null) continue;
                filPerId.add(dynObj.getLong("id"));
                if ("2".equals(dynObj.get("listtype"))) {
                    errorMsg.add(ResManager.loadKDString((String)"%s\u5728\u5f85\u9000\u51fa\u540d\u5355\u7ba1\u7406\u4e2d\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_8", (String)"sihc-soefam-business", (Object[])new Object[]{dynObj.getDynamicObject("employee").get("person.name")}));
                    continue;
                }
                errorMsg.add(ResManager.loadKDString((String)"%s\u662f\u5df2\u5931\u6548\u7684\u5907\u6848\u4eba\u5458\uff0c\u65e0\u9700\u6dfb\u52a0\u3002", (String)"FilPersonListFormService_9", (String)"sihc-soefam-business", (Object[])new Object[]{dynObj.getDynamicObject("employee").get("person.name")}));
            }
            filPerIds.removeAll(filPerId);
            FIL_PERSON_APPLICATION_SERVICE.savePenFilPersonInfo(filPerIds);
            FormShowParameter formShowParameter = this.generateBosOperationResultFormShowParam(headMess, errorMsg, false);
            view.showForm(formShowParameter);
            MultiLangEnumBridge partSuccessMsg = this.getPartSuccessMsg();
            this.addPartSucLogInfo("soefam_filingperpenter", partSuccessMsg, totalCount, ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"FilPersonListFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]), successCount);
        }
    }

    public boolean checkEffectLicense(IFormView view) {
        if (!(view instanceof IListView)) {
            view.showTipNotification("only list calls are supported");
            return false;
        }
        boolean validateSecurity = false;
        Object[] primaryKeyValues = ((IListView)view).getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            view.showTipNotification("please select data");
        } else {
            DynamicObjectCollection personManageList = FIL_PERSON_QUERY_SERVICE.queryOriginalCollection("person", new QFilter("id", "in", Arrays.asList(primaryKeyValues)).toArray());
            List<Long> personIdList = personManageList.stream().map(dy -> dy.getLong("person")).distinct().collect(Collectors.toList());
            validateSecurity = LICENSE_SERVICE.isValidateSecurity(view, personIdList, "soefam_filperlist", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"FilPersonListFormService_13", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        return validateSecurity;
    }
}

