/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sihc.soebs.business.cadre.file.HspmIdentityServiceImpl;
import kd.sihc.soefam.business.application.external.PrintTemplateExternalService;
import kd.sihc.soefam.business.application.service.faapply.FaapplyApplicationService;
import kd.sihc.soefam.business.queryservice.ConCertTypeQueryService;
import kd.sihc.soefam.common.constants.faapply.FaApplyConstants;

public class ForApplyFormService
implements FaApplyConstants {
    public void queryPermission(PreOpenFormEventArgs args, String pageNum, String pageName) {
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"hssc", (String)pageNum, (String)"47150e89000000ac");
        if (!hasPerm) {
            String message = ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ForApplyFormService_8", (String)"sihc-soefam-business", (Object[])new Object[]{pageName});
            args.setCancelMessage(message);
            args.setCancel(true);
        }
    }

    public MobileBillShowParameter getMobileShowParameter(String pageNumber, Long pkId, ShowType value, AbstractFormPlugin plugin) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(pageNumber);
        if (pkId != null) {
            showParameter.setPkId((Object)pkId);
        }
        showParameter.getOpenStyle().setShowType(value);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "childViewClose"));
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        return showParameter;
    }

    public MobileFormShowParameter getApplyFeedbackShowParam(Long pkId, String pageType, String pageNumber, String prompt, AbstractFormPlugin plugin) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("soefam_applyfeedback");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("id", (Object)pkId);
        showParameter.setCustomParam("pageType", (Object)pageType);
        showParameter.setCustomParam("pageNumber", (Object)pageNumber);
        showParameter.setCustomParam("prompt", (Object)prompt);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "childViewClose"));
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        String entityId = plugin.getView().getEntityId();
        if ("soefam_proutbapply_self".equals(entityId) || "soefam_proutbapply".equals(entityId)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7", (String)"ForApplyFormService_6", (String)"sihc-soefam-business", (Object[])new Object[0]));
        } else if ("soefam_notgacapply_self".equals(entityId) || "soefam_notgacapply".equals(entityId)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7", (String)"ForApplyFormService_7", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
        return showParameter;
    }

    public void setBusFieldVisData(IFormView view) {
        String businessType = (String)view.getModel().getValue("businesstype");
        if (businessType != null && businessType.equals("0")) {
            view.setVisible(Boolean.TRUE, new String[]{"borrowflex", "abrreasonprflex", "applyreasonflex"});
            view.setVisible(Boolean.FALSE, new String[]{"idno", "idnoflex", "handleflex"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"borrowflex", "abrreasonprflex", "applyreasonflex"});
            view.setVisible(Boolean.TRUE, new String[]{"idno", "idnoflex", "handleflex"});
        }
        this.setCertMetVis(view);
    }

    public void setCertMetVis(IFormView view) {
        String cerMethod = (String)view.getModel().getValue("certrecmethod");
        if (cerMethod != null && cerMethod.equals("1")) {
            view.setVisible(Boolean.TRUE, new String[]{"posdelflex"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"posdelflex"});
        }
    }

    public void setFaMaterialVis(IFormView view) {
        Control control;
        DynamicObjectCollection faMaterialEntity = view.getModel().getEntryEntity("famaterialentity");
        boolean flag = true;
        ArrayList<Integer> rowInt = new ArrayList<Integer>(faMaterialEntity.size());
        for (int index = 0; index < faMaterialEntity.size(); ++index) {
            String isMustUpload = ((DynamicObject)faMaterialEntity.get(index)).getString("famaterialtpl.ismustupload");
            Control control2 = view.getControl("famaterialentity");
            if (!(control2 instanceof CardEntry)) continue;
            CardEntry faMaterialCardEntity = (CardEntry)view.getControl("famaterialentity");
            if (!"1".equals(isMustUpload)) {
                faMaterialCardEntity.setChildVisible(false, index, new String[]{"cardentrylineflex", "cardentrycontentflex", "famaterialatt"});
                continue;
            }
            flag = false;
            rowInt.add(index);
        }
        if (faMaterialEntity.size() == 0 || flag) {
            view.setVisible(Boolean.FALSE, new String[]{"famaterialentityflex"});
        }
        if (rowInt.size() > 0 && (control = view.getControl("famaterialentity")) instanceof CardEntry) {
            CardEntry faMaterialCardEntity = (CardEntry)view.getControl("famaterialentity");
            faMaterialCardEntity.setChildVisible(false, ((Integer)rowInt.get(0)).intValue(), new String[]{"cardentrylineflex"});
        }
    }

    public void dealIdNo(IFormView view) {
        String personId;
        Map<String, Map<String, Object>> employeeInfo;
        Map<Long, List<Map<String, Object>>> perContact;
        List<Map<String, Object>> personBaseInfo;
        DynamicObject person = view.getModel().getDataEntity().getDynamicObject("person");
        if (person != null && (personBaseInfo = (perContact = PrintTemplateExternalService.getTargetResult(employeeInfo = PrintTemplateExternalService.getContactInfoMap(Collections.singletonList(personId = person.getString("id"))), "hrpi_percre")).get(Long.parseLong(personId))) != null) {
            DynamicObject[] certObjects = FaapplyApplicationService.queryCredentialsType("1010_S");
            String certNumber = "1010_S";
            if (certObjects.length > 0) {
                certNumber = certObjects[0].getString("number");
            }
            for (Map<String, Object> map : personBaseInfo) {
                if (!certNumber.equals(map.get("credentialstype_number"))) continue;
                view.getModel().setValue("idno", map.get("number"));
                break;
            }
        }
    }

    public void dealVisaEntity(IFormView view) {
        DynamicObject[] enableConCertTypes = ConCertTypeQueryService.getEnaPriConCertTypes();
        if (enableConCertTypes.length > 0) {
            DynamicObjectCollection visaEntity = (DynamicObjectCollection)view.getModel().getValue("visaprocessentity");
            visaEntity = visaEntity.stream().filter(dynamicObject -> dynamicObject.get("ischecked").equals(true)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            view.getModel().deleteEntryData("visaprocessentity");
            view.getModel().batchCreateNewEntryRow("visaprocessentity", enableConCertTypes.length * 3);
            int num = 0;
            for (DynamicObject enableConCertType : enableConCertTypes) {
                if ("1020_S".equals(enableConCertType.getDynamicObject("credentialstype").getString("orinumber"))) {
                    view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), num);
                    view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u65b0\u529e", (String)"ForApplyFormService_1", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                    view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), ++num);
                    view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u65b0\u529e\u53ca\u7b7e\u8bc1", (String)"ForApplyFormService_2", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                    view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), ++num);
                    view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u7b7e\u8bc1", (String)"ForApplyFormService_3", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                    ++num;
                    continue;
                }
                view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), num);
                view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u65b0\u529e", (String)"ForApplyFormService_1", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), ++num);
                view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u65b0\u529e\u53ca\u7b7e\u6ce8", (String)"ForApplyFormService_4", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                view.getModel().setValue("certname", (Object)enableConCertType.getString("name"), ++num);
                view.getModel().setValue("certpromatter", (Object)ResManager.loadKDString((String)"\u7b7e\u6ce8", (String)"ForApplyFormService_5", (String)"sihc-soefam-business", (Object[])new Object[0]), num);
                ++num;
            }
            if (visaEntity.size() > 0) {
                DynamicObjectCollection newVisaEntity = (DynamicObjectCollection)view.getModel().getValue("visaprocessentity");
                for (int index = 0; index < newVisaEntity.size(); ++index) {
                    String newCertName = (String)((DynamicObject)newVisaEntity.get(index)).get("certname");
                    String newCertProMatter = (String)((DynamicObject)newVisaEntity.get(index)).get("certpromatter");
                    for (DynamicObject visa : visaEntity) {
                        String certName = (String)visa.get("certname");
                        String certProMatter = (String)visa.get("certpromatter");
                        if (!certName.equals(newCertName) || !certProMatter.equals(newCertProMatter)) continue;
                        ((DynamicObject)view.getModel().getEntryEntity("visaprocessentity").get(index)).set("ischecked", (Object)true);
                    }
                }
            }
        }
    }

    public void validNumber(IFormView view, String number) {
        Boolean isValid = new HspmIdentityServiceImpl().validIdentityCardNo(null, "CN01", number);
        if (isValid != null && !isValid.booleanValue()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ForApplyFormService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
        }
    }
}

