/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sihc.soefam.business.application.service.filingsperson.FilPerScopeApplicationService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.faapply.FaApplyConstants;

public class OnBusAbroadFormService
implements FaApplyConstants {
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = ServiceFactory.getService(FaApplyQueryService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();

    public ListShowParameter getEmployeeShowParam(DynamicObject dataEntity, CloseCallBack closeCallBack) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"hrpi_depempf7query", (boolean)true);
        DynamicObjectCollection dynObjColl = dataEntity.getDynamicObjectCollection("vispersonentity");
        List perNums = dynObjColl.stream().map(dyn -> dyn.getDynamicObject("visperson") != null ? dyn.getDynamicObject("visperson").getString("number") : null).collect(Collectors.toList());
        para.setFormId("hrcs_querylistf7");
        para.setBillFormId("hrpi_depempf7querylist");
        para.setCloseCallBack(closeCallBack);
        para.setMultiSelect(true);
        para.setShowApproved(true);
        para.setShowUsed(true);
        para.setHasRight(true);
        para.setCustomParam("listmodel", (Object)"list");
        para.setCustomParam("nameKey", (Object)"person.name");
        para.setCustomParam("numberKey", (Object)"person.number");
        QFilter filter = new QFilter("hrpi_empposorgrel.isprimary", "=", (Object)"1");
        filter.and(new QFilter("hrpi_empposorgrel.postype.id", "=", (Object)1010L));
        filter.and(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
        if (perNums.size() != 0) {
            filter.and(new QFilter("hrpi_person.number", "not in", perNums));
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        para.setListFilterParameter(listFilterParameter);
        return para;
    }

    public FormShowParameter buildOnBusLayout(String tarKey, Long primaryId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("soefam_onbusinslayout");
        showParameter.getOpenStyle().setTargetKey(tarKey);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("id", (Object)primaryId);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public void setBillTitle(BillShowParameter formShowParameter, Long pkId) {
        DynamicObject onBusAbrApplyBill = FA_APPLY_QUERY_SERVICE.getFaBillById(pkId);
        if (onBusAbrApplyBill != null) {
            String groupName = onBusAbrApplyBill.getString("groupname");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u56e0\u516c\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7-%s", (String)"OnBusAbroadFormService_0", (String)"sihc-soefam-business", (Object[])new Object[]{groupName}));
        }
    }

    public void setAccPerFlexVis(IFormView view) {
        Tab tab = (Tab)view.getControl("tabap");
        DynamicObjectCollection inDynObjColl = view.getModel().getDataEntity(true).getDynamicObjectCollection("vispersonentity");
        DynamicObjectCollection outDynObjColl = view.getModel().getDataEntity(true).getDynamicObjectCollection("outentryentity");
        if (inDynObjColl.size() == 0 && outDynObjColl.size() == 0) {
            view.setVisible(Boolean.TRUE, new String[]{"notpersonflex"});
            view.setVisible(Boolean.FALSE, new String[]{"personflex"});
        } else if (inDynObjColl.size() == 0) {
            view.setVisible(Boolean.TRUE, new String[]{"personflex", "outtabpage"});
            view.setVisible(Boolean.FALSE, new String[]{"notpersonflex", "intabpage"});
            tab.selectTab("outtabpage");
        } else if (outDynObjColl.size() == 0) {
            view.setVisible(Boolean.TRUE, new String[]{"personflex", "intabpage"});
            view.setVisible(Boolean.FALSE, new String[]{"notpersonflex", "outtabpage"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"personflex", "intabpage", "outtabpage"});
            view.setVisible(Boolean.FALSE, new String[]{"notpersonflex"});
        }
        String curTab = tab.getCurrentTab();
        view.setVisible(Boolean.FALSE, new String[]{"sysindel", "sysoutdel"});
        if ("intabpage".equals(curTab)) {
            view.setVisible(Boolean.TRUE, new String[]{"sysindel"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"sysoutdel"});
        }
    }

    public void setInSysPersonEntity(List<Long> demIds, IFormView view) {
        DynamicObject[] depEmpInfo = FA_APPLY_QUERY_SERVICE.getDepEmpInfo(demIds);
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("visperson", new Object[0]);
        tableValueSetter.addField("visdepemp", new Object[0]);
        tableValueSetter.addField("visfilpermanage", new Object[0]);
        tableValueSetter.addField("visrecpersontype", new Object[0]);
        tableValueSetter.addField("affcompany", new Object[0]);
        tableValueSetter.addField("inorg", new Object[0]);
        tableValueSetter.addField("inposition", new Object[0]);
        List<Long> depEmpIds = Arrays.stream(depEmpInfo).map(depEmp -> depEmp.getLong("id")).collect(Collectors.toList());
        DynamicObject[] empPosDynObjs = FilPerScopeApplicationService.listEmpPosOrgRelDys(depEmpIds);
        HashMap<Long, Map<String, Object>> empPosMap = new HashMap<Long, Map<String, Object>>(empPosDynObjs.length);
        for (DynamicObject dynObj : empPosDynObjs) {
            empPosMap.put(dynObj.getLong("depemp.id"), this.depEmpDynObjToMap(dynObj));
        }
        List<Long> personIds = Arrays.stream(depEmpInfo).map(depEmp -> depEmp.getDynamicObject("person") != null ? depEmp.getLong("person.id") : 0L).collect(Collectors.toList());
        DynamicObject[] filPersons = FILPERSONMG_APPLICATION_SERVICE.getFilPersonByPersons(personIds);
        HashMap<Long, DynamicObject> filPersonMap = new HashMap<Long, DynamicObject>(filPersons.length);
        for (DynamicObject dynObj : filPersons) {
            Long personId = dynObj.getDynamicObject("person") != null ? dynObj.getDynamicObject("person").getLong("id") : 0L;
            filPersonMap.put(personId, dynObj);
        }
        for (DynamicObject depEmp2 : depEmpInfo) {
            DynamicObject person = depEmp2.getDynamicObject("person");
            Long personId = person != null ? Long.valueOf(person.getLong("id")) : null;
            Long depEmpId = depEmp2.getLong("id");
            Map empPosOrgRel = (Map)empPosMap.get(depEmpId);
            DynamicObject filPerson = (DynamicObject)filPersonMap.get(personId);
            Long filPersonId = null;
            Long filPersonTypeId = null;
            if (filPerson != null) {
                filPersonId = filPerson.getLong("id");
                filPersonTypeId = filPerson.get("recpersontype") != null ? Long.valueOf(filPerson.getDynamicObject("recpersontype").getLong("id")) : null;
            }
            Long companyId = (Long)empPosOrgRel.get("company_id");
            Long adminOrgId = (Long)empPosOrgRel.get("adminorg_id");
            Long positionId = (Long)empPosOrgRel.get("position_id");
            tableValueSetter.addRow(new Object[]{personId, depEmpId, filPersonId, filPersonTypeId, companyId, adminOrgId, positionId});
        }
        model.batchCreateNewEntryRow("vispersonentity", tableValueSetter);
        model.endInit();
    }

    public Map<String, Object> depEmpDynObjToMap(DynamicObject dynObj) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("employee_id", dynObj.getDynamicObject("employee") != null ? dynObj.getLong("employee.id") : 0L);
        map.put("company_id", dynObj.getDynamicObject("company") != null ? dynObj.getLong("company.id") : 0L);
        map.put("adminorg_id", dynObj.getDynamicObject("adminorg") != null ? dynObj.getLong("adminorg.id") : 0L);
        map.put("position_id", dynObj.getDynamicObject("position") != null ? dynObj.getLong("position.id") : 0L);
        return map;
    }
}

