/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.enums.MesReminderFlagNameEnum;
import org.apache.commons.collections4.MapUtils;

public class SelectPersonFormService {
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);

    public void initFilPerInfo(IFormView formView) {
        CardEntry cardEntry;
        List<Long> certIds = this.getSelectedCertIds(formView);
        this.updateFilPerInfo(formView, SerializationUtils.toJsonString(certIds));
        DynamicObject[] certDynObj = CERTIFICATE_QUERY_SERVICE.queryOrderNumById("id,filperson,managestatus", certIds, null);
        if (certDynObj == null || certDynObj.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> certMap = this.getPerInfoMap(certDynObj);
        if (MapUtils.isEmpty(certMap)) {
            return;
        }
        int showNumber = certMap.size();
        if (showNumber == 1) {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"deleteap"});
        } else {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(true, 0, new String[]{"deleteap"});
        }
        String entityId = formView.getEntityId();
        if ("soefam_selectperson".equals(entityId)) {
            showNumber = 10;
            this.updateSelectFilPerNumberLabel(formView, certDynObj, certMap.size());
            this.setViewBtnVisible(certMap.size(), formView);
        }
        this.setEntityValue(formView, certMap, showNumber);
        formView.updateView("entryentity");
    }

    private void setViewBtnVisible(int size, IFormView formView) {
        Boolean showViewBtnFlag = size > 10;
        formView.setVisible(showViewBtnFlag, new String[]{"labelap"});
    }

    private void setEntityValue(IFormView formView, Map<Long, List<DynamicObject>> certMap, int showNumber) {
        String opType = (String)formView.getFormShowParameter().getCustomParam("parameteroptype");
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("picturefield", new Object[0]);
        tableValueSetter.addField("name", new Object[0]);
        tableValueSetter.addField("id", new Object[0]);
        tableValueSetter.addField("certnum", new Object[0]);
        int num = 0;
        for (Map.Entry<Long, List<DynamicObject>> entry : certMap.entrySet()) {
            if (num < showNumber) {
                DynamicObject certInfo = entry.getValue().get(0).getDynamicObject("filperson");
                tableValueSetter.addRow(new Object[]{certInfo.get("person.headsculpture"), certInfo.get("person.name") + "(" + certInfo.get("person.number") + ")", entry.getKey(), MesReminderFlagNameEnum.valueByKey((String)opType).getDesc() + "\uff1a" + entry.getValue().size()});
            }
            ++num;
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
    }

    private void updateSelectFilPerNumberLabel(IFormView formView, DynamicObject[] certDynObj, int showNumber) {
        String text = String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08\u5171%1$s\u4eba\uff0c%2$s\u4efd\u8bc1\u7167\uff09", (String)"SelectPersonFormService_0", (String)"sihc-soefam-business", (Object[])new Object[0]), showNumber, certDynObj.length);
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
        props.put("text", new LocaleString(text));
        if (formView.getParentView() != null) {
            formView.getParentView().updateControlMetadata("selectperflex", props);
            formView.sendFormAction(formView.getParentView());
        }
    }

    public Map<Long, List<DynamicObject>> getPerInfoMap(DynamicObject[] certDynObj) {
        LinkedHashMap<Long, List<DynamicObject>> certMap = new LinkedHashMap<Long, List<DynamicObject>>(certDynObj.length);
        for (DynamicObject certDyn : certDynObj) {
            if (certDyn.get("filperson") == null) continue;
            Long filPerId = certDyn.getDynamicObject("filperson").getLong("id");
            if (certMap.get(filPerId) != null) {
                ((List)certMap.get(filPerId)).add(certDyn);
                continue;
            }
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1);
            dynamicObjects.add(certDyn);
            certMap.put(filPerId, dynamicObjects);
        }
        return certMap;
    }

    public List<Long> getSelectedCertIds(IFormView formView) {
        String certIdListStr = this.getSelectedCertIdListStr(formView);
        if (HRStringUtils.isEmpty((String)certIdListStr)) {
            return Collections.emptyList();
        }
        List FilPerIds = SerializationUtils.fromJsonStringToList((String)certIdListStr, Long.class);
        return FilPerIds;
    }

    public String getSelectedCertIdListStr(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String certIdListStr = formView.getPageCache().get("filperid");
        if (certIdListStr == null || HRStringUtils.isEmpty((String)certIdListStr)) {
            certIdListStr = formShowParameter.getCustomParam("id").toString();
        }
        return certIdListStr;
    }

    public void deleteFilPers(IFormView formView) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        Long removeFilPerId = dataEntitys[selectRows[0]].getLong("id");
        formView.getModel().deleteEntryRows("entryentity", selectRows);
        DynamicObject[] certDynObj = CERTIFICATE_QUERY_SERVICE.queryAllByFilPerson(Collections.singletonList(removeFilPerId));
        List remCertIds = Arrays.stream(certDynObj).map(certDyn -> certDyn.getLong("id")).collect(Collectors.toList());
        List<Long> certIds = this.getSelectedCertIds(formView);
        certIds.removeAll(remCertIds);
        this.updateFilPerInfo(formView, SerializationUtils.toJsonString(certIds));
    }

    public void updateFilPerInfo(IFormView formView, String filPerIdStr) {
        formView.getPageCache().put("filperid", filPerIdStr);
    }
}

